/*
 * Decompiled with CFR 0.152.
 */
package com.onelogin.saml2;

import com.onelogin.saml2.authn.AuthnRequest;
import com.onelogin.saml2.authn.AuthnRequestParams;
import com.onelogin.saml2.authn.SamlResponse;
import com.onelogin.saml2.exception.Error;
import com.onelogin.saml2.exception.SettingsException;
import com.onelogin.saml2.factory.SamlMessageFactory;
import com.onelogin.saml2.http.HttpRequest;
import com.onelogin.saml2.http.HttpRequestUtils;
import com.onelogin.saml2.http.HttpResponse;
import com.onelogin.saml2.http.HttpResponseUtils;
import com.onelogin.saml2.logout.LogoutRequest;
import com.onelogin.saml2.logout.LogoutRequestParams;
import com.onelogin.saml2.logout.LogoutResponse;
import com.onelogin.saml2.logout.LogoutResponseParams;
import com.onelogin.saml2.model.KeyStoreSettings;
import com.onelogin.saml2.model.SamlResponseStatus;
import com.onelogin.saml2.settings.Saml2Settings;
import com.onelogin.saml2.settings.SettingsBuilder;
import com.onelogin.saml2.util.Util;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SignatureException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Auth {
    private static final Logger LOGGER = LoggerFactory.getLogger(Auth.class);
    private Saml2Settings settings;
    private HttpRequest request;
    private HttpResponse response;
    private String nameid;
    private String nameidFormat;
    private String nameidNameQualifier;
    private String nameidSPNameQualifier;
    private String sessionIndex;
    private Instant sessionExpiration;
    private String lastMessageId;
    private Calendar lastMessageIssueInstant;
    private String lastAssertionId;
    private List<Instant> lastAssertionNotOnOrAfter;
    private Map<String, List<String>> attributes = new LinkedHashMap<String, List<String>>();
    private boolean authenticated = false;
    private List<String> errors = new ArrayList<String>();
    private String errorReason;
    private Exception validationException;
    private String lastRequestId;
    private Calendar lastRequestIssueInstant;
    private String lastRequest;
    private String lastResponse;
    private static final SamlMessageFactory DEFAULT_SAML_MESSAGE_FACTORY = new SamlMessageFactory(){};
    private SamlMessageFactory samlMessageFactory = DEFAULT_SAML_MESSAGE_FACTORY;

    public Auth() throws IOException, SettingsException, Error {
        this(new SettingsBuilder().fromFile("onelogin.saml.properties").build(), null, null);
    }

    public Auth(KeyStoreSettings keyStoreSetting) throws IOException, SettingsException, Error {
        this("onelogin.saml.properties", keyStoreSetting);
    }

    public Auth(String filename) throws IOException, SettingsException, Error {
        this(filename, null, null, null);
    }

    public Auth(String filename, KeyStoreSettings keyStoreSetting) throws IOException, SettingsException, Error {
        this(new SettingsBuilder().fromFile(filename, keyStoreSetting).build(), null, null);
    }

    public Auth(HttpRequest request, HttpResponse response) throws IOException, SettingsException, Error {
        this(new SettingsBuilder().fromFile("onelogin.saml.properties").build(), request, response);
    }

    public Auth(KeyStoreSettings keyStoreSetting, HttpRequest request, HttpResponse response) throws IOException, SettingsException, Error {
        this(new SettingsBuilder().fromFile("onelogin.saml.properties", keyStoreSetting).build(), request, response);
    }

    public Auth(String filename, HttpRequest request, HttpResponse response) throws SettingsException, IOException, Error {
        this(filename, null, request, response);
    }

    public Auth(String filename, KeyStoreSettings keyStoreSetting, HttpRequest request, HttpResponse response) throws SettingsException, IOException, Error {
        this(new SettingsBuilder().fromFile(filename, keyStoreSetting).build(), request, response);
    }

    public Auth(Saml2Settings settings, HttpRequest request, HttpResponse response) throws SettingsException {
        this.settings = settings;
        this.request = request;
        this.response = response;
        List settingsErrors = settings.checkSettings();
        if (!settingsErrors.isEmpty()) {
            String errorMsg = "Invalid settings: ";
            errorMsg = errorMsg + StringUtils.join((Iterable)settingsErrors, (String)", ");
            LOGGER.error(errorMsg);
            throw new SettingsException(errorMsg, 2);
        }
        LOGGER.debug("Settings validated");
    }

    public void setStrict(Boolean value) {
        this.settings.setStrict(value.booleanValue());
    }

    @Deprecated
    public String login(String relayState, Boolean forceAuthn, Boolean isPassive, Boolean setNameIdPolicy, Boolean stay, String nameIdValueReq) throws IOException, SettingsException {
        HashMap<String, String> parameters = new HashMap<String, String>();
        return this.login(relayState, new AuthnRequestParams(forceAuthn.booleanValue(), isPassive.booleanValue(), setNameIdPolicy.booleanValue(), nameIdValueReq), stay, parameters);
    }

    @Deprecated
    public String login(String relayState, Boolean forceAuthn, Boolean isPassive, Boolean setNameIdPolicy, Boolean stay, String nameIdValueReq, Map<String, String> parameters) throws IOException, SettingsException {
        return this.login(relayState, new AuthnRequestParams(forceAuthn.booleanValue(), isPassive.booleanValue(), setNameIdPolicy.booleanValue(), nameIdValueReq), stay, parameters);
    }

    @Deprecated
    public String login(String relayState, Boolean forceAuthn, Boolean isPassive, Boolean setNameIdPolicy, Boolean stay) throws IOException, SettingsException {
        return this.login(relayState, new AuthnRequestParams(forceAuthn.booleanValue(), isPassive.booleanValue(), setNameIdPolicy.booleanValue()), stay, null);
    }

    @Deprecated
    public void login(String relayState, Boolean forceAuthn, Boolean isPassive, Boolean setNameIdPolicy) throws IOException, SettingsException {
        this.login(relayState, new AuthnRequestParams(forceAuthn.booleanValue(), isPassive.booleanValue(), setNameIdPolicy.booleanValue()), false);
    }

    public void login() throws IOException, SettingsException {
        this.login(null, new AuthnRequestParams(false, false, true));
    }

    public void login(AuthnRequestParams authnRequestParams) throws IOException, SettingsException {
        this.login(null, authnRequestParams);
    }

    public void login(String relayState) throws IOException, SettingsException {
        this.login(relayState, new AuthnRequestParams(false, false, true));
    }

    public void login(String relayState, AuthnRequestParams authnRequestParams) throws IOException, SettingsException {
        this.login(relayState, authnRequestParams, false);
    }

    public String login(String relayState, AuthnRequestParams authnRequestParams, Boolean stay) throws IOException, SettingsException {
        return this.login(relayState, authnRequestParams, stay, new HashMap<String, String>());
    }

    public String login(String relayState, AuthnRequestParams authnRequestParams, Boolean stay, Map<String, String> parameters) throws IOException, SettingsException {
        AuthnRequest authnRequest = this.samlMessageFactory.createAuthnRequest(this.settings, authnRequestParams);
        if (parameters == null) {
            parameters = new HashMap<String, String>();
        }
        String samlRequest = authnRequest.getEncodedAuthnRequest();
        parameters.put("SAMLRequest", samlRequest);
        if (relayState == null) {
            relayState = HttpRequestUtils.getSelfRoutedURLNoQuery((HttpRequest)this.request);
        }
        if (!relayState.isEmpty()) {
            parameters.put("RelayState", relayState);
        }
        if (this.settings.getAuthnRequestsSigned()) {
            String sigAlg = this.settings.getSignatureAlgorithm();
            String signature = this.buildRequestSignature(samlRequest, relayState, sigAlg);
            parameters.put("SigAlg", sigAlg);
            parameters.put("Signature", signature);
        }
        String ssoUrl = this.getSSOurl();
        this.lastRequestId = authnRequest.getId();
        this.lastRequestIssueInstant = authnRequest.getIssueInstant();
        this.lastRequest = authnRequest.getAuthnRequestXml();
        if (!stay.booleanValue()) {
            LOGGER.debug("AuthNRequest sent to " + ssoUrl + " --> " + samlRequest);
        }
        return HttpResponseUtils.sendRedirect((HttpResponse)this.response, (String)ssoUrl, parameters, (Boolean)stay);
    }

    public String logout(String relayState, LogoutRequestParams logoutRequestParams, Boolean stay) throws IOException, SettingsException {
        HashMap<String, String> parameters = new HashMap<String, String>();
        return this.logout(relayState, logoutRequestParams, stay, parameters);
    }

    public void logout(String relayState, LogoutRequestParams logoutRequestParams) throws IOException, SettingsException {
        this.logout(relayState, logoutRequestParams, false);
    }

    public String logout(String relayState, String nameId, String sessionIndex, Boolean stay, String nameidFormat, String nameIdNameQualifier, String nameIdSPNameQualifier) throws IOException, SettingsException {
        HashMap<String, String> parameters = new HashMap<String, String>();
        return this.logout(relayState, new LogoutRequestParams(sessionIndex, nameId, nameidFormat, nameIdNameQualifier, nameIdSPNameQualifier), stay, parameters);
    }

    public String logout(String relayState, LogoutRequestParams logoutRequestParams, Boolean stay, Map<String, String> parameters) throws IOException, SettingsException {
        if (parameters == null) {
            parameters = new HashMap<String, String>();
        }
        LogoutRequest logoutRequest = this.samlMessageFactory.createOutgoingLogoutRequest(this.settings, logoutRequestParams);
        String samlLogoutRequest = logoutRequest.getEncodedLogoutRequest();
        parameters.put("SAMLRequest", samlLogoutRequest);
        if (relayState == null) {
            relayState = HttpRequestUtils.getSelfRoutedURLNoQuery((HttpRequest)this.request);
        }
        if (!relayState.isEmpty()) {
            parameters.put("RelayState", relayState);
        }
        if (this.settings.getLogoutRequestSigned()) {
            String sigAlg = this.settings.getSignatureAlgorithm();
            String signature = this.buildRequestSignature(samlLogoutRequest, relayState, sigAlg);
            parameters.put("SigAlg", sigAlg);
            parameters.put("Signature", signature);
        }
        String sloUrl = this.getSLOurl();
        this.lastRequestId = logoutRequest.getId();
        this.lastRequestIssueInstant = logoutRequest.getIssueInstant();
        this.lastRequest = logoutRequest.getLogoutRequestXml();
        if (!stay.booleanValue()) {
            LOGGER.debug("Logout request sent to " + sloUrl + " --> " + samlLogoutRequest);
        }
        return HttpResponseUtils.sendRedirect((HttpResponse)this.response, (String)sloUrl, parameters, (Boolean)stay);
    }

    @Deprecated
    public String logout(String relayState, String nameId, String sessionIndex, Boolean stay, String nameidFormat, String nameIdNameQualifier, String nameIdSPNameQualifier, Map<String, String> parameters) throws IOException, SettingsException {
        return this.logout(relayState, new LogoutRequestParams(sessionIndex, nameId, nameidFormat, nameIdNameQualifier, nameIdSPNameQualifier), stay, parameters);
    }

    @Deprecated
    public String logout(String relayState, String nameId, String sessionIndex, Boolean stay, String nameidFormat, String nameIdNameQualifier) throws IOException, SettingsException {
        return this.logout(relayState, new LogoutRequestParams(sessionIndex, nameId, nameidFormat, nameIdNameQualifier), stay, null);
    }

    @Deprecated
    public String logout(String relayState, String nameId, String sessionIndex, Boolean stay, String nameidFormat) throws IOException, SettingsException {
        return this.logout(relayState, new LogoutRequestParams(sessionIndex, nameId, nameidFormat), stay, null);
    }

    @Deprecated
    public String logout(String relayState, String nameId, String sessionIndex, Boolean stay) throws IOException, SettingsException {
        return this.logout(relayState, new LogoutRequestParams(sessionIndex, nameId), stay, null);
    }

    @Deprecated
    public void logout(String relayState, String nameId, String sessionIndex, String nameidFormat, String nameIdNameQualifier, String nameIdSPNameQualifier) throws IOException, SettingsException {
        this.logout(relayState, new LogoutRequestParams(sessionIndex, nameId, nameidFormat, nameIdNameQualifier, nameIdSPNameQualifier), false);
    }

    @Deprecated
    public void logout(String relayState, String nameId, String sessionIndex, String nameidFormat, String nameIdNameQualifier) throws IOException, SettingsException {
        this.logout(relayState, new LogoutRequestParams(sessionIndex, nameId, nameidFormat, nameIdNameQualifier), false);
    }

    @Deprecated
    public void logout(String relayState, String nameId, String sessionIndex, String nameidFormat) throws IOException, SettingsException {
        this.logout(relayState, new LogoutRequestParams(sessionIndex, nameId, nameidFormat), false);
    }

    @Deprecated
    public void logout(String relayState, String nameId, String sessionIndex) throws IOException, SettingsException {
        this.logout(relayState, new LogoutRequestParams(sessionIndex, nameId), false, null);
    }

    public void logout() throws IOException, SettingsException {
        this.logout(null, new LogoutRequestParams(), false);
    }

    public void logout(String relayState) throws IOException, SettingsException {
        this.logout(relayState, new LogoutRequestParams(), false);
    }

    public String getSSOurl() {
        return this.settings.getIdpSingleSignOnServiceUrl().toString();
    }

    public String getSLOurl() {
        return this.settings.getIdpSingleLogoutServiceUrl().toString();
    }

    public String getSLOResponseUrl() {
        return this.settings.getIdpSingleLogoutServiceResponseUrl().toString();
    }

    public void processResponse(String requestId) throws Exception {
        this.authenticated = false;
        String samlResponseParameter = this.request.getParameter("SAMLResponse");
        if (samlResponseParameter != null) {
            SamlResponse samlResponse = this.samlMessageFactory.createSamlResponse(this.settings, this.request);
            this.lastResponse = samlResponse.getSAMLResponseXml();
            if (samlResponse.isValid(requestId)) {
                this.nameid = samlResponse.getNameId();
                this.nameidFormat = samlResponse.getNameIdFormat();
                this.nameidNameQualifier = samlResponse.getNameIdNameQualifier();
                this.nameidSPNameQualifier = samlResponse.getNameIdSPNameQualifier();
                this.authenticated = true;
                this.attributes = samlResponse.getAttributes();
                this.sessionIndex = samlResponse.getSessionIndex();
                this.sessionExpiration = samlResponse.getSessionNotOnOrAfter();
                this.lastMessageId = samlResponse.getId();
                this.lastMessageIssueInstant = samlResponse.getResponseIssueInstant();
                this.lastAssertionId = samlResponse.getAssertionId();
                this.lastAssertionNotOnOrAfter = samlResponse.getAssertionNotOnOrAfter();
                LOGGER.debug("processResponse success --> " + samlResponseParameter);
            } else {
                this.errorReason = samlResponse.getError();
                this.validationException = samlResponse.getValidationException();
                SamlResponseStatus samlResponseStatus = samlResponse.getResponseStatus();
                if (samlResponseStatus.getStatusCode() == null || !samlResponseStatus.getStatusCode().equals("urn:oasis:names:tc:SAML:2.0:status:Success")) {
                    this.errors.add("response_not_success");
                    LOGGER.error("processResponse error. sso_not_success");
                    LOGGER.debug(" --> " + samlResponseParameter);
                    this.errors.add(samlResponseStatus.getStatusCode());
                    if (samlResponseStatus.getSubStatusCode() != null) {
                        this.errors.add(samlResponseStatus.getSubStatusCode());
                    }
                } else {
                    this.errors.add("invalid_response");
                    LOGGER.error("processResponse error. invalid_response");
                    LOGGER.debug(" --> " + samlResponseParameter);
                }
            }
        } else {
            this.errors.add("invalid_binding");
            String errorMsg = "SAML Response not found, Only supported HTTP_POST Binding";
            LOGGER.error("processResponse error." + errorMsg);
            throw new Error(errorMsg, 3);
        }
    }

    public void processResponse() throws Exception {
        this.processResponse(null);
    }

    public String processSLO(Boolean keepLocalSession, String requestId, Boolean stay) throws Exception {
        String samlRequestParameter = this.request.getParameter("SAMLRequest");
        String samlResponseParameter = this.request.getParameter("SAMLResponse");
        if (samlResponseParameter != null) {
            LogoutResponse logoutResponse = this.samlMessageFactory.createIncomingLogoutResponse(this.settings, this.request);
            this.lastResponse = logoutResponse.getLogoutResponseXml();
            if (!logoutResponse.isValid(requestId).booleanValue()) {
                this.errors.add("invalid_logout_response");
                LOGGER.error("processSLO error. invalid_logout_response");
                LOGGER.debug(" --> " + samlResponseParameter);
                this.errorReason = logoutResponse.getError();
                this.validationException = logoutResponse.getValidationException();
            } else {
                SamlResponseStatus samlResponseStatus = logoutResponse.getSamlResponseStatus();
                String status = samlResponseStatus.getStatusCode();
                if (status == null || !status.equals("urn:oasis:names:tc:SAML:2.0:status:Success")) {
                    this.errors.add("logout_not_success");
                    LOGGER.error("processSLO error. logout_not_success");
                    LOGGER.debug(" --> " + samlResponseParameter);
                    this.errors.add(samlResponseStatus.getStatusCode());
                    if (samlResponseStatus.getSubStatusCode() != null) {
                        this.errors.add(samlResponseStatus.getSubStatusCode());
                    }
                } else {
                    this.lastMessageId = logoutResponse.getId();
                    this.lastMessageIssueInstant = logoutResponse.getIssueInstant();
                    LOGGER.debug("processSLO success --> " + samlResponseParameter);
                    if (!keepLocalSession.booleanValue()) {
                        this.request.invalidateSession();
                    }
                }
            }
            return null;
        }
        if (samlRequestParameter != null) {
            LogoutRequest logoutRequest = this.samlMessageFactory.createIncomingLogoutRequest(this.settings, this.request);
            this.lastRequest = logoutRequest.getLogoutRequestXml();
            if (!logoutRequest.isValid().booleanValue()) {
                this.errors.add("invalid_logout_request");
                LOGGER.error("processSLO error. invalid_logout_request");
                LOGGER.debug(" --> " + samlRequestParameter);
                this.errorReason = logoutRequest.getError();
                this.validationException = logoutRequest.getValidationException();
                return null;
            }
            this.lastMessageId = logoutRequest.getId();
            this.lastMessageIssueInstant = logoutRequest.getIssueInstant();
            LOGGER.debug("processSLO success --> " + samlRequestParameter);
            if (!keepLocalSession.booleanValue()) {
                this.request.invalidateSession();
            }
            String inResponseTo = logoutRequest.id;
            LogoutResponse logoutResponseBuilder = this.samlMessageFactory.createOutgoingLogoutResponse(this.settings, new LogoutResponseParams(inResponseTo, "urn:oasis:names:tc:SAML:2.0:status:Success"));
            this.lastResponse = logoutResponseBuilder.getLogoutResponseXml();
            String samlLogoutResponse = logoutResponseBuilder.getEncodedLogoutResponse();
            LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
            parameters.put("SAMLResponse", samlLogoutResponse);
            String relayState = this.request.getParameter("RelayState");
            if (relayState != null) {
                parameters.put("RelayState", relayState);
            }
            if (this.settings.getLogoutResponseSigned()) {
                String sigAlg = this.settings.getSignatureAlgorithm();
                String signature = this.buildResponseSignature(samlLogoutResponse, relayState, sigAlg);
                parameters.put("SigAlg", sigAlg);
                parameters.put("Signature", signature);
            }
            String sloUrl = this.getSLOResponseUrl();
            if (!stay.booleanValue()) {
                LOGGER.debug("Logout response sent to " + sloUrl + " --> " + samlLogoutResponse);
            }
            return HttpResponseUtils.sendRedirect((HttpResponse)this.response, (String)sloUrl, parameters, (Boolean)stay);
        }
        this.errors.add("invalid_binding");
        String errorMsg = "SAML LogoutRequest/LogoutResponse not found. Only supported HTTP_REDIRECT Binding";
        LOGGER.error("processSLO error." + errorMsg);
        throw new Error(errorMsg, 4);
    }

    public void processSLO(Boolean keepLocalSession, String requestId) throws Exception {
        this.processSLO(keepLocalSession, requestId, false);
    }

    public void processSLO() throws Exception {
        this.processSLO(false, null);
    }

    public final boolean isAuthenticated() {
        return this.authenticated;
    }

    public final List<String> getAttributesName() {
        return new ArrayList<String>(this.attributes.keySet());
    }

    public final Map<String, List<String>> getAttributes() {
        return this.attributes;
    }

    public final Collection<String> getAttribute(String name) {
        return this.attributes.get(name);
    }

    public final String getNameId() {
        return this.nameid;
    }

    public final String getNameIdFormat() {
        return this.nameidFormat;
    }

    public final String getNameIdNameQualifier() {
        return this.nameidNameQualifier;
    }

    public final String getNameIdSPNameQualifier() {
        return this.nameidSPNameQualifier;
    }

    public final String getSessionIndex() {
        return this.sessionIndex;
    }

    public final Instant getSessionExpiration() {
        return this.sessionExpiration;
    }

    public String getLastMessageId() {
        return this.lastMessageId;
    }

    public Calendar getLastMessageIssueInstant() {
        return this.lastMessageIssueInstant;
    }

    public String getLastAssertionId() {
        return this.lastAssertionId;
    }

    public List<Instant> getLastAssertionNotOnOrAfter() {
        return this.lastAssertionNotOnOrAfter;
    }

    public List<String> getErrors() {
        return this.errors;
    }

    public String getLastErrorReason() {
        return this.errorReason;
    }

    public Exception getLastValidationException() {
        return this.validationException;
    }

    public String getLastRequestId() {
        return this.lastRequestId;
    }

    public Calendar getLastRequestIssueInstant() {
        return this.lastRequestIssueInstant;
    }

    public Saml2Settings getSettings() {
        return this.settings;
    }

    public Boolean isDebugActive() {
        return this.settings.isDebugActive();
    }

    public String buildRequestSignature(String samlRequest, String relayState, String signAlgorithm) throws SettingsException {
        return this.buildSignature(samlRequest, relayState, signAlgorithm, "SAMLRequest");
    }

    public String buildResponseSignature(String samlResponse, String relayState, String signAlgorithm) throws SettingsException {
        return this.buildSignature(samlResponse, relayState, signAlgorithm, "SAMLResponse");
    }

    private String buildSignature(String samlMessage, String relayState, String signAlgorithm, String type) throws SettingsException, IllegalArgumentException {
        String signature = "";
        if (!this.settings.checkSPCerts()) {
            String errorMsg = "Trying to sign the " + type + " but can't load the SP private key";
            LOGGER.error("buildSignature error. " + errorMsg);
            throw new SettingsException(errorMsg, 4);
        }
        PrivateKey key = this.settings.getSPkey();
        String msg = type + "=" + Util.urlEncoder((String)samlMessage);
        if (StringUtils.isNotEmpty((CharSequence)relayState)) {
            msg = msg + "&RelayState=" + Util.urlEncoder((String)relayState);
        }
        if (StringUtils.isEmpty((CharSequence)signAlgorithm)) {
            signAlgorithm = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
        }
        msg = msg + "&SigAlg=" + Util.urlEncoder((String)signAlgorithm);
        try {
            signature = Util.base64encoder((byte[])Util.sign((String)msg, (PrivateKey)key, (String)signAlgorithm));
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            String errorMsg = "buildSignature error." + e.getMessage();
            LOGGER.error(errorMsg);
        }
        if (signature.isEmpty()) {
            String errorMsg = "There was a problem when calculating the Signature of the " + type;
            LOGGER.error("buildSignature error. " + errorMsg);
            throw new IllegalArgumentException(errorMsg);
        }
        LOGGER.debug("buildResponseSignature success. --> " + signature);
        return signature;
    }

    public String getLastRequestXML() {
        return this.lastRequest;
    }

    public String getLastResponseXML() {
        return this.lastResponse;
    }

    public void setSamlMessageFactory(SamlMessageFactory samlMessageFactory) {
        this.samlMessageFactory = samlMessageFactory != null ? samlMessageFactory : DEFAULT_SAML_MESSAGE_FACTORY;
    }
}

