/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.io.data.writer;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import org.jumpmind.exception.IoException;
import org.jumpmind.symmetric.io.data.Batch;
import org.jumpmind.symmetric.io.data.writer.AbstractProtocolDataWriter;
import org.jumpmind.symmetric.io.data.writer.IProtocolDataWriterListener;
import org.jumpmind.util.FormatUtils;

public class ProtocolDataWriter
extends AbstractProtocolDataWriter {
    private BufferedWriter writer;

    public ProtocolDataWriter(String sourceNodeId, Writer writer, boolean backwardsCompatible, boolean sendCaptureTime, boolean sendRowCaptureTime) {
        this(sourceNodeId, null, writer, backwardsCompatible, sendCaptureTime, sendRowCaptureTime);
    }

    public ProtocolDataWriter(String sourceNodeId, List<IProtocolDataWriterListener> listeners, Writer writer, boolean backwardsCompatible, boolean sendCaptureTime, boolean sendRowCaptureTime) {
        super(sourceNodeId, listeners, backwardsCompatible, sendCaptureTime, sendRowCaptureTime);
        this.writer = writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer);
    }

    @Override
    protected void endBatch(Batch batch) {
        super.endBatch(batch);
        try {
            this.writer.flush();
        }
        catch (IOException e) {
            throw new IoException((Exception)e);
        }
    }

    @Override
    protected void notifyEndBatch(Batch batch, IProtocolDataWriterListener listener) {
    }

    @Override
    protected void print(Batch batch, String data) {
        try {
            if (data != null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Writing data: {}", (Object)FormatUtils.abbreviateForLogging((String)data));
                }
                this.writer.write(data);
            }
        }
        catch (IOException e) {
            throw new IoException((Exception)e);
        }
    }
}

