/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.io.data.writer;

import java.util.Map;
import org.jumpmind.db.model.Table;
import org.jumpmind.symmetric.io.data.Batch;
import org.jumpmind.symmetric.io.data.CsvData;
import org.jumpmind.symmetric.io.data.DataContext;
import org.jumpmind.symmetric.io.data.IDataWriter;
import org.jumpmind.util.Statistics;

public class NestedDataWriter
implements IDataWriter {
    protected IDataWriter nestedWriter;
    protected DataContext context;

    public NestedDataWriter(IDataWriter nestedWriter) {
        this.nestedWriter = nestedWriter;
    }

    @Override
    public void open(DataContext context) {
        this.context = context;
        this.nestedWriter.open(context);
    }

    @Override
    public void close() {
        this.nestedWriter.close();
    }

    @Override
    public Map<Batch, Statistics> getStatistics() {
        return this.nestedWriter.getStatistics();
    }

    @Override
    public void start(Batch batch) {
        this.nestedWriter.start(batch);
    }

    @Override
    public boolean start(Table table) {
        return this.nestedWriter.start(table);
    }

    @Override
    public void write(CsvData data) {
        this.nestedWriter.write(data);
    }

    @Override
    public void end(Table table) {
        this.nestedWriter.end(table);
    }

    @Override
    public void end(Batch batch, boolean inError) {
        this.nestedWriter.end(batch, inError);
    }

    public void setNestedWriter(IDataWriter nestedWriter) {
        this.nestedWriter = nestedWriter;
    }

    public IDataWriter getNestedWriter() {
        return this.nestedWriter;
    }

    public <T extends IDataWriter> T getNestedWriterOfType(Class<?> clazz) {
        IDataWriter writer;
        for (writer = this; writer != null && !clazz.isInstance(writer) && writer instanceof NestedDataWriter; writer = writer.getNestedWriter()) {
        }
        if (writer != null && clazz.isInstance(writer)) {
            return (T)writer;
        }
        return null;
    }
}

