/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.io.data.writer;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.LocalDate;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.model.TypeMap;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.platform.cassandra.CassandraPlatform;
import org.jumpmind.symmetric.io.data.CsvData;
import org.jumpmind.symmetric.io.data.DataEventType;
import org.jumpmind.symmetric.io.data.writer.DatabaseWriterSettings;
import org.jumpmind.symmetric.io.data.writer.DynamicDefaultDatabaseWriter;
import org.jumpmind.symmetric.io.data.writer.IDatabaseWriterConflictResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraDatabaseWriter
extends DynamicDefaultDatabaseWriter {
    private static final Logger log = LoggerFactory.getLogger(CassandraDatabaseWriter.class);
    protected Gson gson = new Gson();
    protected Session session;
    protected Map<String, Map<String, Table>> metaData = new HashMap<String, Map<String, Table>>();
    protected PreparedStatement pstmt;
    SimpleDateFormat tsFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss.SSS");
    SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    DateTimeFormatter timeFormat = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS");

    public CassandraDatabaseWriter(IDatabasePlatform symmetricPlatform, IDatabasePlatform targetPlatform, String prefix, IDatabaseWriterConflictResolver conflictResolver, DatabaseWriterSettings settings) {
        super(symmetricPlatform, targetPlatform, prefix, conflictResolver, settings);
        this.metaData = ((CassandraPlatform)targetPlatform).getMetaData();
        this.session = ((CassandraPlatform)targetPlatform).getSession();
    }

    @Override
    protected void prepare() {
        if (this.isSymmetricTable(this.targetTable)) {
            super.prepare();
        } else {
            this.pstmt = this.session.prepare(this.currentDmlStatement.getSql());
        }
    }

    @Override
    protected void prepare(String sql, CsvData data) {
        if (this.isSymmetricTable(this.targetTable) && !this.isUserSendSql(sql, data)) {
            super.prepare(sql, data);
        } else {
            this.pstmt = this.session.prepare(sql);
        }
    }

    protected boolean isUserSendSql(String sql, CsvData data) {
        return data.getDataEventType() == DataEventType.SQL && this.targetTable.getNameLowerCase().equals(this.getTablePrefix().toLowerCase() + "_node") && !sql.toLowerCase().contains("from " + this.getTablePrefix().toLowerCase() + "_node");
    }

    @Override
    public int prepareAndExecute(String sql, CsvData data) {
        if (this.isUserSendSql(sql, data)) {
            return this.session.execute(sql).wasApplied() ? 1 : 0;
        }
        return super.prepareAndExecute(sql, data);
    }

    @Override
    protected int execute(CsvData data, String[] values) {
        if (this.isSymmetricTable(this.targetTable)) {
            return super.execute(data, values);
        }
        BoundStatement bstmt = this.pstmt.bind();
        this.currentDmlValues = this.getPlatform().getObjectValues(this.batch.getBinaryEncoding(), values, this.currentDmlStatement.getMetaData(), false, this.writerSettings.isFitToColumn());
        if (log.isDebugEnabled()) {
            log.debug("Submitting data [{}] with types [{}]", (Object)this.dmlValuesToString(this.currentDmlValues, this.currentDmlStatement.getTypes()), (Object)TypeMap.getJdbcTypeDescriptions((int[])this.currentDmlStatement.getTypes()));
        }
        this.bindVariables(bstmt, this.currentDmlStatement.getColumns(), this.currentDmlStatement.getTypes(), values);
        return this.session.execute((Statement)bstmt).wasApplied() ? 1 : 0;
    }

    @Override
    protected Table lookupTableAtTarget(Table sourceTable) {
        Table returnTable;
        if (sourceTable == null) {
            throw new RuntimeException("Source table is null");
        }
        if (this.isSymmetricTable(sourceTable)) {
            return super.lookupTableAtTarget(sourceTable);
        }
        String keyspace = sourceTable.getCatalog() == null ? sourceTable.getSchema() : sourceTable.getCatalog();
        Map<String, Table> tables = this.metaData.get(keyspace);
        Table table = returnTable = tables == null ? sourceTable : tables.get(sourceTable.getName());
        if (returnTable == null) {
            throw new RuntimeException("Unable to find Cassandra target table " + sourceTable.getName() + " in keyspace " + keyspace);
        }
        return returnTable;
    }

    @Override
    protected boolean create(CsvData data) {
        return false;
    }

    @Override
    protected void logFailureDetails(Throwable e, CsvData data, boolean logLastDmlDetails) {
    }

    @Override
    protected void allowInsertIntoAutoIncrementColumns(boolean value, Table table) {
    }

    protected void bindVariables(BoundStatement bstmt, Column[] columns, int[] types, String[] values) {
        int i = 0;
        for (int type : types) {
            if (4 == type) {
                bstmt.setInt(i, Integer.parseInt(values[i]));
            } else if (12 == type) {
                bstmt.setString(i, values[i]);
            } else if (2000 == type) {
                bstmt.setUUID(i, UUID.fromString(values[i]));
            } else if (93 == type) {
                try {
                    bstmt.setTimestamp(i, this.tsFormat.parse(values[i]));
                }
                catch (ParseException e) {
                    throw new RuntimeException("Unable to bind timestamp column " + columns[i].getName() + " with value " + values[i], e);
                }
            } else if (91 == type) {
                try {
                    bstmt.setDate(i, LocalDate.fromMillisSinceEpoch((long)this.dateFormat.parse(values[i]).getTime()));
                }
                catch (ParseException e) {
                    throw new RuntimeException("Unable to bind date column " + columns[i].getName() + " with value " + values[i], e);
                }
            } else if (92 == type) {
                try {
                    bstmt.setTime(i, LocalTime.parse(values[i], this.timeFormat).toNanoOfDay());
                }
                catch (DateTimeParseException e) {
                    throw new RuntimeException("Unable to bind time column " + columns[i].getName() + " with value " + values[i], e);
                }
            } else if (16 == type) {
                bstmt.setBool(i, Boolean.parseBoolean(values[i]));
            } else if (3 == type) {
                bstmt.setDecimal(i, new BigDecimal(values[i]));
            } else if (8 == type) {
                bstmt.setDouble(i, Double.parseDouble(values[i]));
            } else if (6 == type) {
                bstmt.setFloat(i, Float.parseFloat(values[i]));
            } else if (2002 == type) {
                bstmt.setList(i, this.parseList(columns[i], values[i]));
            } else if (2006 == type) {
                bstmt.setSet(i, this.parseSet(columns[i], values[i]));
            } else if (1111 == type) {
                bstmt.setMap(i, this.parseMap(columns[i], values[i]));
            }
            ++i;
        }
    }

    protected List parseList(Column c, String val) {
        try {
            if (c.getDescription() != null) {
                if (c.getDescription().toLowerCase().equals("text") || c.getDescription().toLowerCase().equals("varchar")) {
                    return (List)this.gson.fromJson(val, new TypeToken<List<String>>(){}.getType());
                }
                if (c.getDescription().toLowerCase().equals("int")) {
                    return (List)this.gson.fromJson(val, new TypeToken<List<Integer>>(){}.getType());
                }
                if (c.getDescription().toLowerCase().equals("bigint")) {
                    return (List)this.gson.fromJson(val, new TypeToken<List<Integer>>(){}.getType());
                }
                if (c.getDescription().toLowerCase().equals("smallint")) {
                    return (List)this.gson.fromJson(val, new TypeToken<List<Integer>>(){}.getType());
                }
                if (c.getDescription().toLowerCase().equals("tinyint")) {
                    return (List)this.gson.fromJson(val, new TypeToken<List<Integer>>(){}.getType());
                }
                if (c.getDescription().toLowerCase().equals("double")) {
                    return (List)this.gson.fromJson(val, new TypeToken<List<Double>>(){}.getType());
                }
                if (c.getDescription().toLowerCase().equals("decimal")) {
                    return (List)this.gson.fromJson(val, new TypeToken<List<BigDecimal>>(){}.getType());
                }
                if (c.getDescription().toLowerCase().equals("float")) {
                    return (List)this.gson.fromJson(val, new TypeToken<List<Float>>(){}.getType());
                }
            }
            return (List)this.gson.fromJson(val, new TypeToken<List<Object>>(){}.getType());
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to convert value to list, value=" + val, e);
        }
    }

    protected Set parseSet(Column c, String val) {
        try {
            if (c.getDescription() != null) {
                if (c.getDescription().toLowerCase().equals("text") || c.getDescription().toLowerCase().equals("varchar")) {
                    return (Set)this.gson.fromJson(val, new TypeToken<List<String>>(){}.getType());
                }
                if (c.getDescription().toLowerCase().equals("int")) {
                    return (Set)this.gson.fromJson(val, new TypeToken<List<Integer>>(){}.getType());
                }
                if (c.getDescription().toLowerCase().equals("bigint")) {
                    return (Set)this.gson.fromJson(val, new TypeToken<List<Integer>>(){}.getType());
                }
                if (c.getDescription().toLowerCase().equals("smallint")) {
                    return (Set)this.gson.fromJson(val, new TypeToken<List<Integer>>(){}.getType());
                }
                if (c.getDescription().toLowerCase().equals("tinyint")) {
                    return (Set)this.gson.fromJson(val, new TypeToken<List<Integer>>(){}.getType());
                }
                if (c.getDescription().toLowerCase().equals("double")) {
                    return (Set)this.gson.fromJson(val, new TypeToken<List<Double>>(){}.getType());
                }
                if (c.getDescription().toLowerCase().equals("decimal")) {
                    return (Set)this.gson.fromJson(val, new TypeToken<List<BigDecimal>>(){}.getType());
                }
                if (c.getDescription().toLowerCase().equals("float")) {
                    return (Set)this.gson.fromJson(val, new TypeToken<List<Float>>(){}.getType());
                }
            }
            return (Set)this.gson.fromJson(val, new TypeToken<List<Object>>(){}.getType());
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to convert value to set, value=" + val, e);
        }
    }

    protected Map parseMap(Column c, String val) {
        try {
            if (c.getDescription() != null) {
                String[] parts = c.getDescription().split(",");
                if (parts[0].equals(DataType.Name.INT.name()) && (parts[1].equals(DataType.Name.TEXT.name()) || parts[1].equals(DataType.Name.VARCHAR.name()))) {
                    return (Map)this.gson.fromJson(val, new TypeToken<Map<Integer, String>>(){}.getType());
                }
                if ((parts[0].equals(DataType.Name.TEXT.name()) || parts[0].equals(DataType.Name.VARCHAR.name())) && (parts[1].equals(DataType.Name.TEXT.name()) || parts[1].equals(DataType.Name.VARCHAR.name()))) {
                    return (Map)this.gson.fromJson(val, new TypeToken<Map<String, String>>(){}.getType());
                }
            }
            return (Map)this.gson.fromJson(val, new TypeToken<Map<Object, Object>>(){}.getType());
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to convert value to map, expecting JSON, value=" + val, e);
        }
    }
}

