/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.io.data.transform;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.Table;
import org.jumpmind.symmetric.io.data.CsvData;
import org.jumpmind.symmetric.io.data.DataEventType;
import org.jumpmind.symmetric.io.data.transform.TargetDmlAction;
import org.jumpmind.symmetric.io.data.transform.TransformColumn;
import org.jumpmind.symmetric.io.data.transform.TransformTable;

public class TransformedData
implements Cloneable {
    protected boolean generatedIdentityNeeded = false;
    protected TargetDmlAction targetAction = null;
    protected DataEventType targetDmlType;
    protected DataEventType sourceDmlType;
    protected Map<TransformColumn.IncludeOnType, LinkedHashMap<String, String>> targetNewValueByIncludeOnType;
    protected Map<TransformColumn.IncludeOnType, LinkedHashMap<String, String>> targetNewKeysByIncludeOnType;
    protected Map<TransformColumn.IncludeOnType, LinkedHashMap<String, String>> targetOldValuesByIncludeOnType;
    protected TransformTable transformation;
    protected Map<String, String> sourceKeyValues;
    protected Map<String, String> oldSourceValues;
    protected Map<String, String> sourceValues;

    public TransformedData(TransformTable transformation, DataEventType sourceDmlType, Map<String, String> sourceKeyValues, Map<String, String> oldSourceValues, Map<String, String> sourceValues) {
        this.transformation = transformation;
        this.targetDmlType = sourceDmlType;
        this.sourceDmlType = sourceDmlType;
        this.sourceKeyValues = sourceKeyValues;
        this.oldSourceValues = oldSourceValues;
        this.sourceValues = sourceValues;
    }

    public String getFullyQualifiedTableName() {
        return this.transformation.getFullyQualifiedTargetTableName();
    }

    public DataEventType getTargetDmlType() {
        return this.targetDmlType;
    }

    public void setTargetDmlType(DataEventType dmlType) {
        this.targetDmlType = dmlType;
    }

    public String getTableName() {
        return this.transformation.getTargetTableName();
    }

    public String getCatalogName() {
        return this.transformation.getTargetCatalogName();
    }

    public String getSchemaName() {
        return this.transformation.getTargetSchemaName();
    }

    public void put(TransformColumn column, String columnValue, String oldValue, boolean recordAsKey) {
        LinkedHashMap<String, String> oldColumnValues;
        LinkedHashMap<String, String> columnValues;
        if (recordAsKey) {
            LinkedHashMap<String, String> keyValues;
            if (this.targetNewKeysByIncludeOnType == null) {
                this.targetNewKeysByIncludeOnType = new HashMap<TransformColumn.IncludeOnType, LinkedHashMap<String, String>>(2);
            }
            if ((keyValues = this.targetNewKeysByIncludeOnType.get((Object)column.getIncludeOn())) == null) {
                keyValues = new LinkedHashMap();
                this.targetNewKeysByIncludeOnType.put(column.getIncludeOn(), keyValues);
            }
            keyValues.put(column.getTargetColumnName(), oldValue != null ? oldValue : columnValue);
        }
        if (this.targetNewValueByIncludeOnType == null) {
            this.targetNewValueByIncludeOnType = new HashMap<TransformColumn.IncludeOnType, LinkedHashMap<String, String>>(2);
        }
        if ((columnValues = this.targetNewValueByIncludeOnType.get((Object)column.getIncludeOn())) == null) {
            columnValues = new LinkedHashMap();
            this.targetNewValueByIncludeOnType.put(column.getIncludeOn(), columnValues);
        }
        columnValues.put(column.getTargetColumnName(), columnValue);
        if (this.targetOldValuesByIncludeOnType == null) {
            this.targetOldValuesByIncludeOnType = new HashMap<TransformColumn.IncludeOnType, LinkedHashMap<String, String>>(2);
        }
        if ((oldColumnValues = this.targetOldValuesByIncludeOnType.get((Object)column.getIncludeOn())) == null) {
            oldColumnValues = new LinkedHashMap();
            this.targetOldValuesByIncludeOnType.put(column.getIncludeOn(), oldColumnValues);
        }
        oldColumnValues.put(column.getTargetColumnName(), oldValue);
    }

    protected Map<String, String> retrieve(Map<TransformColumn.IncludeOnType, LinkedHashMap<String, String>> source) {
        LinkedHashMap<String, String> list = new LinkedHashMap<String, String>(source == null ? 0 : source.size());
        if (source != null) {
            LinkedHashMap<String, String> values = source.get((Object)TransformColumn.IncludeOnType.ALL);
            if (values != null) {
                list.putAll(values);
            }
            TransformColumn.IncludeOnType type = TransformColumn.IncludeOnType.DELETE;
            if (this.targetDmlType == DataEventType.UPDATE && this.sourceDmlType != DataEventType.DELETE) {
                type = TransformColumn.IncludeOnType.UPDATE;
            } else if (this.targetDmlType == DataEventType.INSERT) {
                type = TransformColumn.IncludeOnType.INSERT;
            }
            values = source.get((Object)type);
            if (values != null) {
                list.putAll(values);
            }
        }
        return list;
    }

    protected List<String> retrieve(Map<TransformColumn.IncludeOnType, LinkedHashMap<String, String>> source, boolean getColumnNames) {
        Map<String, String> values = this.retrieve(source);
        if (getColumnNames) {
            return new ArrayList<String>(values.keySet());
        }
        return new ArrayList<String>(values.values());
    }

    public Map<String, String> getTargetKeyValues() {
        return this.retrieve(this.targetNewKeysByIncludeOnType);
    }

    public Map<String, String> getTargetValues() {
        return this.retrieve(this.targetNewValueByIncludeOnType);
    }

    public String[] getKeyNames() {
        List<String> list = this.retrieve(this.targetNewKeysByIncludeOnType, true);
        return list.toArray(new String[list.size()]);
    }

    public String[] getKeyValues() {
        List<String> list = this.retrieve(this.targetNewKeysByIncludeOnType, false);
        return list.toArray(new String[list.size()]);
    }

    public String[] getColumnNames() {
        List<String> list = this.retrieve(this.targetNewValueByIncludeOnType, true);
        return list.toArray(new String[list.size()]);
    }

    public String[] getColumnValues() {
        List<String> list = this.retrieve(this.targetNewValueByIncludeOnType, false);
        return list.toArray(new String[list.size()]);
    }

    public DataEventType getSourceDmlType() {
        return this.sourceDmlType;
    }

    public TransformedData copy() {
        try {
            TransformedData clone = (TransformedData)this.clone();
            clone.targetNewValueByIncludeOnType = this.copy(this.targetNewValueByIncludeOnType);
            clone.targetNewKeysByIncludeOnType = this.copy(this.targetNewKeysByIncludeOnType);
            clone.targetOldValuesByIncludeOnType = this.copy(this.targetOldValuesByIncludeOnType);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public TransformTable getTransformation() {
        return this.transformation;
    }

    public void setGeneratedIdentityNeeded(boolean generatedIdentityNeeded) {
        this.generatedIdentityNeeded = generatedIdentityNeeded;
    }

    public boolean isGeneratedIdentityNeeded() {
        return this.generatedIdentityNeeded;
    }

    protected Map<TransformColumn.IncludeOnType, LinkedHashMap<String, String>> copy(Map<TransformColumn.IncludeOnType, LinkedHashMap<String, String>> toCopy) {
        HashMap<TransformColumn.IncludeOnType, LinkedHashMap<String, String>> newMap = new HashMap<TransformColumn.IncludeOnType, LinkedHashMap<String, String>>(toCopy.size());
        for (TransformColumn.IncludeOnType key : toCopy.keySet()) {
            LinkedHashMap<String, String> value = toCopy.get((Object)key);
            newMap.put(key, new LinkedHashMap<String, String>(value));
        }
        return newMap;
    }

    public Map<String, String> getSourceKeyValues() {
        return this.sourceKeyValues;
    }

    public Map<String, String> getOldSourceValues() {
        return this.oldSourceValues;
    }

    public Map<String, String> getSourceValues() {
        return this.sourceValues;
    }

    public void setTargetAction(TargetDmlAction targetAction) {
        this.targetAction = targetAction;
    }

    public TargetDmlAction getTargetAction() {
        return this.targetAction;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean hasSameKeyValues(String[] otherKeyValues) {
        String[] keyValues = this.getKeyValues();
        if (otherKeyValues != null) {
            if (keyValues == null) return false;
            if (keyValues.length != otherKeyValues.length) {
                return false;
            }
            for (int i = 0; i < otherKeyValues.length; ++i) {
                if (keyValues[i] == null && otherKeyValues[i] == null || !(keyValues[i] == null && otherKeyValues[i] != null || otherKeyValues[i] == null && keyValues[i] != null) && keyValues[i].equals(otherKeyValues[i])) continue;
                return false;
            }
            return true;
        } else {
            if (keyValues == null) return true;
            return false;
        }
    }

    public Table buildTargetTable() {
        Table table = null;
        String[] columnNames = this.getColumnNames();
        String[] keyNames = this.getKeyNames();
        if (columnNames != null && columnNames.length > 0) {
            table = new Table(this.transformation.getTargetCatalogName(), this.transformation.getTargetSchemaName(), this.transformation.getTargetTableName());
            for (String colName : columnNames) {
                Column col = new Column(colName);
                table.addColumn(col);
                if (keyNames == null) continue;
                for (String keyName : keyNames) {
                    if (!keyName.equals(colName)) continue;
                    col.setPrimaryKey(true);
                }
            }
        }
        return table;
    }

    public CsvData buildTargetCsvData(Map<String, Object> attributes) {
        CsvData data = new CsvData(this.targetDmlType);
        data.setAttributes(attributes);
        if (this.transformation != null) {
            data.putAttribute("tableName", this.transformation.getSourceTableName());
        }
        if (this.targetDmlType != DataEventType.DELETE) {
            data.putParsedData("rowData", this.getColumnValues());
        }
        if (this.targetDmlType == DataEventType.UPDATE || this.targetDmlType == DataEventType.DELETE) {
            data.putParsedData("oldData", this.getOldColumnValues());
            data.putParsedData("pkData", this.getKeyValues());
        }
        data.putAttribute(this.getClass().getName(), this);
        return data;
    }

    public String[] getOldColumnValues() {
        List<String> list = this.retrieve(this.targetOldValuesByIncludeOnType, false);
        boolean use = false;
        for (String string : list) {
            use |= string != null;
        }
        if (use) {
            return list.toArray(new String[list.size()]);
        }
        return null;
    }
}

