/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.io.data.transform;

import com.google.gson.Gson;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.extension.IBuiltInExtensionPoint;
import org.jumpmind.symmetric.io.data.CsvData;
import org.jumpmind.symmetric.io.data.CsvUtils;
import org.jumpmind.symmetric.io.data.DataContext;
import org.jumpmind.symmetric.io.data.transform.ISingleNewAndOldValueColumnTransform;
import org.jumpmind.symmetric.io.data.transform.IgnoreColumnException;
import org.jumpmind.symmetric.io.data.transform.IgnoreRowException;
import org.jumpmind.symmetric.io.data.transform.NewAndOldValue;
import org.jumpmind.symmetric.io.data.transform.TransformColumn;
import org.jumpmind.symmetric.io.data.transform.TransformedData;

public class JsonColumnTransform
implements ISingleNewAndOldValueColumnTransform,
IBuiltInExtensionPoint {
    public static final String NAME = "json";
    public static final String ID_HEADER = "idHeader";
    public static final String ID_COLUMN_NAME = "idColumnName";
    public static final String DATA_HEADER = "dataHeader";
    public static final String EXCLUDE_COLUMN_NAMES = "excludeColumnNames";

    public String getName() {
        return NAME;
    }

    @Override
    public boolean isExtractColumnTransform() {
        return true;
    }

    @Override
    public boolean isLoadColumnTransform() {
        return true;
    }

    @Override
    public NewAndOldValue transform(IDatabasePlatform platform, DataContext context, TransformColumn column, TransformedData data, Map<String, String> sourceValues, String newValue, String oldValue) throws IgnoreColumnException, IgnoreRowException {
        String dataHeader;
        CsvData csvData = context.getData();
        Map<String, String> oldValues = null;
        LinkedHashMap<String, Object> oldValueMap = null;
        if (csvData.contains("oldData")) {
            oldValues = csvData.toColumnNameValuePairs(context.getTable().getColumnNames(), "oldData");
            oldValueMap = new LinkedHashMap<String, String>(oldValues);
        }
        Map<String, String> expressionMap = JsonColumnTransform.parseExpression(column.getTransformExpression());
        LinkedHashMap<String, Object> newValueMap = new LinkedHashMap<String, String>(sourceValues);
        if (expressionMap.containsKey(EXCLUDE_COLUMN_NAMES)) {
            for (String excludedColumnName : expressionMap.get(EXCLUDE_COLUMN_NAMES).split(",")) {
                newValueMap.remove(excludedColumnName);
                if (oldValueMap == null) continue;
                oldValueMap.remove(excludedColumnName);
            }
        }
        if ((dataHeader = expressionMap.get(DATA_HEADER)) != null) {
            LinkedHashMap<String, Object> newMap = new LinkedHashMap<String, Object>();
            LinkedHashMap<String, Object> oldMap = new LinkedHashMap<String, Object>();
            String idHeader = expressionMap.get(ID_HEADER);
            if (idHeader != null) {
                String idColumnName = expressionMap.get(ID_COLUMN_NAME);
                newMap.put(idHeader, idColumnName != null ? sourceValues.get(idColumnName) : null);
                if (oldValues != null) {
                    oldMap.put(idHeader, idColumnName != null ? oldValues.get(idColumnName) : null);
                }
            }
            newMap.put(dataHeader, newValueMap);
            oldMap.put(dataHeader, oldValueMap);
            newValueMap = newMap;
            oldValueMap = oldMap;
        }
        Gson gson = new Gson();
        return new NewAndOldValue(gson.toJson(newValueMap), gson.toJson(oldValueMap));
    }

    public static Map<String, String> parseExpression(String expression) {
        HashMap<String, String> expressionMap = new HashMap<String, String>();
        if (StringUtils.isNotBlank((CharSequence)expression)) {
            for (String expressionPairString : CsvUtils.tokenizeCsvData(expression)) {
                String[] expressionPair = expressionPairString.split("==", -1);
                if (expressionPair.length != 2) continue;
                expressionMap.put(expressionPair[0], expressionPair[1]);
            }
        }
        return expressionMap;
    }
}

