/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.io.data.transform;

import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.symmetric.io.data.DataContext;
import org.jumpmind.symmetric.io.data.DataEventType;
import org.jumpmind.symmetric.io.data.transform.CopyColumnTransform;
import org.jumpmind.symmetric.io.data.transform.IgnoreColumnException;
import org.jumpmind.symmetric.io.data.transform.IgnoreRowException;
import org.jumpmind.symmetric.io.data.transform.NewAndOldValue;
import org.jumpmind.symmetric.io.data.transform.TransformColumn;
import org.jumpmind.symmetric.io.data.transform.TransformedData;

public class CopyIfChangedColumnTransform
extends CopyColumnTransform {
    public static final String NAME = "copyIfChanged";
    public static final String EXPRESSION_IGNORE_COLUMN = "IgnoreColumn";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public NewAndOldValue transform(IDatabasePlatform platform, DataContext context, TransformColumn column, TransformedData data, Map<String, String> sourceValues, String newValue, String oldValue) throws IgnoreColumnException, IgnoreRowException {
        if (DataEventType.DELETE != context.getData().getDataEventType() && StringUtils.trimToEmpty((String)newValue).equals(StringUtils.trimToEmpty((String)oldValue))) {
            if (EXPRESSION_IGNORE_COLUMN.equalsIgnoreCase(column.getTransformExpression())) {
                throw new IgnoreColumnException();
            }
            throw new IgnoreRowException();
        }
        return new NewAndOldValue(newValue, oldValue);
    }
}

