/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.io.data.transform;

import java.nio.charset.Charset;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.extension.IBuiltInExtensionPoint;
import org.jumpmind.symmetric.io.data.DataContext;
import org.jumpmind.symmetric.io.data.transform.ISingleNewAndOldValueColumnTransform;
import org.jumpmind.symmetric.io.data.transform.IgnoreColumnException;
import org.jumpmind.symmetric.io.data.transform.IgnoreRowException;
import org.jumpmind.symmetric.io.data.transform.NewAndOldValue;
import org.jumpmind.symmetric.io.data.transform.TransformColumn;
import org.jumpmind.symmetric.io.data.transform.TransformedData;

public class BinaryLeftColumnTransform
implements ISingleNewAndOldValueColumnTransform,
IBuiltInExtensionPoint {
    public static final String NAME = "bleft";

    public String getName() {
        return NAME;
    }

    @Override
    public boolean isExtractColumnTransform() {
        return true;
    }

    @Override
    public boolean isLoadColumnTransform() {
        return true;
    }

    @Override
    public NewAndOldValue transform(IDatabasePlatform platform, DataContext context, TransformColumn column, TransformedData data, Map<String, String> sourceValues, String newValue, String oldValue) throws IgnoreColumnException, IgnoreRowException {
        String expression;
        if (StringUtils.isNotBlank((CharSequence)newValue) && StringUtils.isNotBlank((CharSequence)(expression = column.getTransformExpression()))) {
            expression = expression.trim();
            newValue = this.bleft(newValue, Integer.parseInt(expression));
        }
        return new NewAndOldValue(column, data, newValue);
    }

    public String bleft(String value, int maxBytes) {
        StringBuilder ret = new StringBuilder();
        for (int i = 0; i < value.length() && (maxBytes -= value.substring(i, i + 1).getBytes(Charset.defaultCharset()).length) >= 0; ++i) {
            ret.append(value.charAt(i));
        }
        return ret.toString();
    }
}

