/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.io.data.reader;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.io.DatabaseXmlUtil;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.Database;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.util.BinaryEncoding;
import org.jumpmind.exception.IoException;
import org.jumpmind.symmetric.io.data.Batch;
import org.jumpmind.symmetric.io.data.CsvData;
import org.jumpmind.symmetric.io.data.CsvUtils;
import org.jumpmind.symmetric.io.data.DataContext;
import org.jumpmind.symmetric.io.data.DataEventType;
import org.jumpmind.symmetric.io.data.IDataReader;
import org.jumpmind.symmetric.io.data.reader.AbstractDataReader;
import org.jumpmind.util.Statistics;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class XmlDataReader
extends AbstractDataReader
implements IDataReader {
    protected Reader reader;
    protected DataContext context;
    protected Batch batch;
    protected Table table;
    protected String sourceNodeId;
    protected int lineNumber = 0;
    protected XmlPullParser parser;
    protected Statistics statistics = new Statistics();
    protected List<Object> next = new ArrayList<Object>();
    protected String catalog;
    protected String schema;

    public XmlDataReader(InputStream is) {
        this(XmlDataReader.toReader(is));
    }

    public XmlDataReader(Reader reader) {
        this.reader = reader;
    }

    @Override
    public void open(DataContext context) {
        try {
            this.lineNumber = 0;
            this.context = context;
            this.parser = XmlPullParserFactory.newInstance().newPullParser();
            this.parser.setInput(this.reader);
            this.readNext();
        }
        catch (XmlPullParserException e) {
            throw new RuntimeException(e);
        }
    }

    protected void readNext() {
        try {
            LinkedHashMap<String, String> rowData = new LinkedHashMap<String, String>();
            String columnName = null;
            CsvData data = null;
            Table table = null;
            String localCatalog = this.catalog;
            String localSchema = this.schema;
            int eventType = this.parser.next();
            while (eventType != 1) {
                switch (eventType) {
                    case 4: {
                        if (columnName == null) break;
                        rowData.put(columnName, this.parser.getText());
                        columnName = null;
                        break;
                    }
                    case 2: {
                        String name = this.parser.getName();
                        if ("row".equalsIgnoreCase(name)) {
                            data = new CsvData();
                            if (table != null) {
                                table.removeAllColumns();
                            }
                            data.setDataEventType(DataEventType.INSERT);
                            break;
                        }
                        if ("field".equalsIgnoreCase(name)) {
                            boolean nullValue = false;
                            for (int i = 0; i < this.parser.getAttributeCount(); ++i) {
                                String attributeName = this.parser.getAttributeName(i);
                                String attributeValue = this.parser.getAttributeValue(i);
                                if ("name".equalsIgnoreCase(attributeName)) {
                                    columnName = attributeValue;
                                    continue;
                                }
                                if (!"xsi:nil".equalsIgnoreCase(attributeName)) continue;
                                nullValue = true;
                            }
                            if (!nullValue) break;
                            rowData.put(columnName, null);
                            columnName = null;
                            break;
                        }
                        if ("table_data".equalsIgnoreCase(name)) {
                            Batch batch = new Batch();
                            batch.setBinaryEncoding(BinaryEncoding.BASE64);
                            this.next.add(batch);
                            table = new Table();
                            for (int i = 0; i < this.parser.getAttributeCount(); ++i) {
                                String attributeName = this.parser.getAttributeName(i);
                                String attributeValue = this.parser.getAttributeValue(i);
                                if (!"name".equalsIgnoreCase(attributeName)) continue;
                                table.setName(attributeValue);
                            }
                            this.next.add(table);
                            break;
                        }
                        if ("table".equalsIgnoreCase(name)) {
                            Batch batch = new Batch();
                            batch.setBinaryEncoding(BinaryEncoding.BASE64);
                            this.next.add(batch);
                            table = DatabaseXmlUtil.nextTable((XmlPullParser)this.parser);
                            this.next.add(table);
                            Database db = new Database();
                            db.setName("dbimport");
                            db.setCatalog(localCatalog);
                            db.setSchema(localSchema);
                            db.addTable(table);
                            String xml = DatabaseXmlUtil.toXml((Database)db);
                            data = new CsvData(DataEventType.CREATE);
                            data.putCsvData("rowData", CsvUtils.escapeCsvData(xml));
                            this.next.add(data);
                            break;
                        }
                        if (!"database".equalsIgnoreCase(name)) break;
                        for (int i = 0; i < this.parser.getAttributeCount(); ++i) {
                            String attributeName = this.parser.getAttributeName(i);
                            String attributeValue = this.parser.getAttributeValue(i);
                            if ("catalog".equalsIgnoreCase(attributeName)) {
                                localCatalog = StringUtils.isBlank((CharSequence)this.catalog) ? attributeValue : this.catalog;
                                continue;
                            }
                            if (!"schema".equalsIgnoreCase(attributeName)) continue;
                            localSchema = StringUtils.isBlank((CharSequence)this.schema) ? attributeValue : this.schema;
                        }
                        break;
                    }
                    case 3: {
                        String name = this.parser.getName();
                        if ("row".equalsIgnoreCase(name)) {
                            String[] columnNames;
                            for (String colName : columnNames = rowData.keySet().toArray(new String[rowData.size()])) {
                                table.addColumn(new Column(colName));
                            }
                            String[] columnValues = rowData.values().toArray(new String[rowData.size()]);
                            data.putParsedData("rowData", columnValues);
                            if (this.table == null || !this.table.equals((Object)table)) {
                                this.next.add(table);
                            }
                            this.next.add(data);
                            rowData = new LinkedHashMap();
                            break;
                        }
                        if ("table_data".equalsIgnoreCase(name)) {
                            if (this.batch == null) break;
                            this.batch.setComplete(true);
                            break;
                        }
                        if (!"field".equalsIgnoreCase(name)) break;
                        columnName = null;
                    }
                }
                eventType = this.parser.next();
            }
        }
        catch (IOException ex) {
            throw new IoException((Exception)ex);
        }
        catch (XmlPullParserException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public Batch nextBatch() {
        do {
            Object o;
            this.readNext();
            if (this.next.size() <= 0 || !((o = this.next.remove(0)) instanceof Batch)) continue;
            this.batch = (Batch)o;
            return this.batch;
        } while (this.next.size() > 0);
        return null;
    }

    @Override
    public Table nextTable() {
        this.table = null;
        do {
            Object o;
            this.readNext();
            if (this.next.size() <= 0 || !((o = this.next.remove(0)) instanceof Table)) continue;
            this.table = (Table)o;
            break;
        } while (this.next.size() > 0);
        if (this.table == null && this.batch != null) {
            this.batch.setComplete(true);
        }
        return this.table;
    }

    @Override
    public CsvData nextData() {
        this.readNext();
        if (this.next.size() > 0 && this.next.get(0) instanceof CsvData) {
            return (CsvData)this.next.remove(0);
        }
        return null;
    }

    @Override
    public void close() {
        try {
            if (this.reader != null) {
                this.reader.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public Map<Batch, Statistics> getStatistics() {
        HashMap<Batch, Statistics> map = new HashMap<Batch, Statistics>(1);
        map.put(this.batch, this.statistics);
        return map;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public void setCatalog(String catalog) {
        this.catalog = catalog;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }
}

