/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.io.data.reader;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.ArrayUtils;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.platform.DatabaseInfo;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.sql.ISqlTemplate;
import org.jumpmind.db.sql.Row;
import org.jumpmind.db.util.BinaryEncoding;
import org.jumpmind.symmetric.io.data.Batch;
import org.jumpmind.symmetric.io.data.CsvData;
import org.jumpmind.symmetric.io.data.DataContext;
import org.jumpmind.symmetric.io.data.DataEventType;
import org.jumpmind.symmetric.io.data.IDataReader;
import org.jumpmind.symmetric.io.data.reader.IExtractDataFilter;
import org.jumpmind.symmetric.io.data.reader.IExtractDataReaderSource;
import org.jumpmind.util.CollectionUtils;
import org.jumpmind.util.FormatUtils;
import org.jumpmind.util.Statistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtractDataReader
implements IDataReader {
    public static final String DATA_CONTEXT_CURRENT_CSV_DATA = "csvData";
    protected Map<Batch, Statistics> statistics = new HashMap<Batch, Statistics>();
    protected IDatabasePlatform platform;
    protected List<IExtractDataReaderSource> sourcesToUse;
    protected IDatabasePlatform targetPlatform;
    protected IExtractDataReaderSource currentSource;
    protected List<IExtractDataFilter> filters;
    protected Batch batch;
    protected Table table;
    protected CsvData data;
    protected DataContext dataContext;
    protected boolean isSybaseASE;
    protected boolean isUsingUnitypes;
    private static final Logger log = LoggerFactory.getLogger(ExtractDataReader.class);

    public ExtractDataReader(IDatabasePlatform platform, IExtractDataReaderSource source, IDatabasePlatform targetPlatform) {
        this.sourcesToUse = new ArrayList<IExtractDataReaderSource>();
        this.sourcesToUse.add(source);
        this.platform = platform;
        this.targetPlatform = targetPlatform;
        this.isSybaseASE = platform.getName().equals("ase");
    }

    public ExtractDataReader(IDatabasePlatform platform, IExtractDataReaderSource source, List<IExtractDataFilter> filters, boolean isUsingUnitypes, IDatabasePlatform targetPlatform) {
        this.sourcesToUse = new ArrayList<IExtractDataReaderSource>();
        this.sourcesToUse.add(source);
        this.platform = platform;
        this.targetPlatform = targetPlatform;
        this.filters = filters;
        this.isUsingUnitypes = isUsingUnitypes;
        this.isSybaseASE = platform.getName().equals("ase");
    }

    public ExtractDataReader(IDatabasePlatform platform, List<IExtractDataReaderSource> sources, IDatabasePlatform targetPlatform) {
        this.sourcesToUse = new ArrayList<IExtractDataReaderSource>(sources);
        this.platform = platform;
        this.targetPlatform = targetPlatform;
        this.isSybaseASE = platform.getName().equals("ase");
    }

    @Override
    public void open(DataContext context) {
        this.dataContext = context;
    }

    @Override
    public Batch nextBatch() {
        this.closeCurrentSource();
        if (this.sourcesToUse.size() > 0) {
            this.currentSource = this.sourcesToUse.remove(0);
            this.batch = this.currentSource.getBatch();
        } else {
            this.batch = null;
        }
        return this.batch;
    }

    @Override
    public Table nextTable() {
        this.table = null;
        if (this.currentSource != null) {
            if (this.data == null) {
                this.data = this.currentSource.next();
            }
            if (this.data != null) {
                this.table = this.currentSource.getTargetTable();
                if (this.table != null) {
                    this.table.setCatalog(this.substituteVariables(this.table.getCatalog()));
                    this.table.setSchema(this.substituteVariables(this.table.getSchema()));
                }
            }
        }
        if (this.table == null && this.batch != null) {
            this.batch.setComplete(true);
        }
        return this.table;
    }

    protected String substituteVariables(String sourceString) {
        if (sourceString != null && sourceString.indexOf("$(") != -1) {
            sourceString = FormatUtils.replace((String)"sourceNodeId", (String)((String)this.dataContext.get("sourceNodeId")), (String)sourceString);
            String sourceNodeExternalId = (String)this.dataContext.get("sourceNodeExternalId");
            sourceString = FormatUtils.replace((String)"sourceNodeExternalId", (String)sourceNodeExternalId, (String)sourceString);
            sourceString = FormatUtils.replace((String)"sourceExternalId", (String)sourceNodeExternalId, (String)sourceString);
            sourceString = FormatUtils.replace((String)"sourceNodeGroupId", (String)((String)this.dataContext.get("sourceNodeGroupId")), (String)sourceString);
            sourceString = FormatUtils.replace((String)"targetNodeId", (String)((String)this.dataContext.get("targetNodeId")), (String)sourceString);
            String targetNodeExternalId = (String)this.dataContext.get("targetNodeExternalId");
            sourceString = FormatUtils.replace((String)"targetNodeExternalId", (String)targetNodeExternalId, (String)sourceString);
            sourceString = FormatUtils.replace((String)"targetExternalId", (String)targetNodeExternalId, (String)sourceString);
            sourceString = FormatUtils.replace((String)"targetNodeGroupId", (String)((String)this.dataContext.get("targetNodeGroupId")), (String)sourceString);
        }
        return sourceString;
    }

    @Override
    public CsvData nextData() {
        CsvData nextData = this.nextDataFromSource();
        if (nextData != null && this.filters != null && this.filters.size() != 0) {
            boolean shouldExtract = true;
            while (shouldExtract) {
                for (IExtractDataFilter filter : this.filters) {
                    shouldExtract &= filter.filterData(this.dataContext, this.batch, this.table, nextData);
                }
                if (shouldExtract) break;
                nextData = this.nextDataFromSource();
                shouldExtract = nextData != null;
            }
        }
        return nextData;
    }

    protected CsvData nextDataFromSource() {
        if (this.table != null) {
            if (this.data == null) {
                this.data = this.currentSource.next();
            }
            if (this.data == null) {
                this.closeCurrentSource();
            } else if (this.data.getDataEventType() == null) {
                this.data = null;
            } else {
                Table targetTable = this.currentSource.getTargetTable();
                if (targetTable != null && targetTable.equals((Object)this.table)) {
                    this.data = this.enhanceWithLobsFromSourceIfNeeded(this.currentSource.getSourceTable(), this.data);
                    if (this.isSybaseASE && this.isUsingUnitypes) {
                        this.data = this.convertUtf16toUTF8(this.currentSource.getSourceTable(), this.data);
                    }
                } else {
                    return null;
                }
            }
        }
        CsvData dataToReturn = this.data;
        this.data = null;
        this.dataContext.put(DATA_CONTEXT_CURRENT_CSV_DATA, dataToReturn);
        return dataToReturn;
    }

    @Override
    public void close() {
        this.closeCurrentSource();
        this.batch = null;
    }

    protected void closeCurrentSource() {
        if (this.currentSource != null) {
            this.currentSource.close();
            this.currentSource = null;
        }
        this.table = null;
        this.data = null;
    }

    @Override
    public Map<Batch, Statistics> getStatistics() {
        return this.statistics;
    }

    protected CsvData enhanceWithLobsFromSourceIfNeeded(Table table, CsvData data) {
        List lobColumns;
        if (this.currentSource.requiresLobsSelectedFromSource(data) && (data.getDataEventType() == DataEventType.UPDATE || data.getDataEventType() == DataEventType.INSERT) && (lobColumns = this.platform.getLobColumns(table)).size() > 0) {
            Object[] columnNames = table.getColumnNames();
            String[] rowData = data.getParsedData("rowData");
            Column[] orderedColumns = table.getColumns();
            Object[] objectValues = this.platform.getObjectValues(this.batch.getBinaryEncoding(), rowData, orderedColumns);
            Map columnDataMap = CollectionUtils.toMap((String[])columnNames, (Object[])objectValues);
            Column[] pkColumns = table.getPrimaryKeyColumns();
            ISqlTemplate sqlTemplate = this.targetPlatform.getSqlTemplate();
            Object[] args = new Object[pkColumns.length];
            for (int i = 0; i < pkColumns.length; ++i) {
                args[i] = columnDataMap.get(pkColumns[i].getName());
            }
            String sql = this.buildSelect(table, lobColumns, pkColumns);
            Row row = sqlTemplate.queryForRow(sql, args);
            if (row == null) {
                row = this.createRowForRequiredLobs(lobColumns);
            }
            if (row != null) {
                for (Column lobColumn : lobColumns) {
                    String valueForCsv = null;
                    if (this.platform.isBlob(lobColumn)) {
                        byte[] binaryData = row.getBytes(lobColumn.getName());
                        if (binaryData != null) {
                            block13: {
                                if (this.isUniType(lobColumn.getJdbcTypeName())) {
                                    try {
                                        String utf8String;
                                        if (lobColumn.getJdbcTypeName().equalsIgnoreCase("unitext")) {
                                            valueForCsv = row.getString(lobColumn.getName());
                                            break block13;
                                        }
                                        String utf16String = null;
                                        Object baseString = row.getString(lobColumn.getName());
                                        baseString = "fffe" + (String)baseString;
                                        utf16String = new String(Hex.decodeHex((String)baseString), "UTF-16");
                                        valueForCsv = utf8String = new String(utf16String.getBytes(Charset.defaultCharset()), Charset.defaultCharset());
                                    }
                                    catch (UnsupportedEncodingException | DecoderException e) {
                                        e.printStackTrace();
                                    }
                                } else {
                                    valueForCsv = this.batch.getBinaryEncoding() == BinaryEncoding.BASE64 ? new String(Base64.encodeBase64((byte[])binaryData), Charset.defaultCharset()) : (this.batch.getBinaryEncoding() == BinaryEncoding.HEX ? new String(Hex.encodeHex((byte[])binaryData)) : new String(binaryData, Charset.defaultCharset()));
                                }
                            }
                            binaryData = null;
                        }
                    } else {
                        valueForCsv = row.getString(lobColumn.getName());
                    }
                    int index = ArrayUtils.indexOf((Object[])columnNames, (Object)lobColumn.getName());
                    rowData[index] = valueForCsv;
                }
                data.putParsedData("rowData", rowData);
            }
        }
        return data;
    }

    protected CsvData convertUtf16toUTF8(Table table, CsvData data) {
        List<Column> uniColumns;
        if (!(data.getDataEventType() != DataEventType.UPDATE && data.getDataEventType() != DataEventType.INSERT || (uniColumns = this.getUniColumns(table)).isEmpty())) {
            Object[] columnNames = table.getColumnNames();
            String[] rowData = data.getParsedData("rowData");
            boolean skipUnitext = this.currentSource.requiresLobsSelectedFromSource(data);
            for (Column uniColumn : uniColumns) {
                int index;
                boolean isUnitext;
                String jdbcType = uniColumn.getJdbcTypeName();
                boolean bl = isUnitext = jdbcType != null && jdbcType.equalsIgnoreCase("unitext");
                if (isUnitext && skipUnitext || (index = ArrayUtils.indexOf((Object[])columnNames, (Object)uniColumn.getName())) < 0 || rowData[index] == null) continue;
                try {
                    String utf8Str;
                    Object baseString = rowData[index];
                    baseString = "fffe" + (String)baseString;
                    byte[] utf16Bytes = Hex.decodeHex((String)baseString);
                    String utf16Str = new String(utf16Bytes, "UTF-16");
                    rowData[index] = utf8Str = new String(utf16Str.getBytes("UTF-8"), "UTF-8");
                }
                catch (UnsupportedEncodingException | DecoderException e) {
                    log.warn("Failed to decode UTF-16 to UTF-8 for column '{}' with value '{}' in table '{}': {}", new Object[]{uniColumn.getName(), rowData[index], table.getFullyQualifiedTableName(), e.getMessage()});
                }
            }
            data.putParsedData("rowData", rowData);
        }
        return data;
    }

    public List<Column> getUniColumns(Table table) {
        Column[] allColumns;
        ArrayList<Column> uniColumns = new ArrayList<Column>(1);
        for (Column column : allColumns = table.getColumns()) {
            if (!this.isUniType(column.getJdbcTypeName())) continue;
            uniColumns.add(column);
        }
        return uniColumns;
    }

    public boolean isUniType(String type) {
        return type.equalsIgnoreCase("UNITEXT") || type.equalsIgnoreCase("UNICHAR") || type.equalsIgnoreCase("UNIVARCHAR");
    }

    protected String buildSelect(Table table, List<Column> lobColumns, Column[] pkColumns) {
        StringBuilder sql = new StringBuilder("select ");
        DatabaseInfo dbInfo = this.platform.getDatabaseInfo();
        String quote = this.platform.getDdlBuilder().isDelimitedIdentifierModeOn() ? dbInfo.getDelimiterToken() : "";
        for (Column lobColumn : lobColumns) {
            if ("XMLTYPE".equalsIgnoreCase(lobColumn.getJdbcTypeName()) && 2009 == lobColumn.getJdbcTypeCode()) {
                sql.append("extract(").append(quote).append(lobColumn.getName()).append(quote);
                sql.append(", '/').getClobVal()");
            } else if (this.isUniType(lobColumn.getJdbcTypeName()) && !lobColumn.getJdbcTypeName().equalsIgnoreCase("unitext")) {
                sql.append("bintostr(convert(varbinary(16384)," + lobColumn.getName() + ")) as " + lobColumn.getName());
            } else {
                sql.append(quote).append(lobColumn.getName()).append(quote);
            }
            sql.append(",");
        }
        sql.delete(sql.length() - 1, sql.length());
        sql.append(" from ");
        sql.append(table.getQualifiedTableName(quote, dbInfo.getCatalogSeparator(), dbInfo.getSchemaSeparator()));
        sql.append(" where ");
        for (Column col : pkColumns) {
            sql.append(quote).append(col.getName()).append(quote);
            sql.append("=? and ");
        }
        sql.delete(sql.length() - 5, sql.length());
        return sql.toString();
    }

    protected Row createRowForRequiredLobs(List<Column> lobColumns) {
        Row row = null;
        boolean isRequired = false;
        for (Column lobColumn : lobColumns) {
            if (!lobColumn.isRequired()) continue;
            isRequired = true;
            break;
        }
        if (isRequired) {
            row = new Row(lobColumns.size());
            for (Column lobColumn : lobColumns) {
                if (lobColumn.isRequired()) {
                    if (this.platform.isBlob(lobColumn)) {
                        row.put(lobColumn.getName(), (Object)new byte[0]);
                        continue;
                    }
                    row.put(lobColumn.getName(), (Object)"");
                    continue;
                }
                row.put(lobColumn.getName(), null);
            }
        }
        return row;
    }
}

