/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.io.data;

import org.jumpmind.db.sql.DmlStatement;

public enum DataEventType {
    INSERT("I"),
    UPDATE("U"),
    DELETE("D"),
    RELOAD("R"),
    SQL("S"),
    CREATE("C"),
    BSH("B"),
    UNKNOWN("U");

    private String code;

    private DataEventType(String code) {
        this.code = code;
    }

    public boolean isDml() {
        return this == INSERT || this == DELETE || this == UPDATE;
    }

    public String getCode() {
        return this.code;
    }

    public DmlStatement.DmlType getDmlType() {
        switch (this) {
            case INSERT: {
                return DmlStatement.DmlType.INSERT;
            }
            case UPDATE: {
                return DmlStatement.DmlType.UPDATE;
            }
            case DELETE: {
                return DmlStatement.DmlType.DELETE;
            }
        }
        return DmlStatement.DmlType.UNKNOWN;
    }

    public static DataEventType getEventType(String s) {
        if (s.equals(INSERT.getCode())) {
            return INSERT;
        }
        if (s.equals(UPDATE.getCode())) {
            return UPDATE;
        }
        if (s.equals(DELETE.getCode())) {
            return DELETE;
        }
        if (s.equals(RELOAD.getCode())) {
            return RELOAD;
        }
        if (s.equals(SQL.getCode())) {
            return SQL;
        }
        if (s.equals(CREATE.getCode())) {
            return CREATE;
        }
        if (s.equals(RELOAD.getCode())) {
            return RELOAD;
        }
        if (s.equals(BSH.getCode())) {
            return BSH;
        }
        throw new IllegalStateException(String.format("Invalid data event type of %s", s));
    }
}

