/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.io.data;

import java.nio.charset.Charset;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.Table;
import org.jumpmind.symmetric.io.data.CsvUtils;
import org.jumpmind.symmetric.io.data.DataEventType;
import org.jumpmind.util.LinkedCaseInsensitiveMap;

public class CsvData {
    public static final int MAX_DATA_SIZE_TO_PRINT_TO_LOG = 32768;
    public static final String OLD_DATA = "oldData";
    public static final String ROW_DATA = "rowData";
    public static final String PK_DATA = "pkData";
    public static final String RESOLVE_DATA = "resolveData";
    public static final String ATTRIBUTE_TABLE_NAME = "tableName";
    public static final String ATTRIBUTE_CHANNEL_ID = "channelId";
    public static final String ATTRIBUTE_TABLE_ID = "tableId";
    public static final String ATTRIBUTE_TX_ID = "transactionId";
    public static final String ATTRIBUTE_SOURCE_NODE_ID = "sourceNodeId";
    public static final String ATTRIBUTE_EXTERNAL_DATA = "externalData";
    public static final String ATTRIBUTE_NODE_LIST = "nodeList";
    public static final String ATTRIBUTE_DATA_ID = "dataId";
    public static final String ATTRIBUTE_CREATE_TIME = "createTime";
    private Map<String, String[]> parsedCsvData = null;
    private Map<String, String> csvData = null;
    private Map<String, Object> attributes;
    private boolean noBinaryOldData = false;
    protected DataEventType dataEventType;
    protected boolean[] changedDataIndicators;

    public CsvData(DataEventType dataEventType) {
        this.dataEventType = dataEventType;
    }

    public CsvData(DataEventType dataEventType, String[] pkData, String[] rowData) {
        this(dataEventType);
        this.putParsedData(PK_DATA, pkData);
        this.putParsedData(ROW_DATA, rowData);
    }

    public CsvData(DataEventType dataEventType, String[] rowData) {
        this(dataEventType);
        this.putParsedData(ROW_DATA, rowData);
    }

    public CsvData(DataEventType dataEventType, String[] rowData, String[] oldData, String[] resolveData) {
        this(dataEventType);
        this.putParsedData(ROW_DATA, rowData);
        this.putParsedData(OLD_DATA, oldData);
        this.putParsedData(RESOLVE_DATA, resolveData);
    }

    public CsvData() {
    }

    public boolean contains(String key) {
        return this.parsedCsvData != null && this.parsedCsvData.get(key) != null || this.csvData != null && this.csvData.get(key) != null;
    }

    public void setDataEventType(DataEventType dataEventType) {
        this.dataEventType = dataEventType;
    }

    public DataEventType getDataEventType() {
        return this.dataEventType;
    }

    public void putAttribute(String attributeName, Object attributeValue) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, Object>();
        }
        this.attributes.put(attributeName, attributeValue);
    }

    public <T> T getAttribute(String attributeName) {
        return (T)(this.attributes == null ? null : this.attributes.get(attributeName));
    }

    public void removeCsvData(String key) {
        if (this.csvData != null) {
            this.csvData.remove(key);
        }
    }

    public void removeParsedData(String key) {
        if (this.parsedCsvData != null) {
            this.parsedCsvData.remove(key);
        }
    }

    public void removeAllData(String key) {
        this.removeParsedData(key);
        this.removeCsvData(key);
    }

    public void putCsvData(String key, String data) {
        this.removeAllData(key);
        if (this.csvData == null) {
            this.csvData = new HashMap<String, String>(2);
        }
        this.changedDataIndicators = null;
        this.csvData.put(key, data);
    }

    public String getCsvData(String key) {
        String[] parsedData;
        String data = null;
        if (this.csvData != null) {
            data = this.csvData.get(key);
        }
        if (data == null && this.parsedCsvData != null && (parsedData = this.parsedCsvData.get(key)) != null) {
            data = CsvUtils.escapeCsvData(parsedData);
            this.putCsvData(key, data);
        }
        return data;
    }

    public boolean[] getChangedDataIndicators() {
        if (this.changedDataIndicators == null) {
            String[] newData = this.getParsedData(ROW_DATA);
            boolean[] changes = new boolean[newData.length];
            String[] oldData = this.getParsedData(OLD_DATA);
            for (int i = 0; i < newData.length; ++i) {
                if (oldData != null && oldData.length > i) {
                    if (newData[i] == null) {
                        changes[i] = oldData[i] != null;
                        continue;
                    }
                    if (oldData[i] == null) {
                        changes[i] = newData[i] != null;
                        continue;
                    }
                    changes[i] = !newData[i].equals(oldData[i]);
                    continue;
                }
                changes[i] = true;
            }
            this.changedDataIndicators = changes;
        }
        return this.changedDataIndicators;
    }

    public final void putParsedData(String key, String[] data) {
        this.removeAllData(key);
        if (this.parsedCsvData == null) {
            this.parsedCsvData = new HashMap<String, String[]>(2);
        }
        this.changedDataIndicators = null;
        this.parsedCsvData.put(key, data);
    }

    public String[] getParsedData(String key) {
        String data;
        String[] values = null;
        if (this.parsedCsvData != null && this.parsedCsvData.containsKey(key)) {
            values = this.parsedCsvData.get(key);
        } else if (this.csvData != null && this.csvData.containsKey(key) && (data = this.csvData.get(key)) != null) {
            values = CsvUtils.tokenizeCsvData(data);
            this.putParsedData(key, values);
        }
        return values;
    }

    public Map<String, String> toKeyColumnValuePairs(Table table) {
        Map<String, String> data = this.toColumnNameValuePairs(table.getPrimaryKeyColumnNames(), PK_DATA);
        if (data.size() == 0) {
            Column[] columns;
            data = this.toColumnNameValuePairs(table.getColumnNames(), OLD_DATA);
            if (data.size() == 0) {
                data = this.toColumnNameValuePairs(table.getColumnNames(), ROW_DATA);
            }
            for (Column column : columns = table.getColumns()) {
                if (column.isPrimaryKey()) continue;
                data.remove(column.getName());
            }
        }
        return data;
    }

    public String[] getPkData(Table table) {
        Map<String, String> data = this.toKeyColumnValuePairs(table);
        return data.values().toArray(new String[data.size()]);
    }

    public Map<String, String> toColumnNameValuePairs(String[] keyNames, String key) {
        String[] values = this.getParsedData(key);
        if (values != null && keyNames != null && values.length >= keyNames.length) {
            LinkedCaseInsensitiveMap map = new LinkedCaseInsensitiveMap(keyNames.length);
            for (int i = 0; i < keyNames.length; ++i) {
                map.put(keyNames[i], values[i]);
            }
            return map;
        }
        return new HashMap<String, String>(0);
    }

    public boolean requiresTable() {
        return this.dataEventType != null && this.dataEventType != DataEventType.CREATE && this.dataEventType != DataEventType.BSH;
    }

    public boolean isNoBinaryOldData() {
        return this.noBinaryOldData;
    }

    public void setNoBinaryOldData(boolean noBinaryOldData) {
        this.noBinaryOldData = noBinaryOldData;
    }

    public CsvData copyWithoutOldData() {
        CsvData data = new CsvData(this.getDataEventType(), this.getParsedData(ROW_DATA));
        data.attributes = this.attributes;
        return data;
    }

    public void writeCsvDataDetails(StringBuilder message) {
        String rowData = this.getCsvData(PK_DATA);
        if (StringUtils.isNotBlank((CharSequence)rowData)) {
            message.append("Failed pk data was: ");
            message.append(StringUtils.abbreviate((String)rowData, (int)32768));
            message.append("\n");
        }
        if (StringUtils.isNotBlank((CharSequence)(rowData = this.getCsvData(ROW_DATA)))) {
            if (rowData.length() < 32768) {
                message.append("Failed row data was: ");
                message.append(rowData);
                message.append("\n");
            } else {
                message.append("Row data was bigger than ");
                message.append(32768);
                message.append(" bytes (it was ");
                message.append(rowData.length());
                message.append(" bytes).  It will not be printed to the log file");
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(rowData = this.getCsvData(OLD_DATA)))) {
            if (rowData.length() < 32768) {
                message.append("Failed old data was: ");
                message.append(rowData);
                message.append("\n");
            } else {
                message.append("Old data was bigger than ");
                message.append(32768);
                message.append(" bytes (it was ");
                message.append(rowData.length());
                message.append(" bytes).  It will not be printed to the log file");
            }
        }
    }

    public long getSizeInBytes() {
        long size = 0L;
        if (this.csvData != null) {
            Collection<String> values = this.csvData.values();
            for (String string : values) {
                if (string == null) continue;
                size += (long)string.getBytes(Charset.defaultCharset()).length;
            }
        }
        return size;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
    }
}

