/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.factory;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.ClassHelper;
import com.helger.commons.lang.GenericReflection;
import com.helger.commons.string.ToStringGenerator;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class FactoryNewInstance<DATATYPE>
implements Supplier<DATATYPE> {
    private final Class<? extends DATATYPE> m_aClass;

    public FactoryNewInstance(@Nullable Class<? extends DATATYPE> clazz, boolean bl) {
        if (bl) {
            ValueEnforcer.isTrue(ClassHelper.isInstancableClass(clazz), () -> "The passed class '" + String.valueOf(clazz) + "' is not instancable or doesn't have a public no-argument constructor!");
        }
        this.m_aClass = clazz;
    }

    @Nullable
    public Class<? extends DATATYPE> getFactoryClass() {
        return this.m_aClass;
    }

    @Override
    @Nullable
    public DATATYPE get() {
        return GenericReflection.newInstance(this.m_aClass);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        FactoryNewInstance factoryNewInstance = (FactoryNewInstance)object;
        return EqualsHelper.equals(this.m_aClass, factoryNewInstance.m_aClass);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_aClass).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("Class", this.m_aClass).getToString();
    }

    @Nonnull
    public static <DATATYPE> FactoryNewInstance<DATATYPE> create(@Nullable Class<DATATYPE> clazz) {
        return FactoryNewInstance.create(clazz, false);
    }

    @Nonnull
    public static <DATATYPE> FactoryNewInstance<DATATYPE> create(@Nullable Class<DATATYPE> clazz, boolean bl) {
        return new FactoryNewInstance<DATATYPE>(clazz, bl);
    }
}

