/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.signals;

import com.vaadin.signals.ListSignal;
import com.vaadin.signals.MapSignal;
import com.vaadin.signals.NodeSignal;
import com.vaadin.signals.NumberSignal;
import com.vaadin.signals.ValueSignal;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

@FunctionalInterface
public interface SignalFactory {
    public static final SignalFactory IN_MEMORY_EXCLUSIVE = ignore -> new NodeSignal();
    public static final SignalFactory IN_MEMORY_SHARED = new SignalFactory(){
        private final Map<String, NodeSignal> instances = new ConcurrentHashMap<String, NodeSignal>();

        @Override
        public NodeSignal node(String name) {
            return this.instances.computeIfAbsent(name, ignore -> new NodeSignal());
        }

        @Override
        public void remove(String name) {
            this.instances.remove(name);
        }

        @Override
        public void clear() {
            this.instances.clear();
        }
    };

    public NodeSignal node(String var1);

    default public <T> ValueSignal<T> value(String name, Class<T> valueType) {
        return this.node(name).asValue(valueType);
    }

    default public <T> ValueSignal<T> value(String name, Class<T> valueType, T defaultValue) {
        Objects.requireNonNull(defaultValue, "The default value cannot be null");
        ValueSignal<Class<T>> signal = this.value(name, (T)valueType);
        if (signal.peek() == null) {
            signal.replace((Class<T>)null, (Class<T>)defaultValue);
        }
        return signal;
    }

    default public <T> ValueSignal<T> value(String name, T defaultValue) {
        Objects.requireNonNull(defaultValue, "The default value cannot be null");
        Class<?> valueType = defaultValue.getClass();
        return this.value(name, valueType, defaultValue);
    }

    default public NumberSignal number(String name) {
        return this.node(name).asNumber();
    }

    default public NumberSignal number(String name, double defaultValue) {
        return this.value(name, Double.class, defaultValue).asNode().asNumber();
    }

    default public <T> ListSignal<T> list(String name, Class<T> elementType) {
        return this.node(name).asList(elementType);
    }

    default public <T> MapSignal<T> map(String name, Class<T> elementType) {
        return this.node(name).asMap(elementType);
    }

    default public void remove(String name) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    default public void clear() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }
}

