/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.signals;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;

public class SignalEnvironment {
    private static final AtomicReference<InitializationState> state = new AtomicReference();
    private static final List<Supplier<Executor>> dispatcherOverrides = new CopyOnWriteArrayList<Supplier<Executor>>();

    private SignalEnvironment() {
    }

    public static boolean tryInitialize(ObjectMapper objectMapper, Executor dispatcher) {
        Objects.requireNonNull(objectMapper);
        Objects.requireNonNull(dispatcher);
        return state.compareAndSet(null, new InitializationState(objectMapper, dispatcher));
    }

    public static boolean initialized() {
        return state.get() != null;
    }

    public static Runnable addDispatcherOverride(Supplier<Executor> dispatcherOverride) {
        dispatcherOverrides.add(0, Objects.requireNonNull(dispatcherOverride));
        return () -> dispatcherOverrides.remove(dispatcherOverride);
    }

    private static InitializationState getState() {
        InitializationState result = state.get();
        if (result == null) {
            throw new IllegalStateException("The environment must be initialized before used");
        }
        return result;
    }

    public static ObjectMapper objectMapper() {
        return SignalEnvironment.getState().objectMapper;
    }

    public static Executor defaultDispatcher() {
        return SignalEnvironment.getState().dispatcher;
    }

    public static Executor asynchronousDispatcher() {
        return SignalEnvironment.resolveDispatcher(SignalEnvironment.defaultDispatcher());
    }

    public static Executor synchronousDispatcher() {
        return SignalEnvironment.resolveDispatcher(Runnable::run);
    }

    private static Executor resolveDispatcher(Executor baseline) {
        for (Supplier<Executor> supplier : dispatcherOverrides) {
            Executor override = supplier.get();
            if (override == null) continue;
            return override;
        }
        return baseline;
    }

    private record InitializationState(ObjectMapper objectMapper, Executor dispatcher) {
    }
}

