/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.signals;

import com.vaadin.signals.Id;
import com.vaadin.signals.Node;
import com.vaadin.signals.NodeSignal;
import com.vaadin.signals.Signal;
import com.vaadin.signals.SignalCommand;
import com.vaadin.signals.ValueSignal;
import com.vaadin.signals.impl.CommandResult;
import com.vaadin.signals.impl.SignalTree;
import com.vaadin.signals.impl.SynchronousSignalTree;
import com.vaadin.signals.operations.InsertOperation;
import com.vaadin.signals.operations.SignalOperation;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class MapSignal<T>
extends Signal<Map<String, ValueSignal<T>>> {
    private Class<T> elementType;

    public MapSignal(Class<T> elementType) {
        this(new SynchronousSignalTree(false), Id.ZERO, ANYTHING_GOES, elementType);
    }

    protected MapSignal(SignalTree tree, Id id, Predicate<SignalCommand> validator, Class<T> elementType) {
        super(tree, id, validator);
        this.elementType = Objects.requireNonNull(elementType);
    }

    private ValueSignal<T> child(Id childId) {
        return new ValueSignal<T>(this.tree(), childId, this.validator(), this.elementType);
    }

    @Override
    protected Map<String, ValueSignal<T>> extractValue(Node.Data data) {
        if (data == null) {
            return Map.of();
        }
        return MapSignal.children(data, this::child);
    }

    @Override
    protected Object usageChangeValue(Node.Data data) {
        return data.mapChildren();
    }

    public SignalOperation<T> put(String key, T value) {
        return this.submit(new SignalCommand.PutCommand(Id.random(), this.id(), Objects.requireNonNull(key), MapSignal.toJson(value)), success -> {
            if (success.updates().size() == 1) {
                return MapSignal.nodeValue(success.onlyUpdate().oldNode(), this.elementType);
            }
            assert (success.updates().size() == 2);
            return null;
        });
    }

    public InsertOperation<ValueSignal<T>> putIfAbsent(String key, T value) {
        return this.submitInsert(new SignalCommand.PutIfAbsentCommand(Id.random(), this.id(), null, Objects.requireNonNull(key), MapSignal.toJson(value)), this::child);
    }

    public SignalOperation<T> remove(String key) {
        return this.submit(new SignalCommand.RemoveByKeyCommand(Id.random(), this.id(), Objects.requireNonNull(key)), success -> {
            CommandResult.NodeModification removal = success.updates().values().stream().filter(update -> update.newNode() == null).findAny().get();
            return MapSignal.nodeValue(removal.oldNode(), this.elementType);
        });
    }

    @Override
    public SignalOperation<Void> clear() {
        return super.clear();
    }

    private SignalOperation<Void> submitKeyCondition(String key, Id expectedChildId) {
        return this.submit(new SignalCommand.KeyCondition(Id.random(), this.id(), key, expectedChildId));
    }

    public SignalOperation<Void> verifyKey(String key, Signal<?> expectedChild) {
        return this.submitKeyCondition(Objects.requireNonNull(key), expectedChild.id());
    }

    public SignalOperation<Void> verifyHasKey(String key) {
        return this.submitKeyCondition(key, null);
    }

    public SignalOperation<Void> verifyKeyAbsent(String key) {
        return this.submitKeyCondition(key, Id.ZERO);
    }

    public MapSignal<T> withValidator(Predicate<SignalCommand> validator) {
        return new MapSignal<T>(this.tree(), this.id(), this.mergeValidators(validator), this.elementType);
    }

    public MapSignal<T> asReadonly() {
        return this.withValidator(anything -> false);
    }

    @Override
    public NodeSignal asNode() {
        return super.asNode();
    }

    static <T extends Signal<?>> Map<String, T> children(Node.Data node, Function<Id, T> factory) {
        LinkedHashMap children = new LinkedHashMap();
        node.mapChildren().forEach((key, id) -> children.put(key, (Signal)factory.apply((Id)id)));
        return Collections.unmodifiableMap(children);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof MapSignal)) return false;
        MapSignal other = (MapSignal)obj;
        if (!Objects.equals(this.tree(), other.tree())) return false;
        if (!Objects.equals(this.id(), other.id())) return false;
        if (!Objects.equals(this.validator(), other.validator())) return false;
        if (!Objects.equals(this.elementType, other.elementType)) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.tree(), this.id(), this.validator(), this.elementType);
    }

    public String toString() {
        return ((Map)this.peek()).entrySet().stream().map((? super T entry) -> (String)entry.getKey() + "=" + ((ValueSignal)entry.getValue()).value()).collect(Collectors.joining(", ", "MapSignal[", "]"));
    }
}

