/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.addons.chartjs.options.scale;

import elemental.json.Json;
import elemental.json.JsonObject;
import java.time.LocalDateTime;
import org.vaadin.addons.chartjs.options.scale.TimeDisplayFormats;
import org.vaadin.addons.chartjs.options.scale.TimeScale;
import org.vaadin.addons.chartjs.utils.And;
import org.vaadin.addons.chartjs.utils.JUtils;
import org.vaadin.addons.chartjs.utils.JsonBuilder;

public class TimeScaleOptions
extends And<TimeScale>
implements JsonBuilder {
    private static final long serialVersionUID = -9154944512274347096L;
    private String format;
    private TimeDisplayFormats displayFormats;
    private Boolean isoWeekday;
    private LocalDateTime max;
    private LocalDateTime min;
    private Unit round;
    private String tooltipFormat;
    private Unit unit;
    private Integer stepSize;
    private Unit minUnit;

    static String unitToString(Unit unit) {
        if (unit == null) {
            return null;
        }
        return unit.toString().toLowerCase();
    }

    public TimeScaleOptions(TimeScale parent) {
        super(parent);
    }

    public TimeScaleOptions format(String format) {
        this.format = format;
        return this;
    }

    public TimeDisplayFormats displayFormats() {
        this.displayFormats = new TimeDisplayFormats(this);
        return this.displayFormats;
    }

    public TimeScaleOptions isoWeekday(boolean isoWeekday) {
        this.isoWeekday = isoWeekday;
        return this;
    }

    public TimeScaleOptions min(LocalDateTime min) {
        this.min = min;
        return this;
    }

    public TimeScaleOptions max(LocalDateTime max) {
        this.max = max;
        return this;
    }

    public TimeScaleOptions round(Unit round) {
        this.round = round;
        return this;
    }

    public TimeScaleOptions tooltipFormat(String tooltipFormat) {
        this.tooltipFormat = tooltipFormat;
        return this;
    }

    public TimeScaleOptions unit(Unit unit) {
        this.unit = unit;
        return this;
    }

    public TimeScaleOptions stepSize(int stepSize) {
        this.stepSize = stepSize;
        return this;
    }

    public TimeScaleOptions minUnit(Unit minUnit) {
        this.minUnit = minUnit;
        return this;
    }

    @Override
    public JsonObject buildJson() {
        JsonObject map = Json.createObject();
        JUtils.putNotNull(map, "format", this.format);
        JUtils.putNotNull(map, "displayFormats", this.displayFormats);
        JUtils.putNotNull(map, "isoWeekday", this.isoWeekday);
        JUtils.putNotNull(map, "min", this.min);
        JUtils.putNotNull(map, "max", this.max);
        JUtils.putNotNull(map, "round", TimeScaleOptions.unitToString(this.round));
        JUtils.putNotNull(map, "tooltipFormat", this.tooltipFormat);
        JUtils.putNotNull(map, "unit", TimeScaleOptions.unitToString(this.unit));
        JUtils.putNotNull(map, "stepSize", this.stepSize);
        JUtils.putNotNull(map, "minUnit", TimeScaleOptions.unitToString(this.minUnit));
        return map;
    }

    public static enum Unit {
        MILLISECOND,
        SECOND,
        MINUTE,
        HOUR,
        DAY,
        WEEK,
        MONTH,
        QUARTER,
        YEAR;

    }
}

