/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.addons.chartjs.options.elements;

import elemental.json.Json;
import elemental.json.JsonObject;
import java.io.Serializable;
import org.vaadin.addons.chartjs.options.elements.Element;
import org.vaadin.addons.chartjs.utils.And;
import org.vaadin.addons.chartjs.utils.JUtils;
import org.vaadin.addons.chartjs.utils.JsonBuilder;

public class Rectangle<T>
extends And<Element<T>>
implements JsonBuilder,
Serializable {
    private static final long serialVersionUID = -7110880763985894909L;
    private String backgroundColor;
    private String borderColor;
    private Integer borderWidth;
    private RectangleEdge borderSkipped;

    public Rectangle(Element<T> parent) {
        super(parent);
    }

    public Rectangle<T> backgroundColor(String backgroundColor) {
        this.backgroundColor = backgroundColor;
        return this;
    }

    public Rectangle<T> borderColor(String borderColor) {
        this.borderColor = borderColor;
        return this;
    }

    public Rectangle<T> borderWidth(int borderWidth) {
        this.borderWidth = borderWidth;
        return this;
    }

    public Rectangle<T> borderSkipped(RectangleEdge borderSkipped) {
        this.borderSkipped = borderSkipped;
        return this;
    }

    @Override
    public JsonObject buildJson() {
        JsonObject map = Json.createObject();
        JUtils.putNotNull(map, "backgroundColor", this.backgroundColor);
        JUtils.putNotNull(map, "borderColor", this.borderColor);
        JUtils.putNotNull(map, "borderWidth", this.borderWidth);
        if (this.borderSkipped != null) {
            JUtils.putNotNull(map, "borderSkipped", this.borderSkipped.name().toLowerCase());
        }
        return map;
    }

    public static enum RectangleEdge {
        BOTTOM,
        LEFT,
        TOP,
        RIGHT;

    }
}

