/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.addons.chartjs.options.elements;

import elemental.json.Json;
import elemental.json.JsonObject;
import java.io.Serializable;
import org.vaadin.addons.chartjs.data.PointStyle;
import org.vaadin.addons.chartjs.options.elements.Element;
import org.vaadin.addons.chartjs.utils.And;
import org.vaadin.addons.chartjs.utils.JUtils;
import org.vaadin.addons.chartjs.utils.JsonBuilder;

public class Point<T>
extends And<Element<T>>
implements JsonBuilder,
Serializable {
    private static final long serialVersionUID = -2070842646780416509L;
    private Integer radius;
    private PointStyle pointStyle;
    private String backgroundColor;
    private Integer borderWidth;
    private String borderColor;
    private Integer hitRadius;
    private Integer hoverRadius;
    private Integer hoverBorderWidth;

    public Point(Element<T> parent) {
        super(parent);
    }

    public Point<T> radius(int radius) {
        this.radius = radius;
        return this;
    }

    public Point<T> pointStyle(String pointStyle) {
        try {
            this.pointStyle(PointStyle.valueOf(pointStyle));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this;
    }

    public Point<T> pointStyle(PointStyle pointStyle) {
        this.pointStyle = pointStyle;
        return this;
    }

    public Point<T> backgroundColor(String backgroundColor) {
        this.backgroundColor = backgroundColor;
        return this;
    }

    public Point<T> borderWidth(int borderWidth) {
        this.borderWidth = borderWidth;
        return this;
    }

    public Point<T> borderColor(String borderColor) {
        this.borderColor = borderColor;
        return this;
    }

    public Point<T> hitRadius(int hitRadius) {
        this.hitRadius = hitRadius;
        return this;
    }

    public Point<T> hoverRadius(int hoverRadius) {
        this.hoverRadius = hoverRadius;
        return this;
    }

    public Point<T> hoverBorderWidth(int hoverBorderWidth) {
        this.hoverBorderWidth = hoverBorderWidth;
        return this;
    }

    @Override
    public JsonObject buildJson() {
        JsonObject map = Json.createObject();
        JUtils.putNotNull(map, "radius", this.radius);
        if (this.pointStyle != null) {
            JUtils.putNotNull(map, "pointStyle", this.pointStyle.name());
        }
        JUtils.putNotNull(map, "backgroundColor", this.backgroundColor);
        JUtils.putNotNull(map, "borderColor", this.borderColor);
        JUtils.putNotNull(map, "borderWidth", this.borderWidth);
        JUtils.putNotNull(map, "hitRadius", this.hitRadius);
        JUtils.putNotNull(map, "hoverRadius", this.hoverRadius);
        JUtils.putNotNull(map, "hoverBorderWidth", this.hoverBorderWidth);
        return map;
    }
}

