/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.addons.chartjs.options;

import elemental.json.Json;
import elemental.json.JsonObject;
import java.io.Serializable;
import org.vaadin.addons.chartjs.options.zoom.PanRange;
import org.vaadin.addons.chartjs.options.zoom.XYMode;
import org.vaadin.addons.chartjs.utils.And;
import org.vaadin.addons.chartjs.utils.JUtils;
import org.vaadin.addons.chartjs.utils.JsonBuilder;

public class Pan<T>
extends And<T>
implements JsonBuilder,
Serializable {
    private static final long serialVersionUID = 809245656623461157L;
    private boolean enabled = true;
    private Double speed;
    private Double threshold;
    private XYMode mode;
    private PanRange<T> rangeMin;
    private PanRange<T> rangeMax;

    public Pan(T parent) {
        super(parent);
    }

    public Pan<T> enabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public Pan<T> speed(double speed) {
        this.speed = speed;
        return this;
    }

    public Pan<T> threshold(double threshold) {
        this.threshold = threshold;
        return this;
    }

    public Pan<T> mode(XYMode mode) {
        this.mode = mode;
        return this;
    }

    public PanRange<T> rangeMin() {
        if (this.rangeMin == null) {
            this.rangeMin = new PanRange(this);
        }
        return this.rangeMin;
    }

    public PanRange<T> rangeMax() {
        if (this.rangeMax == null) {
            this.rangeMax = new PanRange(this);
        }
        return this.rangeMax;
    }

    @Override
    public JsonObject buildJson() {
        JsonObject map = Json.createObject();
        JUtils.putNotNull(map, "enabled", this.enabled);
        JUtils.putNotNull(map, "speed", this.speed);
        JUtils.putNotNull(map, "threshold", this.threshold);
        if (this.mode != null) {
            JUtils.putNotNull(map, "mode", this.mode.name().toLowerCase());
        }
        JUtils.putNotNull(map, "rangeMin", this.rangeMin);
        JUtils.putNotNull(map, "rangeMax", this.rangeMax);
        return map;
    }
}

