/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.addons.chartjs.options;

import elemental.json.Json;
import elemental.json.JsonObject;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.vaadin.addons.chartjs.config.ChartConfig;
import org.vaadin.addons.chartjs.options.Animation;
import org.vaadin.addons.chartjs.options.Hover;
import org.vaadin.addons.chartjs.options.Legend;
import org.vaadin.addons.chartjs.options.Pan;
import org.vaadin.addons.chartjs.options.Title;
import org.vaadin.addons.chartjs.options.Tooltips;
import org.vaadin.addons.chartjs.options.Zoom;
import org.vaadin.addons.chartjs.options.elements.Element;
import org.vaadin.addons.chartjs.utils.JUtils;
import org.vaadin.addons.chartjs.utils.JsonBuilder;

public abstract class AbstractOptions<T>
implements JsonBuilder,
Serializable {
    private static final long serialVersionUID = 2220469604021816291L;
    private ChartConfig chartConfig;
    protected Boolean responsive;
    private Integer responsiveAnimationDuration;
    private Boolean maintainAspectRatio;
    private Integer devicePixelRatio;
    private List<String> events;
    private Title<T> title;
    private Tooltips<T> tooltips;
    private Hover<T> hover;
    private Animation<T> animation;
    private Legend<T> legend;
    private Element<T> elements;
    private Pan<T> pan;
    private Zoom<T> zoom;

    public AbstractOptions(ChartConfig chartConfig) {
        this.chartConfig = chartConfig;
    }

    public T responsive(boolean responsive) {
        this.responsive = responsive;
        return this.getThis();
    }

    public T maintainAspectRatio(boolean maintainAspectRatio) {
        this.maintainAspectRatio = maintainAspectRatio;
        return this.getThis();
    }

    public T responsiveAnimationDuration(int responsiveAnimationDurationMs) {
        this.responsiveAnimationDuration = responsiveAnimationDurationMs;
        return this.getThis();
    }

    public T devicePixelRatio(int devicePixelRatio) {
        this.devicePixelRatio = devicePixelRatio;
        return this.getThis();
    }

    public T events(String ... events) {
        this.events = Arrays.asList(events);
        return this.getThis();
    }

    public Title<T> title() {
        if (this.title == null) {
            this.title = new Title<T>(this.getThis());
        }
        return this.title;
    }

    public Animation<T> animation() {
        if (this.animation == null) {
            this.animation = new Animation<T>(this.getThis());
        }
        return this.animation;
    }

    public Hover<T> hover() {
        if (this.hover == null) {
            this.hover = new Hover<T>(this.getThis());
        }
        return this.hover;
    }

    public Tooltips<T> tooltips() {
        if (this.tooltips == null) {
            this.tooltips = new Tooltips<T>(this.getThis());
        }
        return this.tooltips;
    }

    public Legend<T> legend() {
        if (this.legend == null) {
            this.legend = new Legend<T>(this.getThis());
        }
        return this.legend;
    }

    public Element<T> elements() {
        if (this.elements == null) {
            this.elements = new Element<T>(this.getThis());
        }
        return this.elements;
    }

    public Pan<T> pan() {
        if (this.pan == null) {
            this.pan = new Pan<T>(this.getThis());
        }
        return this.pan;
    }

    public Zoom<T> zoom() {
        if (this.zoom == null) {
            this.zoom = new Zoom<T>(this.getThis());
        }
        return this.zoom;
    }

    public abstract T getThis();

    @Override
    public JsonObject buildJson() {
        JsonObject map = Json.createObject();
        JUtils.putNotNull(map, "responsive", this.responsive);
        JUtils.putNotNull(map, "maintainAspectRatio", this.maintainAspectRatio);
        JUtils.putNotNull(map, "responsiveAnimationDuration", this.responsiveAnimationDuration);
        JUtils.putNotNull(map, "devicePixelRatio", this.devicePixelRatio);
        JUtils.putNotNull(map, "events", this.events);
        JUtils.putNotNull(map, "title", this.title);
        JUtils.putNotNull(map, "hover", this.hover);
        JUtils.putNotNull(map, "tooltips", this.tooltips);
        JUtils.putNotNull(map, "animation", this.animation);
        JUtils.putNotNull(map, "legend", this.legend);
        JUtils.putNotNull(map, "elements", this.elements);
        JUtils.putNotNull(map, "pan", this.pan);
        JUtils.putNotNull(map, "zoom", this.zoom);
        return map;
    }

    public ChartConfig done() {
        return this.chartConfig;
    }
}

