/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.addons.chartjs.data;

import elemental.json.Json;
import elemental.json.JsonObject;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;
import org.vaadin.addons.chartjs.data.PointStyle;
import org.vaadin.addons.chartjs.data.TimeDoubleDataset;
import org.vaadin.addons.chartjs.options.FillMode;
import org.vaadin.addons.chartjs.utils.JUtils;
import org.vaadin.addons.chartjs.utils.Pair;

public class TimeLineDataset
extends TimeDoubleDataset<TimeLineDataset> {
    private static final long serialVersionUID = -2084714266214798266L;
    private String type;
    private Boolean hidden;
    private String label;
    private String xAxisID;
    private String yAxisID;
    private Boolean fill;
    private Boolean fillToPlus;
    private Integer fillToDatasetIndex;
    private FillMode fillMode;
    private CubicInterpolationMode cubicInterpolationMode;
    private Double lineTension;
    private String backgroundColor;
    private Integer borderWidth;
    private String borderColor;
    private String borderCapStyle;
    private List<Integer> borderDash;
    private Double borderDashOffset;
    private String borderJoinStyle;
    private List<String> pointBorderColor;
    private List<String> pointBackgroundColor;
    private List<Integer> pointBorderWidth;
    private List<Integer> pointRadius;
    private List<Integer> pointHoverRadius;
    private List<Integer> pointHitRadius;
    private List<String> pointHoverBackgroundColor;
    private List<String> pointHoverBorderColor;
    private List<Integer> pointHoverBorderWidth;
    private PointStyle pointStyle;
    private Boolean showLine;
    private Boolean spanGaps;
    private String steppedLine;

    public TimeLineDataset type() {
        this.type = "line";
        return this;
    }

    public TimeLineDataset label(String label) {
        this.label = label;
        return this;
    }

    public TimeLineDataset xAxisID(String xAxisID) {
        this.xAxisID = xAxisID;
        return this;
    }

    public TimeLineDataset yAxisID(String yAxisID) {
        this.yAxisID = yAxisID;
        return this;
    }

    public TimeLineDataset fill(boolean fill) {
        this.fill = fill;
        return this;
    }

    public TimeLineDataset fill(FillMode fillMode) {
        this.fillMode = fillMode;
        return this;
    }

    public TimeLineDataset fill(int datasetIndex) {
        this.fillToDatasetIndex = datasetIndex;
        return this;
    }

    public TimeLineDataset fill(boolean next, int datasetIndex) {
        this.fillToPlus = next;
        this.fillToDatasetIndex = datasetIndex;
        return this;
    }

    public TimeLineDataset cubicInterpolationMode(CubicInterpolationMode cubicInterpolationMode) {
        this.cubicInterpolationMode = cubicInterpolationMode;
        return this;
    }

    public TimeLineDataset hidden(boolean hidden) {
        this.hidden = hidden;
        return this;
    }

    public TimeLineDataset lineTension(double lineTension) {
        this.lineTension = lineTension;
        return this;
    }

    public TimeLineDataset backgroundColor(String backgroundColor) {
        this.backgroundColor = backgroundColor;
        return this;
    }

    public TimeLineDataset borderWidth(int borderWidth) {
        this.borderWidth = borderWidth;
        return this;
    }

    public TimeLineDataset borderColor(String borderColor) {
        this.borderColor = borderColor;
        return this;
    }

    public TimeLineDataset borderCapStyle(String borderCapStyle) {
        this.borderCapStyle = borderCapStyle;
        return this;
    }

    public TimeLineDataset borderDash(Integer ... borderDash) {
        this.borderDash = Arrays.asList(borderDash);
        return this;
    }

    public TimeLineDataset borderDashOffset(double borderDashOffset) {
        this.borderDashOffset = borderDashOffset;
        return this;
    }

    public TimeLineDataset borderJoinStyle(String borderJoinStyle) {
        this.borderJoinStyle = borderJoinStyle;
        return this;
    }

    public TimeLineDataset pointBorderColor(String ... pointBorderColor) {
        this.pointBorderColor = Arrays.asList(pointBorderColor);
        return this;
    }

    public TimeLineDataset pointBackgroundColor(String ... pointBackgroundColor) {
        this.pointBackgroundColor = Arrays.asList(pointBackgroundColor);
        return this;
    }

    public TimeLineDataset pointBorderWidth(Integer ... pointBorderWidth) {
        this.pointBorderWidth = Arrays.asList(pointBorderWidth);
        return this;
    }

    public TimeLineDataset pointRadius(Integer ... pointRadius) {
        this.pointRadius = Arrays.asList(pointRadius);
        return this;
    }

    public TimeLineDataset pointHoverRadius(Integer ... pointHoverRadius) {
        this.pointHoverRadius = Arrays.asList(pointHoverRadius);
        return this;
    }

    public TimeLineDataset pointHitRadius(Integer ... pointHitRadius) {
        this.pointHitRadius = Arrays.asList(pointHitRadius);
        return this;
    }

    public TimeLineDataset pointHoverBackgroundColor(String ... pointHoverBackgroundColor) {
        this.pointHoverBackgroundColor = Arrays.asList(pointHoverBackgroundColor);
        return this;
    }

    public TimeLineDataset pointHoverBorderColor(String ... pointHoverBorderColor) {
        this.pointHoverBorderColor = Arrays.asList(pointHoverBorderColor);
        return this;
    }

    public TimeLineDataset pointHoverBorderWidth(Integer ... pointHoverBorderWidth) {
        this.pointHoverBorderWidth = Arrays.asList(pointHoverBorderWidth);
        return this;
    }

    public TimeLineDataset pointStyle(PointStyle pointStyle) {
        this.pointStyle = pointStyle;
        return this;
    }

    public TimeLineDataset showLine(boolean showLine) {
        this.showLine = showLine;
        return this;
    }

    public TimeLineDataset spanGaps(boolean spanGaps) {
        this.spanGaps = spanGaps;
        return this;
    }

    public TimeLineDataset steppedLine(boolean steppedLine) {
        this.steppedLine = Boolean.toString(steppedLine);
        return this;
    }

    public TimeLineDataset steppedLine(String steppedLine) {
        this.steppedLine = steppedLine;
        return this;
    }

    @Override
    public JsonObject buildJson() {
        JsonObject map = Json.createObject();
        JUtils.putNotNull(map, "type", this.type);
        JUtils.putNotNullTimeDoublePairs(map, "data", this.getData());
        JUtils.putNotNull(map, "label", this.label);
        JUtils.putNotNull(map, "xAxisID", this.xAxisID);
        JUtils.putNotNull(map, "yAxisID", this.yAxisID);
        if (this.fillToPlus != null && this.fillToDatasetIndex != null) {
            JUtils.putNotNull(map, "fill", (this.fillToPlus != false ? "+" : "-") + this.fillToDatasetIndex);
        } else if (this.fillToPlus == null && this.fillToDatasetIndex != null) {
            JUtils.putNotNull(map, "fill", this.fillToDatasetIndex);
        } else if (this.fillMode != null) {
            JUtils.putNotNull(map, "fill", this.fillMode.name().toLowerCase());
        } else {
            JUtils.putNotNull(map, "fill", this.fill);
        }
        if (this.cubicInterpolationMode != null) {
            JUtils.putNotNull(map, "cubicInterpolationMode", this.cubicInterpolationMode.toString().toLowerCase());
        }
        JUtils.putNotNull(map, "hidden", this.hidden);
        JUtils.putNotNull(map, "lineTension", this.lineTension);
        JUtils.putNotNull(map, "backgroundColor", this.backgroundColor);
        JUtils.putNotNull(map, "borderWidth", this.borderWidth);
        JUtils.putNotNull(map, "borderColor", this.borderColor);
        JUtils.putNotNull(map, "borderCapStyle", this.borderCapStyle);
        JUtils.putNotNullIntList(map, "borderDash", this.borderDash);
        JUtils.putNotNull(map, "borderDashOffset", this.borderDashOffset);
        JUtils.putNotNull(map, "borderJoinStyle", this.borderJoinStyle);
        JUtils.putNotNullStringListOrSingle(map, "pointBorderColor", this.pointBorderColor);
        JUtils.putNotNullStringListOrSingle(map, "pointBackgroundColor", this.pointBackgroundColor);
        JUtils.putNotNullIntListOrSingle(map, "pointBorderWidth", this.pointBorderWidth);
        JUtils.putNotNullIntListOrSingle(map, "pointRadius", this.pointRadius);
        JUtils.putNotNullIntListOrSingle(map, "pointHoverRadius", this.pointHoverRadius);
        JUtils.putNotNullIntListOrSingle(map, "pointHitRadius", this.pointHitRadius);
        JUtils.putNotNullStringListOrSingle(map, "pointHoverBackgroundColor", this.pointHoverBackgroundColor);
        JUtils.putNotNullStringListOrSingle(map, "pointHoverBorderColor", this.pointHoverBorderColor);
        JUtils.putNotNullIntListOrSingle(map, "pointHoverBorderWidth", this.pointHoverBorderWidth);
        if (this.pointStyle != null) {
            JUtils.putNotNull(map, "pointStyle", this.pointStyle.name());
        }
        JUtils.putNotNull(map, "showLine", this.showLine);
        JUtils.putNotNull(map, "spanGaps", this.spanGaps);
        JUtils.putNotNull(map, "steppedLine", this.steppedLine);
        return map;
    }

    @Override
    public TimeLineDataset getThis() {
        return this;
    }

    @Override
    public TimeLineDataset addLabeledData(String label, Pair<LocalDateTime, Double> data) {
        return this;
    }

    @Override
    public List<String> getDataLabels() {
        return null;
    }

    public static enum CubicInterpolationMode {
        DEFAULT,
        MONOTONE;

    }
}

