/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.addons.chartjs.data;

import elemental.json.Json;
import elemental.json.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.vaadin.addons.chartjs.data.Dataset;
import org.vaadin.addons.chartjs.utils.And;
import org.vaadin.addons.chartjs.utils.JUtils;
import org.vaadin.addons.chartjs.utils.JsonBuilder;

public class Data<T>
extends And<T>
implements JsonBuilder {
    private static final long serialVersionUID = 8683322928360358252L;
    private List<String> labels;
    private List<Dataset<?, ?>> datasets;
    private boolean extractLabelsFromDataset;

    public Data(T chartConfig) {
        super(chartConfig);
    }

    public Data<T> labels(String ... labels) {
        this.labels = Arrays.asList(labels);
        return this;
    }

    public Data<T> labelsAsList(List<String> labels) {
        this.labels = labels;
        return this;
    }

    public Data<T> addDataset(Dataset<?, ?> dataset) {
        if (this.datasets == null) {
            this.datasets = new ArrayList();
        }
        this.datasets.add(dataset);
        return this;
    }

    public List<Dataset<?, ?>> getDatasets() {
        return this.datasets;
    }

    public Dataset<?, ?> getDatasetAtIndex(int index) {
        if (this.datasets != null && index >= 0 && index < this.datasets.size()) {
            return this.datasets.get(index);
        }
        return null;
    }

    public Dataset<?, ?> getFirstDataset() {
        return this.getDatasetAtIndex(0);
    }

    public Data<T> extractLabelsFromDataset(boolean extractLabelsFromDataset) {
        this.extractLabelsFromDataset = extractLabelsFromDataset;
        return this;
    }

    public Data<T> clear() {
        if (this.datasets != null) {
            this.datasets.clear();
        }
        return this;
    }

    public List<String> getLabels() {
        return this.labels;
    }

    @Override
    public JsonObject buildJson() {
        Iterator<Dataset<?, ?>> iterator;
        JsonObject map = Json.createObject();
        if (this.extractLabelsFromDataset && this.datasets != null && (iterator = this.datasets.iterator()).hasNext()) {
            Dataset<?, ?> dataset = iterator.next();
            this.labels = dataset.getDataLabels();
        }
        JUtils.putNotNull(map, "labels", this.labels);
        JUtils.putNotNullBuilders(map, "datasets", this.datasets);
        return map;
    }
}

