/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.web;

import com.jumpmind.symmetric.console.SymmetricConsole;
import com.jumpmind.symmetric.console.impl.N;
import com.jumpmind.symmetric.console.model.ConsoleEvent;
import com.jumpmind.symmetric.console.model.ConsoleUser;
import com.jumpmind.symmetric.console.service.IConsoleUserService;
import com.jumpmind.symmetric.console.service.impl.ConsoleEventService;
import com.jumpmind.symmetric.web.InternalServerErrorException;
import com.jumpmind.symmetric.web.NotAllowedException;
import com.jumpmind.symmetric.web.NotFoundException;
import com.jumpmind.symmetric.web.model.Batch;
import com.jumpmind.symmetric.web.model.BatchAckResults;
import com.jumpmind.symmetric.web.model.BatchResult;
import com.jumpmind.symmetric.web.model.BatchResults;
import com.jumpmind.symmetric.web.model.BatchSummaries;
import com.jumpmind.symmetric.web.model.BatchSummary;
import com.jumpmind.symmetric.web.model.ChannelStatus;
import com.jumpmind.symmetric.web.model.Column;
import com.jumpmind.symmetric.web.model.Engine;
import com.jumpmind.symmetric.web.model.EngineList;
import com.jumpmind.symmetric.web.model.Heartbeat;
import com.jumpmind.symmetric.web.model.Node;
import com.jumpmind.symmetric.web.model.NodeList;
import com.jumpmind.symmetric.web.model.NodeStatus;
import com.jumpmind.symmetric.web.model.PullDataResults;
import com.jumpmind.symmetric.web.model.QueryResults;
import com.jumpmind.symmetric.web.model.RegistrationInfo;
import com.jumpmind.symmetric.web.model.Row;
import com.jumpmind.symmetric.web.model.SendSchemaRequest;
import com.jumpmind.symmetric.web.model.SendSchemaResponse;
import com.jumpmind.symmetric.web.model.TableName;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.sql.ISqlTemplate;
import org.jumpmind.db.sql.SqlScript;
import org.jumpmind.exception.IoException;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.SymmetricException;
import org.jumpmind.symmetric.io.data.writer.StructureDataWriter;
import org.jumpmind.symmetric.job.IJob;
import org.jumpmind.symmetric.job.IJobManager;
import org.jumpmind.symmetric.model.AbstractBatch;
import org.jumpmind.symmetric.model.BatchAck;
import org.jumpmind.symmetric.model.IncomingBatch;
import org.jumpmind.symmetric.model.Lock;
import org.jumpmind.symmetric.model.NetworkedNode;
import org.jumpmind.symmetric.model.NodeChannel;
import org.jumpmind.symmetric.model.NodeGroupLink;
import org.jumpmind.symmetric.model.NodeHost;
import org.jumpmind.symmetric.model.NodeSecurity;
import org.jumpmind.symmetric.model.OutgoingBatchSummary;
import org.jumpmind.symmetric.model.OutgoingBatchWithPayload;
import org.jumpmind.symmetric.model.ProcessInfo;
import org.jumpmind.symmetric.model.ProcessInfoKey;
import org.jumpmind.symmetric.model.ProcessType;
import org.jumpmind.symmetric.model.TableReloadRequest;
import org.jumpmind.symmetric.model.Trigger;
import org.jumpmind.symmetric.model.TriggerRouter;
import org.jumpmind.symmetric.service.IAcknowledgeService;
import org.jumpmind.symmetric.service.IConfigurationService;
import org.jumpmind.symmetric.service.IDataExtractorService;
import org.jumpmind.symmetric.service.IDataLoaderService;
import org.jumpmind.symmetric.service.IDataService;
import org.jumpmind.symmetric.service.INodeService;
import org.jumpmind.symmetric.service.IOutgoingBatchService;
import org.jumpmind.symmetric.service.IRegistrationService;
import org.jumpmind.symmetric.service.ITriggerRouterService;
import org.jumpmind.symmetric.statistic.IStatisticManager;
import org.jumpmind.symmetric.util.SymmetricUtils;
import org.jumpmind.symmetric.web.SymmetricEngineHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api"})
public class RestService {
    private String username = "REST API";
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    @Autowired
    ServletContext context;

    @Operation(summary="Obtain a list of configured Engines")
    @RequestMapping(value={"/enginelist"}, method={RequestMethod.GET}, produces={"application/json", "application/xml"})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public final EngineList getEngineList() {
        EngineList list = new EngineList();
        Collection engines = this.getSymmetricEngineHolder().getEngines().values();
        for (ISymmetricEngine engine : engines) {
            if (!engine.getParameterService().is("rest.api.enable")) continue;
            list.addEngine(new Engine(engine.getEngineName()));
        }
        return list;
    }

    @Operation(summary="Obtain node information for the single engine")
    @RequestMapping(value={"engine/node"}, method={RequestMethod.GET}, produces={"application/json", "application/xml"})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public final Node getNode() {
        return this.nodeImpl(this.getSymmetricEngine());
    }

    @Operation(summary="Obtain node information for he specified engine")
    @RequestMapping(value={"engine/{engine}/node"}, method={RequestMethod.GET}, produces={"application/json", "application/xml"})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public final Node getNode(@PathVariable(value="engine") String engineName) {
        return this.nodeImpl(this.getSymmetricEngine(engineName));
    }

    @Operation(summary="Obtain list of children for the single engine")
    @RequestMapping(value={"engine/children"}, method={RequestMethod.GET}, produces={"application/json", "application/xml"})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public final NodeList getChildren() {
        return this.childrenImpl(this.getSymmetricEngine());
    }

    @Operation(summary="Obtain list of children for the specified engine")
    @RequestMapping(value={"engine/{engine}/children"}, method={RequestMethod.GET}, produces={"application/json", "application/xml"})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public final NodeList getChildrenByEngine(@PathVariable(value="engine") String engineName) {
        return this.childrenImpl(this.getSymmetricEngine(engineName));
    }

    @Operation(summary="Take a diagnostic snapshot for the single engine")
    @RequestMapping(value={"engine/snapshot"}, method={RequestMethod.GET}, produces={"application/json", "application/xml"})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public final void getSnapshot(HttpServletResponse resp) {
        this.getSnapshot(this.getSymmetricEngine().getEngineName(), resp);
    }

    @Operation(summary="Execute the specified SQL statement on the single engine")
    @RequestMapping(value={"engine/querynode"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public final QueryResults getQueryNode(@RequestParam(value="query") String sql, @RequestParam(value="isquery", defaultValue="true") boolean isQuery) {
        ISymmetricEngine engine = this.getSymmetricEngine(this.getSymmetricEngine().getEngineName());
        String nodeId = engine.getNodeId();
        ConsoleEventService consoleEventService = new ConsoleEventService();
        consoleEventService.setSymmetricEngine(engine);
        consoleEventService.addEvent(new ConsoleEvent(this.username, "Query Node", nodeId, nodeId, null, sql));
        return this.queryNodeImpl(this.getSymmetricEngine(), sql, isQuery);
    }

    @Operation(summary="Execute the specified SQL statement for the specified engine")
    @RequestMapping(value={"engine/{engine}/querynode"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public final QueryResults getQueryNode(@PathVariable(value="engine") String engineName, @RequestParam(value="query") String sql, @RequestParam(value="isquery", defaultValue="true") boolean isQuery) {
        ISymmetricEngine engine = this.getSymmetricEngine(engineName);
        String nodeId = engine.getNodeId();
        ConsoleEventService consoleEventService = new ConsoleEventService();
        consoleEventService.setSymmetricEngine(engine);
        consoleEventService.addEvent(new ConsoleEvent(this.username, "Query Node", this.getSymmetricEngine().getEngineName(), this.getSymmetricEngine().getEngineName(), nodeId, sql));
        return this.queryNodeImpl(this.getSymmetricEngine(engineName), sql, isQuery);
    }

    @Operation(summary="Execute the named job.  This can be used to control when jobs are run via and external application.  You would typically disable the job first so it no longer runs automatically.  Jobs you might want to control include: job.route, job.push, job.pull, job.offline.push, job.offline.pull")
    @RequestMapping(value={"engine/{engine}/invokejob"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public boolean invokeJob(@PathVariable(value="engine") String engineName, @RequestParam(value="jobname") String jobName) {
        IJobManager jobManager = this.getSymmetricEngine(engineName).getJobManager();
        IJob job = jobManager.getJob(jobName);
        if (job == null) {
            this.log.warn("Could not find a job with the name '{}' in the '{}' engine", (Object)jobName, (Object)engineName);
            return false;
        }
        if (!job.isRunning()) {
            this.log.info("Invoking '{}' via the REST API", (Object)jobName);
            ISymmetricEngine engine = this.getSymmetricEngine(this.getSymmetricEngine().getEngineName());
            String nodeId = engine.getNodeId();
            ConsoleEventService consoleEventService = new ConsoleEventService();
            consoleEventService.setSymmetricEngine(engine);
            consoleEventService.addEvent(new ConsoleEvent(this.username, "Run Job Now", nodeId, nodeId, null, jobName));
            return job.invoke(true);
        }
        this.log.info("Could not invoke the '{}' job via the REST API because it is already running", (Object)jobName);
        return false;
    }

    @Operation(summary="Take a diagnostic snapshot for the specified engine")
    @RequestMapping(value={"engine/{engine}/snapshot"}, method={RequestMethod.GET}, produces={"application/json", "application/xml"})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public final void getSnapshot(@PathVariable(value="engine") String engineName, HttpServletResponse resp) {
        ISymmetricEngine engine = this.getSymmetricEngine(engineName);
        File file = engine.snapshot(null);
        resp.setHeader("Content-Disposition", String.format("attachment; filename=%s", file.getName()));
        try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));){
            IOUtils.copy((InputStream)bis, (OutputStream)resp.getOutputStream());
            String nodeId = engine.getNodeId();
            ConsoleEventService consoleEventService = new ConsoleEventService();
            consoleEventService.setSymmetricEngine(engine);
            consoleEventService.addEvent(new ConsoleEvent(this.username, "Take Snapshot", this.getSymmetricEngine().getEngineName(), this.getSymmetricEngine().getEngineName(), nodeId, file.getName()));
        }
        catch (IOException e2) {
            throw new IoException((Exception)e2);
        }
    }

    @Operation(summary="Load a configuration file to the single engine")
    @RequestMapping(value={"engine/profile"}, method={RequestMethod.POST}, consumes={"multipart/form-data"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @ResponseBody
    public final void postProfile(@RequestParam MultipartFile file) {
        ISymmetricEngine engine = this.getSymmetricEngine(this.getSymmetricEngine().getEngineName());
        String nodeId = engine.getNodeId();
        ConsoleEventService consoleEventService = new ConsoleEventService();
        consoleEventService.setSymmetricEngine(engine);
        consoleEventService.addEvent(new ConsoleEvent(this.username, "Load Configuration", nodeId, nodeId, null, null));
        this.loadProfileImpl(this.getSymmetricEngine(), file);
    }

    @Operation(summary="Load a configuration file to the specified engine")
    @RequestMapping(value={"engine/{engine}/profile"}, method={RequestMethod.POST}, consumes={"multipart/form-data"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @ResponseBody
    public final void postProfileByEngine(@PathVariable(value="engine") String engineName, @RequestParam(value="file") MultipartFile file) {
        ISymmetricEngine engine = this.getSymmetricEngine(engineName);
        String nodeId = engine.getNodeId();
        ConsoleEventService consoleEventService = new ConsoleEventService();
        consoleEventService.setSymmetricEngine(engine);
        consoleEventService.addEvent(new ConsoleEvent(this.username, "Load Configuration", this.getSymmetricEngine().getEngineName(), this.getSymmetricEngine().getEngineName(), nodeId, null));
        this.loadProfileImpl(this.getSymmetricEngine(engineName), file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Operation(summary="Import configuration for the Symmetric installation")
    @PostMapping(value={"/engine/{engine}/importconfig"}, consumes={"multipart/form-data"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @ResponseBody
    public final void postConfiguration(@PathVariable(value="engine") String engineName, @RequestParam(value="file") MultipartFile file) {
        block23: {
            ISymmetricEngine engine;
            boolean missingCurrentGroup;
            boolean inError;
            block21: {
                inError = false;
                boolean inWrongFormat = false;
                missingCurrentGroup = false;
                engine = this.getSymmetricEngine(engineName);
                String nodeId = engine.getNodeId();
                ConsoleEventService consoleEventService = new ConsoleEventService();
                consoleEventService.setSymmetricEngine(engine);
                consoleEventService.addEvent(new ConsoleEvent(this.username, "Import Configuration", nodeId, nodeId, null, null));
                boolean isCsv = file.getOriginalFilename().toLowerCase().endsWith("csv");
                boolean isSql = file.getOriginalFilename().toLowerCase().endsWith("sql");
                IDataLoaderService dataLoaderService = engine.getDataLoaderService();
                try {
                    String content = new String(file.getBytes());
                    if (!isCsv && !isSql) {
                        inWrongFormat = true;
                    } else if (!SymmetricUtils.importContainsCurrentGroup((ISymmetricEngine)engine, (String)content, (boolean)isCsv)) {
                        missingCurrentGroup = true;
                    } else if (isCsv) {
                        inError = this.importCsvFile(dataLoaderService, content);
                    } else {
                        this.importSqlFile(engine, content);
                    }
                    if (inError || inWrongFormat || missingCurrentGroup) break block21;
                }
                catch (Exception e2) {
                    block22: {
                        try {
                            this.handleException(e2);
                            inError = true;
                            if (inError || inWrongFormat || missingCurrentGroup) break block22;
                        }
                        catch (Throwable throwable) {
                            if (!(inError || inWrongFormat || missingCurrentGroup)) {
                                engine.getTransformService().clearCache();
                                if (!engine.getParameterService().is("auto.sync.triggers.after.config.change") && !engine.getTriggerRouterService().syncTriggers()) {
                                    Lock lock = (Lock)engine.getClusterService().findLocks().get("SyncTriggers");
                                }
                                N licenseService = new N();
                                licenseService.setSymmetricEngine(engine);
                                licenseService.k();
                                licenseService.l();
                            } else {
                                if (missingCurrentGroup) {
                                    throw new NotAllowedException("Imported configuration doesn't contain current node group (%s)", engine.getParameterService().getNodeGroupId());
                                }
                                if (inError) {
                                    throw new InternalServerErrorException();
                                }
                            }
                            throw throwable;
                        }
                        engine.getTransformService().clearCache();
                        if (!engine.getParameterService().is("auto.sync.triggers.after.config.change") && !engine.getTriggerRouterService().syncTriggers()) {
                            Lock lock = (Lock)engine.getClusterService().findLocks().get("SyncTriggers");
                        }
                        N licenseService = new N();
                        licenseService.setSymmetricEngine(engine);
                        licenseService.k();
                        licenseService.l();
                    }
                    if (missingCurrentGroup) {
                        throw new NotAllowedException("Imported configuration doesn't contain current node group (%s)", engine.getParameterService().getNodeGroupId());
                    }
                    if (inError) {
                        throw new InternalServerErrorException();
                    }
                }
                engine.getTransformService().clearCache();
                if (!engine.getParameterService().is("auto.sync.triggers.after.config.change") && !engine.getTriggerRouterService().syncTriggers()) {
                    Lock lock = (Lock)engine.getClusterService().findLocks().get("SyncTriggers");
                }
                N licenseService = new N();
                licenseService.setSymmetricEngine(engine);
                licenseService.k();
                licenseService.l();
                break block23;
            }
            if (missingCurrentGroup) {
                throw new NotAllowedException("Imported configuration doesn't contain current node group (%s)", engine.getParameterService().getNodeGroupId());
            }
            if (inError) {
                throw new InternalServerErrorException();
            }
        }
    }

    public boolean importCsvFile(IDataLoaderService dataLoaderService, String content) {
        List batches = dataLoaderService.loadDataBatch(content);
        for (IncomingBatch batch : batches) {
            if (batch.getStatus() != AbstractBatch.Status.ER) continue;
            return true;
        }
        return false;
    }

    public void importSqlFile(ISymmetricEngine engine, String content) {
        SqlScript script = new SqlScript(content, engine.getSqlTemplate(), true, null);
        script.execute();
    }

    @Operation(summary="Start the single engine")
    @RequestMapping(value={"engine/start"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @ResponseBody
    public final void postStart() {
        ISymmetricEngine engine = this.getSymmetricEngine(this.getSymmetricEngine().getEngineName());
        String nodeId = engine.getNodeId();
        ConsoleEventService consoleEventService = new ConsoleEventService();
        consoleEventService.setSymmetricEngine(engine);
        consoleEventService.addEvent(new ConsoleEvent(this.username, "Start Node", nodeId, nodeId, null, null));
        this.startImpl(this.getSymmetricEngine());
    }

    @Operation(summary="Start the specified engine")
    @RequestMapping(value={"engine/{engine}/start"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @ResponseBody
    public final void postStartByEngine(@PathVariable(value="engine") String engineName) {
        ISymmetricEngine engine = this.getSymmetricEngine(engineName);
        String nodeId = engine.getNodeId();
        ConsoleEventService consoleEventService = new ConsoleEventService();
        consoleEventService.setSymmetricEngine(engine);
        consoleEventService.addEvent(new ConsoleEvent(this.username, "Start Node", this.getSymmetricEngine().getEngineName(), this.getSymmetricEngine().getEngineName(), nodeId, null));
        this.startImpl(this.getSymmetricEngine(engineName));
    }

    @Operation(summary="Stop the single engine")
    @RequestMapping(value={"engine/stop"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @ResponseBody
    public final void postStop() {
        ISymmetricEngine engine = this.getSymmetricEngine(this.getSymmetricEngine().getEngineName());
        String nodeId = engine.getNodeId();
        ConsoleEventService consoleEventService = new ConsoleEventService();
        consoleEventService.setSymmetricEngine(engine);
        consoleEventService.addEvent(new ConsoleEvent(this.username, "Stop Node", nodeId, nodeId, null, null));
        this.stopImpl(this.getSymmetricEngine());
    }

    @Operation(summary="Stop the specified engine")
    @RequestMapping(value={"engine/{engine}/stop"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @ResponseBody
    public final void postStopByEngine(@PathVariable(value="engine") String engineName) {
        ISymmetricEngine engine = this.getSymmetricEngine(engineName);
        String nodeId = engine.getNodeId();
        ConsoleEventService consoleEventService = new ConsoleEventService();
        consoleEventService.setSymmetricEngine(engine);
        consoleEventService.addEvent(new ConsoleEvent(this.username, "Stop Node", this.getSymmetricEngine().getEngineName(), this.getSymmetricEngine().getEngineName(), nodeId, null));
        this.stopImpl(this.getSymmetricEngine(engineName));
    }

    @Operation(summary="Reconfigure tables for capture on the single engine")
    @RequestMapping(value={"engine/synctriggers"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @ResponseBody
    public final void postSyncTriggers(@RequestParam(required=false, value="force") boolean force) {
        ISymmetricEngine engine = this.getSymmetricEngine(this.getSymmetricEngine().getEngineName());
        String nodeId = engine.getNodeId();
        ConsoleEventService consoleEventService = new ConsoleEventService();
        consoleEventService.setSymmetricEngine(engine);
        consoleEventService.addEvent(new ConsoleEvent(this.username, "Reconfigure all tables for capture", nodeId, nodeId, null, null));
        this.syncTriggersImpl(this.getSymmetricEngine(), force);
    }

    @Operation(summary="Reconfigure tables for capture on the specified engine")
    @RequestMapping(value={"engine/{engine}/synctriggers"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @ResponseBody
    public final void postSyncTriggersByEngine(@PathVariable(value="engine") String engineName, @RequestParam(required=false, value="force") boolean force) {
        ISymmetricEngine engine = this.getSymmetricEngine(engineName);
        String nodeId = engine.getNodeId();
        ConsoleEventService consoleEventService = new ConsoleEventService();
        consoleEventService.setSymmetricEngine(engine);
        consoleEventService.addEvent(new ConsoleEvent(this.username, "Reconfigure all tables for capture", this.getSymmetricEngine().getEngineName(), this.getSymmetricEngine().getEngineName(), nodeId, null));
        this.syncTriggersImpl(this.getSymmetricEngine(engineName), force);
    }

    @Operation(summary="Reconfigure a table for capture on the single engine")
    @RequestMapping(value={"engine/synctriggers/{table}"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @ResponseBody
    public final void postSyncTriggersByTable(@PathVariable(value="table") String tableName, @RequestParam(required=false, value="catalog") String catalogName, @RequestParam(required=false, value="schema") String schemaName, @RequestParam(required=false, value="force") boolean force) {
        ISymmetricEngine engine = this.getSymmetricEngine(this.getSymmetricEngine().getEngineName());
        String nodeId = engine.getNodeId();
        ConsoleEventService consoleEventService = new ConsoleEventService();
        consoleEventService.setSymmetricEngine(engine);
        consoleEventService.addEvent(new ConsoleEvent(this.username, "Reconfigure table for capture", nodeId, nodeId, null, tableName));
        this.syncTriggersByTableImpl(this.getSymmetricEngine(), catalogName, schemaName, tableName, force);
    }

    @Operation(summary="Reconfigure a table for capture on the specific engine")
    @RequestMapping(value={"engine/{engine}/synctriggers/{table}"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @ResponseBody
    public final void postSyncTriggersByTable(@PathVariable(value="engine") String engineName, @PathVariable(value="table") String tableName, @RequestParam(required=false, value="catalog") String catalogName, @RequestParam(required=false, value="schema") String schemaName, @RequestParam(required=false, value="force") boolean force) {
        ISymmetricEngine engine = this.getSymmetricEngine(engineName);
        String nodeId = engine.getNodeId();
        ConsoleEventService consoleEventService = new ConsoleEventService();
        consoleEventService.setSymmetricEngine(engine);
        consoleEventService.addEvent(new ConsoleEvent(this.username, "Reconfigure table for capture", this.getSymmetricEngine().getEngineName(), this.getSymmetricEngine().getEngineName(), nodeId, tableName));
        this.syncTriggersByTableImpl(this.getSymmetricEngine(engineName), catalogName, schemaName, tableName, force);
    }

    @Operation(summary="Send schema updates for all tables or a list of tables to a list of nodes or to all nodes in a group.")
    @RequestMapping(value={"engine/{engine}/sendschema"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public final SendSchemaResponse postSendSchema(@PathVariable(value="engine") String engineName, @RequestBody SendSchemaRequest request) {
        ISymmetricEngine engine = this.getSymmetricEngine(engineName);
        String nodeId = engine.getNodeId();
        ConsoleEventService consoleEventService = new ConsoleEventService();
        consoleEventService.setSymmetricEngine(engine);
        consoleEventService.addEvent(new ConsoleEvent(this.username, "Send table schema", this.getSymmetricEngine().getEngineName(), this.getSymmetricEngine().getEngineName(), nodeId, request.getTablesToSend().toString()));
        return this.sendSchemaImpl(this.getSymmetricEngine(engineName), request);
    }

    @Operation(summary="Send schema updates for all tables or a list of tables to a list of nodes or to all nodes in a group.")
    @RequestMapping(value={"engine/sendschema"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public final SendSchemaResponse postSendSchema(@RequestBody SendSchemaRequest request) {
        ISymmetricEngine engine = this.getSymmetricEngine(this.getSymmetricEngine().getEngineName());
        String nodeId = engine.getNodeId();
        ConsoleEventService consoleEventService = new ConsoleEventService();
        consoleEventService.setSymmetricEngine(engine);
        consoleEventService.addEvent(new ConsoleEvent(this.username, "Send table schema", nodeId, nodeId, null, request.getTablesToSend().toString()));
        return this.sendSchemaImpl(this.getSymmetricEngine(), request);
    }

    @Operation(summary="Inactivate table capture on the single engine")
    @RequestMapping(value={"engine/droptriggers"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @ResponseBody
    public final void postDropTriggers() {
        ISymmetricEngine engine = this.getSymmetricEngine(this.getSymmetricEngine().getEngineName());
        String nodeId = engine.getNodeId();
        ConsoleEventService consoleEventService = new ConsoleEventService();
        consoleEventService.setSymmetricEngine(engine);
        consoleEventService.addEvent(new ConsoleEvent(this.username, "Inactivate capture for table", nodeId, nodeId, null, null));
        this.dropTriggersImpl(this.getSymmetricEngine());
    }

    @Operation(summary="Inactivate table capture on the specified engine")
    @RequestMapping(value={"engine/{engine}/droptriggers"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @ResponseBody
    public final void postDropTriggersByEngine(@PathVariable(value="engine") String engineName) {
        ISymmetricEngine engine = this.getSymmetricEngine(engineName);
        String nodeId = engine.getNodeId();
        ConsoleEventService consoleEventService = new ConsoleEventService();
        consoleEventService.setSymmetricEngine(engine);
        consoleEventService.addEvent(new ConsoleEvent(this.username, "Inactivate capture for table", this.getSymmetricEngine().getEngineName(), this.getSymmetricEngine().getEngineName(), nodeId, null));
        this.dropTriggersImpl(this.getSymmetricEngine(engineName));
    }

    @Operation(summary="Inactivate capture for the specified table on the single engine")
    @RequestMapping(value={"engine/table/{table}/droptriggers"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @ResponseBody
    public final void postDropTriggersByTable(@PathVariable(value="table") String tableName) {
        ISymmetricEngine engine = this.getSymmetricEngine(this.getSymmetricEngine().getEngineName());
        String nodeId = engine.getNodeId();
        ConsoleEventService consoleEventService = new ConsoleEventService();
        consoleEventService.setSymmetricEngine(engine);
        consoleEventService.addEvent(new ConsoleEvent(this.username, "Inactivate capture for table", nodeId, nodeId, null, tableName));
        this.dropTriggersImpl(this.getSymmetricEngine(), tableName);
    }

    @Operation(summary="Inactivate capture for the specified table on the specified engine")
    @RequestMapping(value={"engine/{engine}/table/{table}/droptriggers"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @ResponseBody
    public final void postDropTriggersByEngineByTable(@PathVariable(value="engine") String engineName, @PathVariable(value="table") String tableName) {
        ISymmetricEngine engine = this.getSymmetricEngine(engineName);
        String nodeId = engine.getNodeId();
        ConsoleEventService consoleEventService = new ConsoleEventService();
        consoleEventService.setSymmetricEngine(engine);
        consoleEventService.addEvent(new ConsoleEvent(this.username, "Inactivate capture for table", this.getSymmetricEngine().getEngineName(), this.getSymmetricEngine().getEngineName(), nodeId, tableName));
        this.dropTriggersImpl(this.getSymmetricEngine(engineName), tableName);
    }

    @Operation(summary="Load a configuration file to the single engine")
    @RequestMapping(value={"engine/install"}, method={RequestMethod.POST}, consumes={"multipart/form-data"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @ResponseBody
    public final void postInstall(@RequestParam MultipartFile file) {
        try {
            Properties properties = new Properties();
            properties.load(file.getInputStream());
            this.getSymmetricEngineHolder().install(properties);
        }
        catch (RuntimeException ex2) {
            throw ex2;
        }
        catch (Exception ex3) {
            throw new RuntimeException(ex3);
        }
    }

    @Operation(summary="Uninstall SymmetricDS on the single engine")
    @RequestMapping(value={"engine/uninstall"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @ResponseBody
    public final void postUninstall() {
        this.uninstallImpl(this.getSymmetricEngine());
    }

    @Operation(summary="Uninstall SymmetricDS on the specified engine")
    @RequestMapping(value={"engine/{engine}/uninstall"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @ResponseBody
    public final void postUninstallByEngine(@PathVariable(value="engine") String engineName) {
        this.uninstallImpl(this.getSymmetricEngine(engineName));
    }

    @Operation(summary="Reinitiailize SymmetricDS on the single engine")
    @RequestMapping(value={"engine/reinitialize"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @ResponseBody
    public final void postReinitialize() {
        this.reinitializeImpl(this.getSymmetricEngine());
    }

    @Operation(summary="Reinitiailize SymmetricDS on the specified engine")
    @RequestMapping(value={"engine/{engine}/reinitialize"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @ResponseBody
    public final void postReinitializeByEngine(@PathVariable(value="engine") String engineName) {
        this.reinitializeImpl(this.getSymmetricEngine(engineName));
    }

    @Operation(summary="Refresh caches on the single engine")
    @RequestMapping(value={"engine/refreshcache"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @ResponseBody
    public final void postClearCaches() {
        this.clearCacheImpl(this.getSymmetricEngine());
    }

    @Operation(summary="Refresh caches on the specified engine")
    @RequestMapping(value={"engine/{engine}/refreshcache"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @ResponseBody
    public final void postClearCachesByEngine(@PathVariable(value="engine") String engineName) {
        this.clearCacheImpl(this.getSymmetricEngine(engineName));
    }

    @Operation(summary="Obtain the status of the single engine")
    @RequestMapping(value={"/engine/status"}, method={RequestMethod.GET}, produces={"application/json", "application/xml"})
    @ResponseBody
    public final NodeStatus getStatus() {
        return this.nodeStatusImpl(this.getSymmetricEngine());
    }

    @Operation(summary="Obtain the status of the specified engine")
    @RequestMapping(value={"/engine/{engine}/status"}, method={RequestMethod.GET}, produces={"application/json", "application/xml"})
    @ResponseBody
    public final NodeStatus getStatusByEngine(@PathVariable(value="engine") String engineName) {
        return this.nodeStatusImpl(this.getSymmetricEngine(engineName));
    }

    @Operation(summary="Obtain the channel status of the single engine")
    @RequestMapping(value={"/engine/channelstatus"}, method={RequestMethod.GET}, produces={"application/json", "application/xml"})
    @ResponseBody
    public final Set<ChannelStatus> getChannelStatus() {
        return this.channelStatusImpl(this.getSymmetricEngine());
    }

    @Operation(summary="Obtain the channel status of the specified engine")
    @RequestMapping(value={"/engine/{engine}/channelstatus"}, method={RequestMethod.GET}, produces={"application/json", "application/xml"})
    @ResponseBody
    public final Set<ChannelStatus> getChannelStatusByEngine(@PathVariable(value="engine") String engineName) {
        return this.channelStatusImpl(this.getSymmetricEngine(engineName));
    }

    @Operation(summary="Remove specified node (unregister and clean up) for the single engine")
    @RequestMapping(value={"/engine/removenode"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @ResponseBody
    public final void postRemoveNode(@RequestParam(value="nodeId") String nodeId) {
        this.postRemoveNodeByEngine(nodeId, this.getSymmetricEngine().getEngineName());
    }

    @Operation(summary="Remove specified node (unregister and clean up) for the specified engine")
    @RequestMapping(value={"/engine/{engine}/removenode"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @ResponseBody
    public final void postRemoveNodeByEngine(@RequestParam(value="nodeId") String nodeId, @PathVariable(value="engine") String engineName) {
        this.getSymmetricEngine(engineName).removeAndCleanupNode(nodeId);
    }

    @Operation(summary="Register the specified node for the single engine")
    @RequestMapping(value={"/engine/registernode"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public final RegistrationInfo postRegisterNode(@RequestParam(value="externalId") String externalId, @RequestParam(value="nodeGroupId") String nodeGroupId, @RequestParam(value="databaseType") String databaseType, @RequestParam(value="databaseVersion") String databaseVersion, @RequestParam(value="hostName") String hostName) {
        return this.postRegisterNode(this.getSymmetricEngine().getEngineName(), externalId, nodeGroupId, databaseType, databaseVersion, hostName);
    }

    @Operation(summary="Register the specified node for the specified engine")
    @RequestMapping(value={"/engine/{engine}/registernode"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public final RegistrationInfo postRegisterNode(@PathVariable(value="engine") String engineName, @RequestParam(value="externalId") String externalId, @RequestParam(value="nodeGroupId") String nodeGroupId, @RequestParam(value="databaseType") String databaseType, @RequestParam(value="databaseVersion") String databaseVersion, @RequestParam(value="hostName") String hostName) {
        ISymmetricEngine engine = this.getSymmetricEngine(engineName);
        IRegistrationService registrationService = engine.getRegistrationService();
        INodeService nodeService = engine.getNodeService();
        RegistrationInfo regInfo = new RegistrationInfo();
        try {
            org.jumpmind.symmetric.model.Node processedNode = registrationService.registerPullOnlyNode(externalId, nodeGroupId, databaseType, databaseVersion, engine.getDatabasePlatform().getName());
            regInfo.setRegistered(processedNode.isSyncEnabled());
            if (regInfo.isRegistered()) {
                regInfo.setNodeId(processedNode.getNodeId());
                NodeSecurity nodeSecurity = nodeService.findNodeSecurity(processedNode.getNodeId());
                regInfo.setNodePassword(nodeSecurity.getNodePassword());
                org.jumpmind.symmetric.model.Node modelNode = nodeService.findIdentity();
                regInfo.setSyncUrl(modelNode.getSyncUrl());
                Heartbeat heartbeat = new Heartbeat();
                heartbeat.setNodeId(regInfo.getNodeId());
                heartbeat.setHostName(hostName);
                Date now = new Date();
                heartbeat.setCreateTime(now);
                heartbeat.setLastRestartTime(now);
                heartbeat.setHeartbeatTime(now);
                this.heartbeatImpl(engine, heartbeat);
            }
        }
        catch (IOException e2) {
            throw new IoException((Exception)e2);
        }
        return regInfo;
    }

    @Operation(summary="Open registration for the specified node at the single engine")
    @RequestMapping(value={"/engine/openregistration"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public final String postOpenRegistration(@RequestParam(value="nodeGroupId") String nodeGroupId, @RequestParam(value="externalId") String externalId, @RequestParam(value="hostName", required=false) String hostName, @RequestParam(value="ipAddress", required=false) String ipAddress) {
        return this.postOpenRegistration(this.getSymmetricEngine().getEngineName(), nodeGroupId, externalId, hostName, ipAddress);
    }

    @Operation(summary="Open registration for the specified node at the specified engine")
    @RequestMapping(value={"/engine/{engine}/openregistration"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public final String postOpenRegistration(@PathVariable(value="engine") String engineName, @RequestParam(value="nodeGroupId") String nodeGroupId, @RequestParam(value="externalId") String externalId, @RequestParam(value="hostName", required=false) String hostName, @RequestParam(value="ipAddress", required=false) String ipAddress) {
        ISymmetricEngine engine = this.getSymmetricEngine(engineName);
        return engine.getRegistrationService().openRegistration(nodeGroupId, externalId, hostName, ipAddress);
    }

    @Operation(summary="Open registration window of time for the specified node at the single engine")
    @RequestMapping(value={"/engine/openregistrationwindow"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public final String postOpenRegistrationWindow(@RequestParam(value="nodeGroupId") String nodeGroupId, @RequestParam(value="externalId") String externalId, @RequestParam(value="syncUrl", required=false) String syncUrl, @RequestParam(value="notBefore") Date notBefore, @RequestParam(value="notAfter") Date notAfter) {
        return this.postOpenRegistrationWindow(this.getSymmetricEngine().getEngineName(), nodeGroupId, externalId, syncUrl, notBefore, notAfter);
    }

    @Operation(summary="Open registration window of time for the specified node at the specified engine")
    @RequestMapping(value={"/engine/{engine}/openregistrationwindow"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public final String postOpenRegistrationWindow(@PathVariable(value="engine") String engineName, @RequestParam(value="nodeGroupId") String nodeGroupId, @RequestParam(value="externalId") String externalId, @RequestParam(value="syncUrl", required=false) String syncUrl, @RequestParam(value="notBefore") Date notBefore, @RequestParam(value="notAfter") Date notAfter) {
        ISymmetricEngine engine = this.getSymmetricEngine(engineName);
        return engine.getRegistrationService().openRegistration(nodeGroupId, externalId, syncUrl, notBefore, notAfter);
    }

    @Operation(summary="Pull pending batches for the specified node for the single engine")
    @RequestMapping(value={"/engine/pulldata"}, method={RequestMethod.GET}, produces={"application/json", "application/xml"})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public final PullDataResults getPullData(@RequestParam(value="nodeId") String nodeId, @Parameter(description="This the password for the nodeId being passed in.  The password is stored in the node_security table") @RequestParam(value="securityToken") String securityToken, @RequestParam(value="useJdbcTimestampFormat", required=false, defaultValue="true") boolean useJdbcTimestampFormat, @RequestParam(value="useUpsertStatements", required=false, defaultValue="false") boolean useUpsertStatements, @RequestParam(value="useDelimitedIdentifiers", required=false, defaultValue="true") boolean useDelimitedIdentifiers, @RequestParam(value="hostName", required=false) String hostName) {
        return this.getPullData(this.getSymmetricEngine().getEngineName(), nodeId, securityToken, useJdbcTimestampFormat, useUpsertStatements, useDelimitedIdentifiers, hostName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Operation(summary="Pull pending batches for the specified node for the specified engine")
    @RequestMapping(value={"/engine/{engine}/pulldata"}, method={RequestMethod.GET}, produces={"application/json", "application/xml"})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public final PullDataResults getPullData(@PathVariable(value="engine") String engineName, @RequestParam(value="nodeId") String nodeId, @Parameter(description="This the password for the nodeId being passed in.  The password is stored in the node_security table.") @RequestParam(value="securityToken") String securityToken, @RequestParam(value="useJdbcTimestampFormat", required=false, defaultValue="true") boolean useJdbcTimestampFormat, @RequestParam(value="useUpsertStatements", required=false, defaultValue="false") boolean useUpsertStatements, @RequestParam(value="useDelimitedIdentifiers", required=false, defaultValue="true") boolean useDelimitedIdentifiers, @RequestParam(value="hostName", required=false) String hostName) {
        ISymmetricEngine engine = this.getSymmetricEngine(engineName);
        IDataExtractorService dataExtractorService = engine.getDataExtractorService();
        IStatisticManager statisticManager = engine.getStatisticManager();
        INodeService nodeService = engine.getNodeService();
        org.jumpmind.symmetric.model.Node targetNode = nodeService.findNode(nodeId, true);
        if (this.securityVerified(nodeId, engine, securityToken)) {
            ProcessInfo processInfo = statisticManager.newProcessInfo(new ProcessInfoKey(nodeService.findIdentityNodeId(), nodeId, ProcessType.REST_PULL_HANLDER));
            try {
                PullDataResults results = new PullDataResults();
                List extractedBatches = dataExtractorService.extractToPayload(processInfo, targetNode, StructureDataWriter.PayloadType.SQL, useJdbcTimestampFormat, useUpsertStatements, useDelimitedIdentifiers);
                ArrayList<Batch> batches = new ArrayList<Batch>();
                for (OutgoingBatchWithPayload outgoingBatchWithPayload : extractedBatches) {
                    if (outgoingBatchWithPayload.getStatus() != AbstractBatch.Status.LD && outgoingBatchWithPayload.getStatus() != AbstractBatch.Status.IG) continue;
                    Batch batch = new Batch();
                    batch.setBatchId(outgoingBatchWithPayload.getBatchId());
                    batch.setChannelId(outgoingBatchWithPayload.getChannelId());
                    batch.setSqlStatements(outgoingBatchWithPayload.getPayload());
                    batches.add(batch);
                }
                results.setBatches(batches);
                results.setNbrBatches(batches.size());
                processInfo.setStatus(ProcessInfo.ProcessStatus.OK);
                if (engine.getParameterService().is("rest.api.heartbeat.on.pull") && hostName != null) {
                    Heartbeat heartbeat = new Heartbeat();
                    heartbeat.setNodeId(nodeId);
                    heartbeat.setHeartbeatTime(new Date());
                    heartbeat.setHostName(hostName);
                    this.heartbeatImpl(engine, heartbeat);
                }
                PullDataResults pullDataResults = results;
                return pullDataResults;
            }
            finally {
                if (processInfo.getStatus() != ProcessInfo.ProcessStatus.OK) {
                    processInfo.setStatus(ProcessInfo.ProcessStatus.ERROR);
                }
            }
        }
        throw new NotAllowedException();
    }

    @Operation(summary="Send a heartbeat for the single engine")
    @RequestMapping(value={"/engine/heartbeat"}, method={RequestMethod.PUT})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @ResponseBody
    public final void putHeartbeat(@Parameter(description="This the password for the nodeId being passed in.  The password is stored in the node_security table.") @RequestParam(value="securityToken") String securityToken, @RequestBody Heartbeat heartbeat) {
        if (!this.securityVerified(heartbeat.getNodeId(), this.getSymmetricEngine(), securityToken)) {
            throw new NotAllowedException();
        }
        this.putHeartbeat(this.getSymmetricEngine().getEngineName(), securityToken, heartbeat);
    }

    @Operation(summary="Send a heartbeat for the specified engine")
    @RequestMapping(value={"/engine/{engine}/heartbeat"}, method={RequestMethod.PUT})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @ResponseBody
    public final void putHeartbeat(@PathVariable(value="engine") String engineName, @Parameter(description="This the password for the nodeId being passed in.  The password is stored in the node_security table.") @RequestParam(value="securityToken") String securityToken, @RequestBody Heartbeat heartbeat) {
        ISymmetricEngine engine = this.getSymmetricEngine(engineName);
        if (!this.securityVerified(heartbeat.getNodeId(), engine, securityToken)) {
            throw new NotAllowedException();
        }
        this.heartbeatImpl(engine, heartbeat);
    }

    private void heartbeatImpl(ISymmetricEngine engine, Heartbeat heartbeat) {
        INodeService nodeService = engine.getNodeService();
        NodeHost nodeHost = new NodeHost();
        if (heartbeat.getAvailableProcessors() != null) {
            nodeHost.setAvailableProcessors(heartbeat.getAvailableProcessors().intValue());
        }
        if (heartbeat.getCreateTime() != null) {
            nodeHost.setCreateTime(heartbeat.getCreateTime());
        }
        if (heartbeat.getFreeMemoryBytes() != null) {
            nodeHost.setFreeMemoryBytes(heartbeat.getFreeMemoryBytes().longValue());
        }
        if (heartbeat.getHeartbeatTime() != null) {
            nodeHost.setHeartbeatTime(heartbeat.getHeartbeatTime());
        }
        if (heartbeat.getHostName() != null) {
            nodeHost.setHostName(heartbeat.getHostName());
        }
        if (heartbeat.getIpAddress() != null) {
            nodeHost.setIpAddress(heartbeat.getIpAddress());
        }
        if (heartbeat.getJavaVendor() != null) {
            nodeHost.setJavaVendor(heartbeat.getJavaVendor());
        }
        if (heartbeat.getJdbcVersion() != null) {
            nodeHost.setJdbcVersion(heartbeat.getJdbcVersion());
        }
        if (heartbeat.getJavaVersion() != null) {
            nodeHost.setJavaVersion(heartbeat.getJavaVersion());
        }
        if (heartbeat.getLastRestartTime() != null) {
            nodeHost.setLastRestartTime(heartbeat.getLastRestartTime());
        }
        if (heartbeat.getMaxMemoryBytes() != null) {
            nodeHost.setMaxMemoryBytes(heartbeat.getMaxMemoryBytes().longValue());
        }
        if (heartbeat.getNodeId() != null) {
            nodeHost.setNodeId(heartbeat.getNodeId());
        }
        if (heartbeat.getOsArchitecture() != null) {
            nodeHost.setOsArch(heartbeat.getOsArchitecture());
        }
        if (heartbeat.getOsName() != null) {
            nodeHost.setOsName(heartbeat.getOsName());
        }
        if (heartbeat.getOsUser() != null) {
            nodeHost.setOsUser(heartbeat.getOsUser());
        }
        if (heartbeat.getOsVersion() != null) {
            nodeHost.setOsVersion(heartbeat.getOsVersion());
        }
        if (heartbeat.getSymmetricVersion() != null) {
            nodeHost.setSymmetricVersion(heartbeat.getSymmetricVersion());
        }
        if (heartbeat.getTimezoneOffset() != null) {
            nodeHost.setTimezoneOffset(heartbeat.getTimezoneOffset());
        }
        if (heartbeat.getTotalMemoryBytes() != null) {
            nodeHost.setTotalMemoryBytes(heartbeat.getTotalMemoryBytes().longValue());
        }
        nodeService.updateNodeHost(nodeHost);
    }

    @Operation(summary="Acknowledge a set of batches for the single engine")
    @RequestMapping(value={"/engine/acknowledgebatch"}, method={RequestMethod.PUT})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public final BatchAckResults putAcknowledgeBatch(@Parameter(description="This the password for the nodeId being passed in.  The password is stored in the node_security table.") @RequestParam(value="securityToken") String securityToken, @RequestBody BatchResults batchResults) {
        BatchAckResults results = this.putAcknowledgeBatch(this.getSymmetricEngine().getEngineName(), securityToken, batchResults);
        return results;
    }

    @Operation(summary="Acknowledge a set of batches for the specified engine")
    @RequestMapping(value={"/engine/{engine}/acknowledgebatch"}, method={RequestMethod.PUT})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public final BatchAckResults putAcknowledgeBatch(@PathVariable(value="engine") String engineName, @Parameter(description="This the password for the nodeId being passed in.  The password is stored in the node_security table.") @RequestParam(value="securityToken") String securityToken, @RequestBody BatchResults batchResults) {
        BatchAckResults finalResult = new BatchAckResults();
        ISymmetricEngine engine = this.getSymmetricEngine(engineName);
        List results = null;
        if (batchResults.getBatchResults().size() > 0) {
            if (this.securityVerified(batchResults.getNodeId(), engine, securityToken)) {
                IAcknowledgeService ackService = engine.getAcknowledgeService();
                List<BatchAck> batchAcks = this.convertBatchResultsToAck(batchResults);
                results = ackService.ack(batchAcks);
            } else {
                throw new NotAllowedException();
            }
        }
        finalResult.setBatchAckResults(results);
        return finalResult;
    }

    private List<BatchAck> convertBatchResultsToAck(BatchResults batchResults) {
        BatchAck batchAck = null;
        ArrayList<BatchAck> batchAcks = new ArrayList<BatchAck>();
        long transferTimeInMillis = batchResults.getTransferTimeInMillis();
        if (transferTimeInMillis > 0L) {
            transferTimeInMillis /= (long)batchResults.getBatchResults().size();
        }
        for (BatchResult batchResult : batchResults.getBatchResults()) {
            batchAck = new BatchAck(batchResult.getBatchId().longValue());
            batchAck.setNodeId(batchResults.getNodeId());
            batchAck.setNetworkMillis(transferTimeInMillis);
            batchAck.setLoadMillis(batchResult.getLoadTimeInMillis());
            if (batchResult.getStatus().equalsIgnoreCase("OK")) {
                batchAck.setOk(true);
            } else {
                batchAck.setOk(false);
                batchAck.setSqlCode(batchResult.getSqlCode());
                batchAck.setSqlState(batchResult.getSqlState().substring(0, Math.min(batchResult.getSqlState().length(), 10)));
                batchAck.setSqlMessage(batchResult.getStatusDescription());
            }
            batchAcks.add(batchAck);
        }
        return batchAcks;
    }

    @Operation(summary="Request an initial load for the specified node for the single engine")
    @RequestMapping(value={"/engine/requestinitialload"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @ResponseBody
    public final void postRequestInitialLoad(@RequestParam(value="nodeId") String nodeId) {
        this.postRequestInitialLoad(this.getSymmetricEngine().getEngineName(), nodeId);
    }

    @Operation(summary="Request an initial load for the specified node for the specified engine")
    @RequestMapping(value={"/engine/{engine}/requestinitialload"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @ResponseBody
    public final void postRequestInitialLoad(@PathVariable(value="engine") String engineName, @RequestParam(value="nodeId") String nodeId) {
        ISymmetricEngine engine = this.getSymmetricEngine(engineName);
        INodeService nodeService = engine.getNodeService();
        nodeService.setInitialLoadEnabled(nodeId, true, false, -1L, "restapi");
    }

    @Operation(summary="Request a table reload for the specified source and target node for the single engine")
    @RequestMapping(value={"/engine/requesttablereload"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @ResponseBody
    public final void postRequestTableReload(@Parameter(description="The source node ID that will send the load", required=true) @RequestParam(value="sourceNodeId") String sourceNodeId, @Parameter(description="The target node ID that will receive the load", required=true) @RequestParam(value="targetNodeId") String targetNodeId, @Parameter(description="The capture ID for a table or \"ALL\" for all tables", required=true) @RequestParam(value="triggerId") String triggerId, @Parameter(description="The router ID for a table or \"ALL\" for all tables", required=true) @RequestParam(value="routerId") String routerId, @Parameter(description="Create tables if they don't exist", required=true) @RequestParam(value="createTable") boolean createTable, @Parameter(description="Delete from each table before loading", required=true) @RequestParam(value="deleteFirst") boolean deleteFirst, @Parameter(description="The SQL \"where\" clause for extracting the table") @RequestParam(value="reloadSelect") String reloadSelect, @Parameter(description="Custom SQL to run before each table, use %s as variable for table name") @RequestParam(value="beforeCustomSql") String beforeCustomSql) {
        this.postRequestTableReload(this.getSymmetricEngine().getEngineName(), sourceNodeId, targetNodeId, triggerId, routerId, createTable, deleteFirst, reloadSelect, beforeCustomSql);
    }

    @Operation(summary="Request a table reload for the specified source and target node with a specific engine")
    @RequestMapping(value={"/engine/{engine}/requesttablereload"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @ResponseBody
    public final void postRequestTableReload(@PathVariable(value="engine") String engineName, @Parameter(description="The source node ID that will send the load", required=true) @RequestParam(value="sourceNodeId") String sourceNodeId, @Parameter(description="The target node ID that will receive the load", required=true) @RequestParam(value="targetNodeId") String targetNodeId, @Parameter(description="The capture ID for a table or \"ALL\" for all tables", required=true) @RequestParam(value="triggerId") String triggerId, @Parameter(description="The router ID for a table or \"ALL\" for all tables", required=true) @RequestParam(value="routerId") String routerId, @Parameter(description="Create tables if they don't exist", required=true) @RequestParam(value="createTable") boolean createTable, @Parameter(description="Delete from each table before loading", required=true) @RequestParam(value="deleteFirst") boolean deleteFirst, @Parameter(description="The SQL \"where\" clause for extracting the table") @RequestParam(value="reloadSelect") String reloadSelect, @Parameter(description="Custom SQL to run before each table, use %s as variable for table name") @RequestParam(value="beforeCustomSql") String beforeCustomSql) {
        ISymmetricEngine engine = this.getSymmetricEngine(engineName);
        org.jumpmind.symmetric.model.Node sourceNode = engine.getNodeService().findNode(sourceNodeId);
        if (sourceNode == null) {
            throw new NotFoundException("Source node '" + sourceNodeId + "' not found");
        }
        org.jumpmind.symmetric.model.Node targetNode = engine.getNodeService().findNode(targetNodeId);
        if (targetNode == null) {
            throw new NotFoundException("Target node '" + targetNodeId + "' not found");
        }
        if (!"ALL".equals(triggerId) && engine.getTriggerRouterService().getTriggerById(triggerId) == null) {
            throw new NotFoundException("Table Capture ID '" + triggerId + "' not found");
        }
        if (!"ALL".equals(routerId) && engine.getTriggerRouterService().getRouterById(routerId) == null) {
            throw new NotFoundException("Router ID '" + routerId + "' not found");
        }
        TriggerRouter triggerRouter = engine.getTriggerRouterService().findTriggerRouterById(triggerId, routerId);
        if (!"ALL".equals(triggerId) && !"ALL".equals(routerId) && triggerRouter == null) {
            throw new NotFoundException("Association of table capture ID '" + triggerId + "' and router ID '" + routerId + "' not found");
        }
        if (triggerRouter != null && triggerRouter.getRouter() != null && triggerRouter.getRouter().getNodeGroupLink() != null) {
            NodeGroupLink link = triggerRouter.getRouter().getNodeGroupLink();
            if (!link.getSourceNodeGroupId().equals(sourceNode.getNodeGroupId())) {
                throw new NotFoundException("Source node group of '" + sourceNode.getNodeGroupId() + "' does not match with node group link");
            }
            if (!link.getTargetNodeGroupId().equals(targetNode.getNodeGroupId())) {
                throw new NotFoundException("Target node group of '" + targetNode.getNodeGroupId() + "' does not match with node group link");
            }
        }
        TableReloadRequest request = new TableReloadRequest();
        request.setSourceNodeId(sourceNodeId);
        request.setTargetNodeId(targetNodeId);
        request.setTriggerId(triggerId);
        request.setRouterId(routerId);
        request.setCreateTable(createTable);
        request.setDeleteFirst(deleteFirst);
        request.setReloadSelect(StringUtils.trimToNull((String)reloadSelect));
        request.setBeforeCustomSql(StringUtils.trimToNull((String)beforeCustomSql));
        request.setCreateTime(new Date(System.currentTimeMillis() / 1000L * 1000L));
        engine.getDataService().insertTableReloadRequest(request);
    }

    @Operation(summary="Outgoing summary of batches and data counts waiting for a node")
    @RequestMapping(value={"/engine/outgoingBatchSummary"}, method={RequestMethod.GET}, produces={"application/json", "application/xml"})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public final BatchSummaries getOutgoingBatchSummary(@RequestParam(value="nodeId") String nodeId) {
        return this.getOutgoingBatchSummary(this.getSymmetricEngine().getEngineName(), nodeId);
    }

    @Operation(summary="Outgoing summary of batches and data counts waiting for a node")
    @RequestMapping(value={"/engine/{engine}/outgoingBatchSummary"}, method={RequestMethod.GET}, produces={"application/json", "application/xml"})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public final BatchSummaries getOutgoingBatchSummary(@PathVariable(value="engine") String engineName, @RequestParam(value="nodeId") String nodeId) {
        ISymmetricEngine engine = this.getSymmetricEngine(engineName);
        INodeService nodeService = engine.getNodeService();
        org.jumpmind.symmetric.model.Node targetNode = nodeService.findNode(nodeId);
        if (targetNode == null) {
            throw new NotAllowedException();
        }
        BatchSummaries summaries = new BatchSummaries();
        summaries.setNodeId(nodeId);
        IOutgoingBatchService outgoingBatchService = engine.getOutgoingBatchService();
        List list = outgoingBatchService.findOutgoingBatchSummary(new AbstractBatch.Status[]{AbstractBatch.Status.RQ, AbstractBatch.Status.QY, AbstractBatch.Status.NE, AbstractBatch.Status.SE, AbstractBatch.Status.LD, AbstractBatch.Status.ER});
        for (OutgoingBatchSummary sum : list) {
            if (!sum.getNodeId().equals(nodeId)) continue;
            BatchSummary summary = new BatchSummary();
            summary.setBatchCount(sum.getBatchCount());
            summary.setDataCount(sum.getDataCount());
            summary.setOldestBatchCreateTime(sum.getOldestBatchCreateTime());
            summary.setStatus(sum.getStatus().name());
            summaries.getBatchSummaries().add(summary);
        }
        return summaries;
    }

    @Operation(summary="Read parameter value")
    @RequestMapping(value={"engine/parameter/{name}"}, method={RequestMethod.GET}, produces={"application/json", "application/xml"})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public final String getParameter(@PathVariable(value="name") String name) {
        return this.getParameterImpl(this.getSymmetricEngine(), name);
    }

    @Operation(summary="Read paramater value for the specified engine")
    @RequestMapping(value={"engine/{engine}/parameter/{name}"}, method={RequestMethod.GET}, produces={"application/json", "application/xml"})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public final String getParameter(@PathVariable(value="engine") String engineName, @PathVariable(value="name") String name) {
        return this.getParameterImpl(this.getSymmetricEngine(engineName), name);
    }

    private String getParameterImpl(ISymmetricEngine service, String name) {
        String parameterName = name.replace('_', '.');
        if (parameterName.equals("db.password")) {
            return "";
        }
        return service.getParameterService().getString(parameterName);
    }

    @Operation(summary="Add a new console user")
    @RequestMapping(value={"engine/useradd/{username}"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ResponseBody
    public final void postUserAdd(@PathVariable(value="username") String username, @RequestParam(value="firstName") String firstName, @RequestParam(value="lastName") String lastName, @RequestParam(required=false, value="role") String role, @RequestParam(required=false, value="email") String email, @RequestParam(value="password") String password) {
        String engineName = this.getSymmetricEngine().getEngineName();
        this.postUserAdd(engineName, username, firstName, lastName, role, email, password);
    }

    @Operation(summary="Add a new console user")
    @RequestMapping(value={"engine/{engine}/useradd/{username}"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ResponseBody
    public final void postUserAdd(@PathVariable(value="engine") String engineName, @PathVariable(value="username") String username, @RequestParam(value="firstName") String firstName, @RequestParam(value="lastName") String lastName, @RequestParam(required=false, value="role") String role, @RequestParam(required=false, value="email") String email, @RequestParam(value="password") String password) {
        ISymmetricEngine engine = this.getSymmetricEngine(engineName);
        new SymmetricConsole(engine).addUser(username, firstName, lastName, role, email, password);
    }

    @Operation(summary="Modify a console user's role and/or email address")
    @RequestMapping(value={"engine/usermodify/{username}"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @ResponseBody
    public final void postUserModify(@PathVariable(value="username") String username, @RequestParam(required=false, value="role") String role, @RequestParam(required=false, value="email") String email) {
        String engineName = this.getSymmetricEngine().getEngineName();
        this.postUserModify(engineName, username, role, email);
    }

    @Operation(summary="Modify a console user's role and/or email address")
    @RequestMapping(value={"engine/{engine}/usermodify/{username}"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @ResponseBody
    public final void postUserModify(@PathVariable(value="engine") String engineName, @PathVariable(value="username") String username, @RequestParam(required=false, value="role") String role, @RequestParam(required=false, value="email") String email) {
        ISymmetricEngine engine = this.getSymmetricEngine(engineName);
        ConsoleUser user = ((IConsoleUserService)engine.getExtensionService().getExtensionPoint(IConsoleUserService.class)).findConsoleUser(username);
        if (user == null) {
            throw new NotFoundException();
        }
        new SymmetricConsole(engine).modifyUser(user, role, email);
    }

    @Operation(summary="Delete a console user")
    @RequestMapping(value={"engine/userdel/{username}"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @ResponseBody
    public final void postUserDelete(@RequestParam(value="username") String username) {
        String engineName = this.getSymmetricEngine().getEngineName();
        this.postUserDelete(engineName, username);
    }

    @Operation(summary="Delete a console user")
    @RequestMapping(value={"engine/{engine}/userdel/{username}"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @ResponseBody
    public final void postUserDelete(@PathVariable(value="engine") String engineName, @PathVariable(value="username") String username) {
        ISymmetricEngine engine = this.getSymmetricEngine(engineName);
        ConsoleUser user = ((IConsoleUserService)engine.getExtensionService().getExtensionPoint(IConsoleUserService.class)).findConsoleUser(username);
        if (user == null) {
            throw new NotFoundException();
        }
        new SymmetricConsole(engine).deleteUser(user);
    }

    @Operation(summary="Change a console user's password and set the user's failed login count to 0")
    @RequestMapping(value={"engine/userpasswd/{username}"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @ResponseBody
    public final void postUserPassword(@PathVariable(value="username") String username, @RequestParam(value="password") String password) {
        String engineName = this.getSymmetricEngine().getEngineName();
        this.postUserPassword(engineName, username, password);
    }

    @Operation(summary="Change a console user's password and set the user's failed login count to 0")
    @RequestMapping(value={"engine/{engine}/userpasswd/{username}"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @ResponseBody
    public final void postUserPassword(@PathVariable(value="engine") String engineName, @PathVariable(value="username") String username, @RequestParam(value="password") String password) {
        ISymmetricEngine engine = this.getSymmetricEngine(engineName);
        ConsoleUser user = ((IConsoleUserService)engine.getExtensionService().getExtensionPoint(IConsoleUserService.class)).findConsoleUser(username);
        if (user == null) {
            throw new NotFoundException();
        }
        new SymmetricConsole(engine).setUserPassword(user, password);
    }

    @Operation(summary="Enable a console user and set the user's failed login count to 0")
    @RequestMapping(value={"engine/userenable/{username}"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @ResponseBody
    public final void postUserEnable(@PathVariable(value="username") String username) {
        String engineName = this.getSymmetricEngine().getEngineName();
        this.postUserEnable(engineName, username);
    }

    @Operation(summary="Enable a console user and set the user's failed login count to 0")
    @RequestMapping(value={"engine/{engine}/userenable/{username}"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @ResponseBody
    public final void postUserEnable(@PathVariable(value="engine") String engineName, @PathVariable(value="username") String username) {
        ISymmetricEngine engine = this.getSymmetricEngine(engineName);
        ConsoleUser user = ((IConsoleUserService)engine.getExtensionService().getExtensionPoint(IConsoleUserService.class)).findConsoleUser(username);
        if (user == null) {
            throw new NotFoundException();
        }
        new SymmetricConsole(engine).enableUser(user);
    }

    @Operation(summary="Disable a console user")
    @RequestMapping(value={"engine/userdisable/{username}"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @ResponseBody
    public final void postUserDisable(@PathVariable(value="username") String username) {
        String engineName = this.getSymmetricEngine().getEngineName();
        this.postUserDisable(engineName, username);
    }

    @Operation(summary="Disable a console user")
    @RequestMapping(value={"engine/{engine}/userdisable/{username}"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @ResponseBody
    public final void postUserDisable(@PathVariable(value="engine") String engineName, @PathVariable(value="username") String username) {
        ISymmetricEngine engine = this.getSymmetricEngine(engineName);
        ConsoleUser user = ((IConsoleUserService)engine.getExtensionService().getExtensionPoint(IConsoleUserService.class)).findConsoleUser(username);
        if (user == null) {
            throw new NotFoundException();
        }
        new SymmetricConsole(engine).disableUser(user);
    }

    @Operation(summary="Change the keystore password and the key entries' passwords")
    @RequestMapping(value={"engine/kspasswd"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @ResponseBody
    public final void postKeystorePassword(@RequestParam(value="password") String password) {
        String engineName = this.getSymmetricEngine().getEngineName();
        this.postKeystorePassword(engineName, password);
    }

    @Operation(summary="Change the keystore password and the key entries' passwords")
    @RequestMapping(value={"engine/{engine}/kspasswd"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @ResponseBody
    public final void postKeystorePassword(@PathVariable(value="engine") String engineName, @RequestParam(value="password") String password) {
        ISymmetricEngine engine = this.getSymmetricEngine(engineName);
        try {
            new SymmetricConsole(engine).setKeystorePassword(password);
        }
        catch (Exception e2) {
            this.handleException(e2);
            throw new InternalServerErrorException();
        }
    }

    @Operation(summary="Change the database username in the specified engine's .properties file")
    @RequestMapping(value={"engine/dbuser/{username}"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @ResponseBody
    public final void postDatabaseUser(@PathVariable String username) {
        String engineName = this.getSymmetricEngine().getEngineName();
        this.postDatabaseUser(engineName, username);
    }

    @Operation(summary="Change the database username in the specified engine's .properties file")
    @RequestMapping(value={"engine/{engine}/dbuser/{username}"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @ResponseBody
    public final void postDatabaseUser(@PathVariable(value="engine") String engineName, @PathVariable(value="username") String username) {
        ISymmetricEngine engine = this.getSymmetricEngine(engineName);
        try {
            new SymmetricConsole(engine).setDatabaseUser(username);
        }
        catch (Exception e2) {
            this.handleException(e2);
            throw new InternalServerErrorException();
        }
    }

    @Operation(summary="Change the database user's password in the specified engine's .properties file")
    @RequestMapping(value={"engine/dbpasswd"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @ResponseBody
    public final void postDatabasePassword(@RequestParam(value="password") String password) {
        String engineName = this.getSymmetricEngine().getEngineName();
        this.postDatabasePassword(engineName, password);
    }

    @Operation(summary="Change the database user's password in the specified engine's .properties file")
    @RequestMapping(value={"engine/{engine}/dbpasswd"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @ResponseBody
    public final void postDatabasePassword(@PathVariable(value="engine") String engineName, @RequestParam(value="password") String password) {
        ISymmetricEngine engine = this.getSymmetricEngine(engineName);
        try {
            new SymmetricConsole(engine).setDatabasePassword(password);
        }
        catch (Exception e2) {
            this.handleException(e2);
            throw new InternalServerErrorException();
        }
    }

    @Operation(summary="Clear a heartbeat for the specified engine")
    @RequestMapping(value={"/engine/{engine}/clearHeartbeat"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @ResponseBody
    public final void postClearHeartbeat(@PathVariable(value="engine") String engineName, @RequestParam(required=true, value="nodeId") String nodeId, @RequestParam(required=false, value="instanceId") String instanceId) {
        ISymmetricEngine engine = this.getSymmetricEngine(engineName);
        if (StringUtils.isBlank((CharSequence)instanceId)) {
            engine.getNodeService().deleteNodeHost(nodeId);
        } else {
            engine.getNodeService().deleteNodeHostInstance(nodeId, instanceId);
        }
    }

    @ExceptionHandler(value={Exception.class})
    @ResponseBody
    public ResponseEntity<String> handleException(Exception ex2) {
        int httpErrorCode = 500;
        ResponseStatus annotation = ex2.getClass().getAnnotation(ResponseStatus.class);
        if (annotation != null) {
            httpErrorCode = annotation.value().value();
        }
        HttpHeaders headers = new HttpHeaders();
        if (httpErrorCode == HttpStatus.INTERNAL_SERVER_ERROR.value()) {
            this.log.warn("Internal server error during rest service call.", (Throwable)ex2);
        } else {
            this.log.debug("Exception during rest services http=" + httpErrorCode, (Throwable)ex2);
        }
        return new ResponseEntity((Object)("SymmetricDS API Invocation failed. " + ex2.getMessage()), (MultiValueMap)headers, (HttpStatusCode)HttpStatus.valueOf((int)httpErrorCode));
    }

    private void startImpl(ISymmetricEngine engine) {
        engine.getParameterService().saveParameter(engine.getParameterService().getExternalId(), engine.getParameterService().getNodeGroupId(), "auto.start.engine", (Object)"true", "system");
        if (!engine.start()) {
            throw new InternalServerErrorException();
        }
    }

    private void stopImpl(ISymmetricEngine engine) {
        engine.stop();
        engine.getParameterService().saveParameter(engine.getParameterService().getExternalId(), engine.getParameterService().getNodeGroupId(), "auto.start.engine", (Object)"false", "system");
    }

    private void syncTriggersImpl(ISymmetricEngine engine, boolean force) {
        ITriggerRouterService triggerRouterService = engine.getTriggerRouterService();
        triggerRouterService.syncTriggers((StringBuilder)null, force);
        this.assertTriggerCreation(triggerRouterService, null);
    }

    private void syncTriggersByTableImpl(ISymmetricEngine engine, String catalogName, String schemaName, String tableName, boolean force) {
        ITriggerRouterService triggerRouterService = engine.getTriggerRouterService();
        Table table = this.getSymmetricEngine().getDatabasePlatform().getTableFromCache(catalogName, schemaName, tableName, true);
        if (table == null) {
            throw new NotFoundException();
        }
        triggerRouterService.syncTriggers(table, force);
        this.assertTriggerCreation(triggerRouterService, table);
    }

    private void assertTriggerCreation(ITriggerRouterService triggerRouterService, Table table) {
        for (Map.Entry failedTriggers : triggerRouterService.getFailedTriggers().entrySet()) {
            if (table != null && !((Trigger)failedTriggers.getKey()).getFullyQualifiedSourceTableName().equalsIgnoreCase(table.getFullyQualifiedTableName())) continue;
            throw new SymmetricException("Failed to reconfigure table(s) for capture", (Throwable)failedTriggers.getValue());
        }
    }

    private void dropTriggersImpl(ISymmetricEngine engine) {
        ITriggerRouterService triggerRouterService = engine.getTriggerRouterService();
        triggerRouterService.dropTriggers();
    }

    private void dropTriggersImpl(ISymmetricEngine engine, String tableName) {
        ITriggerRouterService triggerRouterService = engine.getTriggerRouterService();
        HashSet<String> tables = new HashSet<String>();
        tables.add(tableName);
        triggerRouterService.dropTriggers(tables);
    }

    private SendSchemaResponse sendSchemaImpl(ISymmetricEngine engine, SendSchemaRequest request) {
        IConfigurationService configurationService = engine.getConfigurationService();
        INodeService nodeService = engine.getNodeService();
        ITriggerRouterService triggerRouterService = engine.getTriggerRouterService();
        IDataService dataService = engine.getDataService();
        SendSchemaResponse response = new SendSchemaResponse();
        org.jumpmind.symmetric.model.Node identity = nodeService.findIdentity();
        if (identity != null) {
            ArrayList<org.jumpmind.symmetric.model.Node> nodesToSendTo = new ArrayList<org.jumpmind.symmetric.model.Node>();
            List<String> nodeIds = request.getNodeIdsToSendTo();
            if (nodeIds == null || nodeIds.size() == 0) {
                String nodeGroupIdToSendTo = request.getNodeGroupIdToSendTo();
                if (StringUtils.isNotBlank((CharSequence)nodeGroupIdToSendTo)) {
                    NodeGroupLink link = configurationService.getNodeGroupLinkFor(identity.getNodeGroupId(), nodeGroupIdToSendTo, false);
                    if (link != null) {
                        Collection nodes = nodeService.findEnabledNodesFromNodeGroup(nodeGroupIdToSendTo);
                        nodesToSendTo.addAll(nodes);
                    } else {
                        this.log.warn("Could not send schema to all nodes in the '" + (String)nodeGroupIdToSendTo + "' node group.  No node group link exists");
                    }
                } else {
                    this.log.warn("Could not send schema to nodes.  There are none that were provided and the nodeGroupIdToSendTo was also not provided");
                }
            } else {
                for (String nodeIdToValidate : nodeIds) {
                    org.jumpmind.symmetric.model.Node node = nodeService.findNode(nodeIdToValidate);
                    if (node != null) {
                        NodeGroupLink link = configurationService.getNodeGroupLinkFor(identity.getNodeGroupId(), node.getNodeGroupId(), false);
                        if (link != null) {
                            nodesToSendTo.add(node);
                            continue;
                        }
                        this.log.warn("Could not send schema to node '" + nodeIdToValidate + "'. No node group link exists");
                        continue;
                    }
                    this.log.warn("Could not send schema to node '" + nodeIdToValidate + "'.  It was not present in the database");
                }
            }
            Map<String, List<TableName>> results = response.getNodeIdsSentTo();
            List<String> nodeIdsToSendTo = this.toNodeIds(nodesToSendTo);
            for (String nodeId : nodeIdsToSendTo) {
                results.put(nodeId, new ArrayList());
            }
            if (nodesToSendTo.size() > 0) {
                List<TableName> tablesToSend = request.getTablesToSend();
                List triggerRouters = triggerRouterService.getTriggerRouters(false);
                for (TriggerRouter triggerRouter : triggerRouters) {
                    Trigger trigger = triggerRouter.getTrigger();
                    NodeGroupLink link = triggerRouter.getRouter().getNodeGroupLink();
                    if (!link.getSourceNodeGroupId().equals(identity.getNodeGroupId())) continue;
                    for (org.jumpmind.symmetric.model.Node node : nodesToSendTo) {
                        if (!link.getTargetNodeGroupId().equals(node.getNodeGroupId()) || tablesToSend != null && tablesToSend.size() != 0 && !this.contains(trigger, tablesToSend)) continue;
                        dataService.sendSchema(node.getNodeId(), trigger.getSourceCatalogName(), trigger.getSourceSchemaName(), trigger.getSourceTableName(), false, false, false, false);
                        results.get(node.getNodeId()).add(new TableName(trigger.getSourceCatalogName(), trigger.getSourceSchemaName(), trigger.getSourceTableName()));
                    }
                }
            }
        }
        return response;
    }

    private boolean contains(Trigger trigger, List<TableName> tables) {
        for (TableName tableName : tables) {
            if (!trigger.getFullyQualifiedSourceTableName().equals(Table.getFullyQualifiedTableName((String)tableName.getCatalogName(), (String)tableName.getSchemaName(), (String)tableName.getTableName()))) continue;
            return true;
        }
        return false;
    }

    private List<String> toNodeIds(List<org.jumpmind.symmetric.model.Node> nodes) {
        ArrayList<String> nodeIds = new ArrayList<String>(nodes.size());
        for (org.jumpmind.symmetric.model.Node node : nodes) {
            nodeIds.add(node.getNodeId());
        }
        return nodeIds;
    }

    private void uninstallImpl(ISymmetricEngine engine) {
        this.getSymmetricEngineHolder().uninstallEngine(engine);
    }

    private void reinitializeImpl(ISymmetricEngine engine) {
        INodeService nodeService = engine.getNodeService();
        org.jumpmind.symmetric.model.Node modelNode = nodeService.findIdentity();
        if (!this.isRootNode(engine, modelNode)) {
            engine.uninstall();
        }
        engine.start();
    }

    private void clearCacheImpl(ISymmetricEngine engine) {
        engine.clearCaches();
    }

    private void loadProfileImpl(ISymmetricEngine engine, MultipartFile file) {
        IDataLoaderService dataLoaderService = engine.getDataLoaderService();
        boolean inError = false;
        try {
            String content = new String(file.getBytes(), Charset.defaultCharset());
            List batches = dataLoaderService.loadDataBatch(content);
            for (IncomingBatch batch : batches) {
                if (batch.getStatus() != AbstractBatch.Status.ER) continue;
                inError = true;
            }
        }
        catch (Exception e2) {
            inError = true;
        }
        if (inError) {
            throw new InternalServerErrorException();
        }
    }

    private NodeList childrenImpl(ISymmetricEngine engine) {
        NodeList children = new NodeList();
        Node xmlChildNode = null;
        INodeService nodeService = engine.getNodeService();
        org.jumpmind.symmetric.model.Node modelNode = nodeService.findIdentity();
        if (this.isRegistered(engine)) {
            NetworkedNode networkedNode;
            Set childNetwork;
            if (this.isRootNode(engine, modelNode) && (childNetwork = (networkedNode = nodeService.getRootNetworkedNode()).getChildren()) != null) {
                for (NetworkedNode child : childNetwork) {
                    List nodeHosts = nodeService.findNodeHosts(child.getNode().getNodeId());
                    NodeSecurity nodeSecurity = nodeService.findNodeSecurity(child.getNode().getNodeId());
                    xmlChildNode = new Node();
                    xmlChildNode.setNodeId(child.getNode().getNodeId());
                    xmlChildNode.setExternalId(child.getNode().getExternalId());
                    xmlChildNode.setRegistrationServer(false);
                    xmlChildNode.setSyncUrl(child.getNode().getSyncUrl());
                    xmlChildNode.setBatchInErrorCount(child.getNode().getBatchInErrorCount());
                    xmlChildNode.setBatchToSendCount(child.getNode().getBatchToSendCount());
                    if (nodeHosts.size() > 0) {
                        xmlChildNode.setLastHeartbeat(((NodeHost)nodeHosts.get(0)).getHeartbeatTime());
                    }
                    if (nodeSecurity != null) {
                        xmlChildNode.setRegistered(nodeSecurity.hasRegistered());
                        xmlChildNode.setInitialLoaded(nodeSecurity.hasInitialLoaded());
                        xmlChildNode.setReverseInitialLoaded(nodeSecurity.hasReverseInitialLoaded());
                    }
                    if (child.getNode().getCreatedAtNodeId() == null) {
                        xmlChildNode.setRegistrationServer(true);
                    }
                    children.addNode(xmlChildNode);
                }
            }
        } else {
            throw new NotFoundException();
        }
        return children;
    }

    private Node nodeImpl(ISymmetricEngine engine) {
        org.jumpmind.symmetric.model.Node modelNode;
        Node xmlNode = new Node();
        if (this.isRegistered(engine)) {
            INodeService nodeService = engine.getNodeService();
            modelNode = nodeService.findIdentity();
            List nodeHosts = nodeService.findNodeHosts(modelNode.getNodeId());
            NodeSecurity nodeSecurity = nodeService.findNodeSecurity(modelNode.getNodeId());
            xmlNode.setNodeId(modelNode.getNodeId());
            xmlNode.setExternalId(modelNode.getExternalId());
            xmlNode.setSyncUrl(modelNode.getSyncUrl());
            xmlNode.setRegistrationUrl(engine.getParameterService().getRegistrationUrl());
            xmlNode.setBatchInErrorCount(modelNode.getBatchInErrorCount());
            xmlNode.setBatchToSendCount(modelNode.getBatchToSendCount());
            if (nodeHosts.size() > 0) {
                xmlNode.setLastHeartbeat(((NodeHost)nodeHosts.get(0)).getHeartbeatTime());
            }
            xmlNode.setHeartbeatInterval(engine.getParameterService().getInt("job.heartbeat.period.time.ms"));
            if (nodeSecurity != null) {
                xmlNode.setRegistered(nodeSecurity.hasRegistered());
                xmlNode.setInitialLoaded(nodeSecurity.hasInitialLoaded());
                xmlNode.setReverseInitialLoaded(nodeSecurity.hasReverseInitialLoaded());
            }
            if (modelNode.getCreatedAtNodeId() == null) {
                xmlNode.setRegistrationServer(true);
            } else {
                xmlNode.setRegistrationServer(false);
            }
        } else {
            throw new NotFoundException();
        }
        xmlNode.setCreatedAtNodeId(modelNode.getCreatedAtNodeId());
        return xmlNode;
    }

    private boolean isRootNode(ISymmetricEngine engine, org.jumpmind.symmetric.model.Node node) {
        INodeService nodeService = engine.getNodeService();
        org.jumpmind.symmetric.model.Node modelNode = nodeService.findIdentity();
        return modelNode.getCreatedAtNodeId() == null || modelNode.getCreatedAtNodeId().equalsIgnoreCase(modelNode.getExternalId());
    }

    private boolean isRegistered(ISymmetricEngine engine) {
        boolean registered = true;
        INodeService nodeService = engine.getNodeService();
        org.jumpmind.symmetric.model.Node modelNode = nodeService.findIdentity();
        if (modelNode == null) {
            registered = false;
        } else {
            NodeSecurity nodeSecurity = nodeService.findNodeSecurity(modelNode.getNodeId());
            if (nodeSecurity == null) {
                registered = false;
            }
        }
        return registered;
    }

    private NodeStatus nodeStatusImpl(ISymmetricEngine engine) {
        NodeStatus status = new NodeStatus();
        if (this.isRegistered(engine)) {
            INodeService nodeService = engine.getNodeService();
            org.jumpmind.symmetric.model.Node modelNode = nodeService.findIdentity();
            NodeSecurity nodeSecurity = nodeService.findNodeSecurity(modelNode.getNodeId());
            List nodeHost = nodeService.findNodeHosts(modelNode.getNodeId());
            status.setStarted(engine.isStarted());
            if (nodeSecurity != null) {
                status.setRegistered(nodeSecurity.hasRegistered());
                status.setInitialLoaded(nodeSecurity.getInitialLoadTime() != null);
                status.setReverseInitialLoaded(nodeSecurity.getRevInitialLoadTime() != null);
            }
            status.setNodeId(modelNode.getNodeId());
            status.setNodeGroupId(modelNode.getNodeGroupId());
            status.setExternalId(modelNode.getExternalId());
            status.setSyncUrl(modelNode.getSyncUrl());
            status.setRegistrationUrl(engine.getParameterService().getRegistrationUrl());
            status.setDatabaseType(modelNode.getDatabaseType());
            status.setDatabaseVersion(modelNode.getDatabaseVersion());
            status.setSyncEnabled(modelNode.isSyncEnabled());
            status.setCreatedAtNodeId(modelNode.getCreatedAtNodeId());
            status.setBatchToSendCount(engine.getOutgoingBatchService().countOutgoingBatchesUnsent());
            status.setBatchInErrorCount(engine.getOutgoingBatchService().countOutgoingBatchesInError());
            status.setDeploymentType(modelNode.getDeploymentType());
            if (modelNode.getCreatedAtNodeId() == null) {
                status.setRegistrationServer(true);
            } else {
                status.setRegistrationServer(false);
            }
            if (nodeHost != null && nodeHost.size() > 0) {
                status.setLastHeartbeat(((NodeHost)nodeHost.get(0)).getHeartbeatTime());
            }
            status.setHeartbeatInterval(engine.getParameterService().getInt("heartbeat.sync.on.push.period.sec"));
            if (status.getHeartbeatInterval() == 0) {
                status.setHeartbeatInterval(600);
            }
        } else {
            throw new NotFoundException();
        }
        return status;
    }

    private Set<ChannelStatus> channelStatusImpl(ISymmetricEngine engine) {
        HashSet<ChannelStatus> channelStatus = new HashSet<ChannelStatus>();
        List channels = engine.getConfigurationService().getNodeChannels(false);
        for (NodeChannel nodeChannel : channels) {
            String channelId = nodeChannel.getChannelId();
            ChannelStatus status = new ChannelStatus();
            status.setChannelId(channelId);
            int outgoingInError = engine.getOutgoingBatchService().countOutgoingBatchesInError(channelId);
            int incomingInError = engine.getIncomingBatchService().countIncomingBatchesInError(channelId);
            status.setBatchInErrorCount(outgoingInError);
            status.setBatchToSendCount(engine.getOutgoingBatchService().countOutgoingBatchesUnsent(channelId));
            status.setIncomingError(incomingInError > 0);
            status.setOutgoingError(outgoingInError > 0);
            status.setEnabled(nodeChannel.isEnabled());
            status.setIgnoreEnabled(nodeChannel.isIgnoreEnabled());
            status.setSuspendEnabled(nodeChannel.isSuspendEnabled());
            channelStatus.add(status);
        }
        return channelStatus;
    }

    private QueryResults queryNodeImpl(ISymmetricEngine engine, String sql, boolean isQuery) {
        QueryResults results = new QueryResults();
        Row xmlRow = null;
        Column xmlColumn = null;
        ISqlTemplate sqlTemplate = engine.getSqlTemplate();
        try {
            if (!isQuery) {
                int updates = sqlTemplate.update(sql, new Object[0]);
                results.setNbrResults(updates);
                return results;
            }
            List rows = sqlTemplate.query(sql);
            int nbrRows = 0;
            for (org.jumpmind.db.sql.Row row : rows) {
                xmlRow = new Row();
                Iterator itr = row.entrySet().iterator();
                int columnOrdinal = 0;
                while (itr.hasNext()) {
                    xmlColumn = new Column();
                    xmlColumn.setOrdinal(++columnOrdinal);
                    Map.Entry pair = (Map.Entry)itr.next();
                    xmlColumn.setName((String)pair.getKey());
                    if (pair.getValue() != null) {
                        xmlColumn.setValue(pair.getValue().toString());
                    }
                    xmlRow.getColumnData().add(xmlColumn);
                }
                xmlRow.setRowNum(++nbrRows);
                results.getResults().add(xmlRow);
            }
            results.setNbrResults(nbrRows);
        }
        catch (Exception ex2) {
            this.log.error("Exception while executing sql.", (Throwable)ex2);
            throw new NotAllowedException("Error while executing sql %s.  Error is %s", sql, ex2.getCause().getMessage());
        }
        return results;
    }

    protected SymmetricEngineHolder getSymmetricEngineHolder() {
        SymmetricEngineHolder holder = (SymmetricEngineHolder)this.context.getAttribute("symmetricEngineHolder");
        if (holder == null) {
            throw new NotFoundException();
        }
        return holder;
    }

    protected ISymmetricEngine getSymmetricEngine(String engineName) {
        SymmetricEngineHolder holder = this.getSymmetricEngineHolder();
        ISymmetricEngine engine = null;
        if (StringUtils.isNotBlank((CharSequence)engineName)) {
            engine = (ISymmetricEngine)holder.getEngines().get(engineName);
        }
        if (engine == null) {
            throw new NotFoundException();
        }
        if (!engine.getParameterService().is("rest.api.enable")) {
            throw new NotAllowedException("The REST API was not enabled for %s", engine.getEngineName());
        }
        MDC.put((String)"engineName", (String)engine.getEngineName());
        return engine;
    }

    protected boolean securityVerified(String nodeId, ISymmetricEngine engine, String securityToken) {
        INodeService nodeService = engine.getNodeService();
        boolean allowed = false;
        org.jumpmind.symmetric.model.Node targetNode = nodeService.findNode(nodeId);
        if (targetNode != null) {
            NodeSecurity security = nodeService.findNodeSecurity(nodeId);
            allowed = security != null && security.getNodePassword().equals(securityToken);
        }
        return allowed;
    }

    protected ISymmetricEngine getSymmetricEngine() {
        ISymmetricEngine engine = null;
        SymmetricEngineHolder holder = this.getSymmetricEngineHolder();
        if (holder.getEngines().size() > 0) {
            engine = (ISymmetricEngine)holder.getEngines().values().iterator().next();
        }
        if (engine == null) {
            throw new NotAllowedException();
        }
        if (!engine.getParameterService().is("rest.api.enable")) {
            throw new NotAllowedException("The REST API was not enabled for %s", engine.getEngineName());
        }
        return engine;
    }
}

