/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.stage;

import com.jumpmind.symmetric.stage.b;
import org.jumpmind.security.ISecurityService;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.io.stage.BatchStagingManager;
import org.jumpmind.symmetric.io.stage.IStagedResource;
import org.jumpmind.symmetric.io.stage.StagedResource;
import org.jumpmind.symmetric.io.stage.StagingManager;
import org.jumpmind.symmetric.service.IParameterService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnhancedStagingManager
extends BatchStagingManager {
    protected static final Logger log = LoggerFactory.getLogger(EnhancedStagingManager.class);
    protected boolean useCrypto;
    protected boolean useCompression;
    protected ISecurityService securityService;
    protected int compressionLevel;

    public EnhancedStagingManager(ISymmetricEngine engine, String directory) {
        super(engine, directory);
        IParameterService parameterService = engine.getParameterService();
        this.useCrypto = parameterService.is("stream.to.file.encrypt.enabled", false);
        if (this.useCrypto) {
            this.securityService = engine.getSecurityService();
            log.info("Encrypted staging is enabled");
        }
        if (this.useCompression = parameterService.is("stream.to.file.compression.enabled", false)) {
            this.compressionLevel = parameterService.getInt("stream.to.file.compression.level", -1);
            log.info("Compressed staging is enabled");
        }
    }

    protected IStagedResource createStagedResource(String filePath) {
        if (this.useCrypto || this.useCompression) {
            return new b(this.directory, filePath, (StagingManager)this, this.securityService, this.compressionLevel);
        }
        return new StagedResource(this.directory, filePath, (StagingManager)this);
    }
}

