/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.security;

import com.jumpmind.symmetric.console.impl.F;
import com.jumpmind.symmetric.security.NodePasswordFilter;
import org.jumpmind.extension.IBuiltInExtensionPoint;
import org.jumpmind.properties.DefaultParameterParser;
import org.jumpmind.security.ISecurityService;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.ext.ISymmetricEngineAware;
import org.jumpmind.symmetric.security.ISmtpPasswordFilter;

public class SmtpPasswordFilter
extends NodePasswordFilter
implements IBuiltInExtensionPoint,
ISymmetricEngineAware,
ISmtpPasswordFilter {
    protected ISecurityService securityService;

    @Override
    public void setSymmetricEngine(ISymmetricEngine engine) {
        this.securityService = engine.getSecurityService();
    }

    public String onSmtpPasswordSave(String password) {
        DefaultParameterParser.ParameterMetaData passwordMetaData;
        if (password != null && (passwordMetaData = F.a().get("smtp.password")).isEncryptedType()) {
            password = "enc:" + this.securityService.encrypt((String)password);
        }
        return password;
    }

    public String onSmtpPasswordRender(String password) {
        if (password != null && password.startsWith("enc:")) {
            try {
                password = this.securityService.decrypt(password.substring("enc:".length()));
            }
            catch (Exception e2) {
                if (System.currentTimeMillis() - this.lastLogTime > 60000L) {
                    this.log.error("Failed to decrypt node password: {}", (Object)e2.getMessage());
                    this.lastLogTime = System.currentTimeMillis();
                }
                password = null;
            }
        }
        return password;
    }
}

