/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.security;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Properties;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestApiKeyFilter
implements Filter {
    private static Logger log = LoggerFactory.getLogger(RestApiKeyFilter.class);
    protected static Properties prop;
    private boolean enabled = false;

    public void init(FilterConfig filterConfig) throws ServletException {
        if (Boolean.valueOf(filterConfig.getInitParameter("enabled")).booleanValue()) {
            this.enabled = true;
            RestApiKeyFilter.loadRestProperties();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!this.enabled) {
            chain.doFilter(request, response);
            return;
        }
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        String uri = httpRequest.getRequestURI();
        String apiKey = httpRequest.getHeader("X-REST-API-KEY");
        if (uri != null && uri.contains("/engine")) {
            if (apiKey == null) {
                httpResponse.sendError(659);
                return;
            }
            MessageDigest digest = null;
            try {
                digest = MessageDigest.getInstance("SHA-256");
            }
            catch (NoSuchAlgorithmException e2) {
                log.error(e2.getMessage(), (Throwable)e2);
            }
            String hashedApiKey = Base64.encodeBase64String((byte[])digest.digest(apiKey.getBytes(StandardCharsets.UTF_8)));
            if (!prop.containsKey(hashedApiKey)) {
                httpResponse.sendError(659);
                return;
            }
            String config = prop.getProperty(hashedApiKey);
            String method = httpRequest.getMethod().toUpperCase();
            if (config == null || config.startsWith("readonly") && !method.equals("GET")) {
                httpResponse.sendError(659);
                return;
            }
        }
        chain.doFilter(request, response);
    }

    public static synchronized void loadRestProperties() {
        String fileName = System.getProperty("sym.rest.properties.file", "security/rest.properties");
        boolean success = false;
        prop = new Properties();
        try {
            success = RestApiKeyFilter.loadRestProperties(new FileInputStream(fileName));
            log.debug("Loaded properties from file {}", (Object)fileName);
        }
        catch (FileNotFoundException e2) {
            log.debug("Unable to load REST properties", (Throwable)e2);
        }
        if (!success) {
            if (RestApiKeyFilter.loadRestProperties(RestApiKeyFilter.class.getResourceAsStream("/rest.properties"))) {
                log.debug("Loaded properties from classpath");
            } else {
                log.debug("No rest.properties found");
            }
        }
    }

    protected static boolean loadRestProperties(InputStream in) {
        if (in != null) {
            boolean bl2;
            block9: {
                InputStream input = in;
                try {
                    prop.load(input);
                    bl2 = true;
                    if (input == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (input != null) {
                            try {
                                input.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e2) {
                        log.debug("Unable to load REST properties", (Throwable)e2);
                    }
                }
                input.close();
            }
            return bl2;
        }
        return false;
    }

    public void destroy() {
    }
}

