/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.notification;

import com.google.gson.reflect.TypeToken;
import com.jumpmind.symmetric.console.impl.fY;
import com.jumpmind.symmetric.console.model.MonitorEvent;
import com.jumpmind.symmetric.console.model.Notification;
import com.jumpmind.symmetric.console.service.IMailService;
import com.jumpmind.symmetric.console.ui.common.as;
import com.jumpmind.symmetric.notification.a;
import com.jumpmind.symmetric.notification.e;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.extension.IBuiltInExtensionPoint;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.ext.ISymmetricEngineAware;
import org.jumpmind.symmetric.model.IncomingBatch;
import org.jumpmind.symmetric.model.OutgoingBatch;
import org.jumpmind.util.FormatUtils;
import org.jumpmind.util.LogSummary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class b
implements a,
IBuiltInExtensionPoint,
ISymmetricEngineAware {
    private final Logger b = LoggerFactory.getLogger(this.getClass());
    protected ISymmetricEngine a;

    @Override
    public void a(Notification notification, List<MonitorEvent> monitorEvents) {
        String recipients;
        Map<String, String> eventListReplacements = e.a(this.a, monitorEvents);
        Notification.EmailExpression expression = (Notification.EmailExpression)notification.getExpression();
        String subject = FormatUtils.replaceTokens((String)expression.getSubject(), eventListReplacements, (boolean)true);
        Map<String, String> templateMap = expression.getTemplateMap();
        StringBuilder text = new StringBuilder();
        if (!StringUtils.isBlank((CharSequence)expression.getBodyBefore())) {
            text.append(FormatUtils.replaceTokens((String)expression.getBodyBefore(), eventListReplacements, (boolean)true) + "\n");
        }
        for (MonitorEvent event : monitorEvents) {
            try {
                Map<String, String> eventReplacements = e.a(this.a, event);
                if (event.getType().equals("log")) {
                    eventReplacements.put("eventDetails", com.jumpmind.symmetric.notification.b.c(event));
                } else if (event.getType().equals("batchError")) {
                    eventReplacements.put("eventDetails", com.jumpmind.symmetric.notification.b.b(event));
                } else if (event.getType().equals("offlineNodes")) {
                    eventReplacements.put("eventDetails", com.jumpmind.symmetric.notification.b.a(event));
                }
                if (monitorEvents.indexOf(event) > 0) {
                    text.append("\n");
                }
                if (event.isResolved()) {
                    text.append(FormatUtils.replaceTokens((String)expression.getResolved(), eventReplacements, (boolean)true));
                    continue;
                }
                text.append(FormatUtils.replaceTokens((String)expression.getUnresolved(), eventReplacements, (boolean)true));
                String template = templateMap.get(event.getType());
                if (template == null) {
                    template = templateMap.get("default");
                }
                if (template == null) continue;
                text.append("\n" + FormatUtils.replaceTokens((String)template, eventReplacements, (boolean)true));
            }
            catch (Exception e2) {
                this.b.debug("", (Throwable)e2);
            }
        }
        if (!StringUtils.isBlank((CharSequence)expression.getBodyAfter())) {
            text.append("\n" + FormatUtils.replaceTokens((String)expression.getBodyAfter(), eventListReplacements, (boolean)true));
        }
        if ((recipients = String.join((CharSequence)",", expression.getEmails())) != null) {
            this.b.info("Sending email with subject '" + subject + "' to " + recipients);
            ((IMailService)this.a.getExtensionService().getExtensionPoint(IMailService.class)).sendEmail(subject, text.toString(), recipients);
        } else {
            this.b.warn("Notification " + notification.getNotificationId() + " has no email recipients configured.");
        }
    }

    protected static String a(MonitorEvent event) throws IOException {
        StringBuilder stackTrace = new StringBuilder();
        stackTrace.append("\n");
        for (String node : com.jumpmind.symmetric.notification.b.d(event)) {
            stackTrace.append("Node ").append(node).append(" is offline.").append("\n");
        }
        return stackTrace.toString();
    }

    protected static String b(MonitorEvent event) throws IOException {
        StringBuilder stackTrace = new StringBuilder();
        fY errors = com.jumpmind.symmetric.notification.b.e(event);
        if (errors != null) {
            List<OutgoingBatch> outErrors = errors.a();
            for (OutgoingBatch b2 : outErrors) {
                stackTrace.append("The outgoing batch ").append(b2.getNodeBatchId());
                stackTrace.append(" failed: ").append(b2.getSqlMessage()).append("\n");
            }
            List<IncomingBatch> inErrors = errors.b();
            for (IncomingBatch b3 : inErrors) {
                stackTrace.append("The incoming batch ").append(b3.getNodeBatchId());
                stackTrace.append(" failed: ").append(b3.getSqlMessage()).append("\n");
            }
        }
        return stackTrace.toString();
    }

    protected static String c(MonitorEvent event) throws IOException {
        StringBuilder stackTrace = new StringBuilder();
        int count = 0;
        for (LogSummary summary : com.jumpmind.symmetric.notification.b.f(event)) {
            if (summary.getMessage() != null) {
                stackTrace.append(summary.getMessage());
                ++count;
            }
            if (summary.getStackTrace() == null) continue;
            stackTrace.append(summary.getStackTrace());
            ++count;
        }
        if (count > 0) {
            stackTrace.append("\n");
        }
        return stackTrace.toString();
    }

    protected static List<String> d(MonitorEvent event) throws IOException {
        List nodes = null;
        if (event.getDetails() != null) {
            nodes = (List)as.getMonitorEventGson().fromJson(event.getDetails(), new TypeToken<List<String>>(){}.getType());
        }
        if (nodes == null) {
            nodes = Collections.emptyList();
        }
        return nodes;
    }

    protected static fY e(MonitorEvent event) {
        fY batches = null;
        if (event.getDetails() != null) {
            batches = (fY)as.getMonitorEventGson().fromJson(event.getDetails(), fY.class);
        }
        return batches;
    }

    protected static List<LogSummary> f(MonitorEvent event) throws IOException {
        List summaries = null;
        if (event.getDetails() != null) {
            summaries = (List)as.getMonitorEventGson().fromJson(event.getDetails(), new TypeToken<List<LogSummary>>(){}.getType());
        }
        if (summaries == null) {
            summaries = Collections.emptyList();
        }
        return summaries;
    }

    @Override
    public String a() {
        return "email";
    }

    public void setSymmetricEngine(ISymmetricEngine engine) {
        this.a = engine;
    }
}

