/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.log;

import com.jumpmind.symmetric.console.impl.hh;
import com.jumpmind.symmetric.db.bulk.t;
import com.jumpmind.symmetric.log.e;
import java.io.IOException;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.platform.DatabaseInfo;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.sql.JdbcSqlTransaction;
import org.jumpmind.db.sql.SqlException;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.common.TableConstants;
import org.jumpmind.symmetric.model.Data;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class u
implements e {
    private final Logger h = LoggerFactory.getLogger((String)new hh(new long[]{-5783725336505739905L, 5292168305414640585L, 8686037093842132711L, 5232313814865696748L, -1983868351583638727L, -4242972707139108851L, 3308634111738099271L, -7692885656964447440L}).toString());
    protected static final String[] a = new String[]{"table_name", "event_type", "row_data", "pk_data", "old_data", "trigger_hist_id", "channel_id", "transaction_id", "source_node_id", "create_time"};
    protected ISymmetricEngine b;
    protected DatabaseInfo c;
    protected t d;
    protected Table e;
    protected Column[] f;
    protected final SimpleDateFormat g = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");

    public u(ISymmetricEngine engine) {
        this.b = engine;
        this.c = engine.getDatabasePlatform().getDatabaseInfo();
        this.e = this.a();
        this.f = this.e.getColumns();
    }

    @Override
    public void a(JdbcSqlTransaction transaction, Data data) {
        if (this.d == null) {
            this.b(transaction);
        }
        try {
            String[] internalData = this.a(data);
            this.d.a(this.f, internalData);
        }
        catch (IOException | SQLException e2) {
            throw new SqlException((Throwable)e2);
        }
    }

    @Override
    public void a(JdbcSqlTransaction transaction) {
        if (this.d != null) {
            String diagInfo = String.format("Rows=%d, Rows per second=%.1f", this.d.e(), this.d.b());
            try {
                this.d.close();
                this.h.info("Closed PGCOPY stream and committed data. {}", (Object)diagInfo);
            }
            catch (Exception e2) {
                this.h.error("Error while closing PGCOPY and committing data. " + diagInfo, (Throwable)e2);
                throw this.b.getDatabasePlatform().getSqlTemplate().translate((Throwable)e2);
            }
            finally {
                this.d = null;
            }
        }
    }

    @Override
    public void a(Exception e2) {
        if (this.d != null) {
            try {
                this.d.d();
            }
            catch (SQLException se) {
                throw new SqlException((Throwable)se);
            }
        }
    }

    protected Table a() {
        IDatabasePlatform platform = this.b.getDatabasePlatform();
        String catalogName = platform.getDefaultCatalog();
        String schemaName = platform.getDefaultSchema();
        String tableName = TableConstants.getTableName((String)this.b.getTablePrefix(), (String)"data");
        return new Table(catalogName, schemaName, tableName, a, new String[0]);
    }

    protected String[] a(Data data) {
        try {
            String triggerHistoryId = String.format("%d", data.getTriggerHistory() != null ? data.getTriggerHistory().getTriggerHistoryId() : -1);
            String createTime = this.g.format(data.getCreateTime() == null ? new Date() : data.getCreateTime());
            String[] internalData = new String[]{data.getTableName(), data.getDataEventType().getCode(), data.getRowData(), data.getPkData(), data.getOldData(), triggerHistoryId, data.getChannelId(), data.getTransactionId(), data.getSourceNodeId(), createTime};
            return internalData;
        }
        catch (Exception e2) {
            this.h.error("Failed to convert row data into internal data record", (Throwable)e2);
            throw this.b.getDatabasePlatform().getSqlTemplate().translate((Throwable)e2);
        }
    }

    protected void b(JdbcSqlTransaction transaction) {
        String savePointName = String.format("sym_pgcopyin_csv_logminer_%012d", new Date().getTime());
        String diagInfo = "SavePoint=" + savePointName;
        try {
            this.h.debug("Setting up PGCOPY stream for {}", (Object)diagInfo);
            transaction.commit();
            this.d = new t(transaction, this.e, this.c, false, savePointName);
            this.h.debug("Initalized PGCOPY stream for {}", (Object)diagInfo);
        }
        catch (Exception e2) {
            this.h.error("Error for " + diagInfo, (Throwable)e2);
            this.d = null;
            throw this.b.getDatabasePlatform().getSqlTemplate().translate((Throwable)e2);
        }
    }
}

