/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.log;

import com.jumpmind.symmetric.console.impl.hh;
import com.jumpmind.symmetric.log.h;
import com.jumpmind.symmetric.log.i;
import com.jumpmind.symmetric.log.j;
import com.jumpmind.symmetric.log.l;
import com.jumpmind.symmetric.log.z;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.model.Database;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.sql.DmlStatement;
import org.jumpmind.db.sql.ISqlReadCursor;
import org.jumpmind.db.sql.ISqlRowMapper;
import org.jumpmind.db.sql.ISqlTemplate;
import org.jumpmind.db.sql.ISqlTransaction;
import org.jumpmind.db.sql.Row;
import org.jumpmind.db.sql.mapper.RowMapper;
import org.jumpmind.db.sql.mapper.StringMapper;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.io.data.DataEventType;
import org.jumpmind.symmetric.model.Data;
import org.jumpmind.symmetric.model.TriggerHistory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class o
implements h {
    private final Logger z = LoggerFactory.getLogger((String)new hh(new long[]{7181182499488298754L, -6360056715561970144L, 545864841753251115L, -5737924865240080987L, 6040589272120710487L, 1197851835686942129L, 3322505246621020981L}).toString());
    private static final String A = "SOURCE_PK_COLUMN1";
    protected ISymmetricEngine a;
    protected ISqlTemplate b;
    protected Map<String, l> c;
    protected List<l> d;
    protected Collection<j> e;
    protected Map<String, j> f;
    protected Iterator<l> g;
    protected l h;
    protected ISqlReadCursor<Row> i;
    protected Iterator<Data> j;
    protected Data k;
    protected long l;
    protected long m;
    protected long n;
    protected long o = -1L;
    protected boolean p;
    protected long q;
    protected long r;
    public static final String s = "CHANGETABLE";
    public static final String t = "CHANGES";
    public static final String u = "SYS_CHANGE_VERSION";
    public static final String v = "SYS_CHANGE_COLUMNS";
    public static final String w = "SYS_CHANGE_OPERATION";
    public static final String x = "SYS_CHANGE_CONTEXT";
    public static final String y = "CHANGE_TRACKING_CURRENT_VERSION";

    public o(ISymmetricEngine engine) {
        this.a = engine;
        this.b = engine.getTargetDialect().getPlatform().getSqlTemplate();
        this.f = new HashMap<String, j>();
    }

    @Override
    public boolean handlesSaveOfNextID() {
        return false;
    }

    @Override
    public void savePositionAndCommit(ISqlTransaction transaction) {
    }

    @Override
    public void open() throws z {
        this.p = this.a.getParameterService().is("log.miner.mssql.sort.in.memory", true);
        List<l> orderedLogTriggers = this.g();
        if (this.z.isDebugEnabled()) {
            if (this.a.getParameterService().is("log.miner.mssql.use.tsql.detect.changes", true)) {
                this.z.debug("Retrieving changes detected in {} tables: [{}]", (Object)orderedLogTriggers.size(), (Object)com.jumpmind.symmetric.log.l.a(orderedLogTriggers));
            } else {
                this.z.debug("Scanning for changes in {} configured tables: [{}]", (Object)orderedLogTriggers.size(), (Object)com.jumpmind.symmetric.log.l.a(orderedLogTriggers));
            }
        }
        if (this.p) {
            long ts;
            long sortInMemoryMaxRows = this.a.getParameterService().getLong("log.miner.mssql.sort.in.memory.max.rows", 1000000L);
            ArrayList<Data> allData = new ArrayList<Data>();
            HashMap<l, ArrayList<Data>> deleteMap = new HashMap<l, ArrayList<Data>>();
            long dataCount = 0L;
            long deleteCount = 0L;
            boolean allDataRead = true;
            long startTime = ts = System.currentTimeMillis();
            this.g = orderedLogTriggers.iterator();
            this.b();
            while (this.a()) {
                if (dataCount == sortInMemoryMaxRows) {
                    allDataRead = false;
                    break;
                }
                if (DataEventType.DELETE.equals((Object)this.k.getDataEventType())) {
                    ArrayList<Data> deleteList = (ArrayList<Data>)deleteMap.get(this.h);
                    if (deleteList == null) {
                        deleteList = new ArrayList<Data>();
                    }
                    deleteList.add(this.k);
                    deleteMap.put(this.h, deleteList);
                    ++deleteCount;
                } else {
                    allData.add(this.k);
                }
                ++dataCount;
                if (System.currentTimeMillis() - ts <= 60000L) continue;
                this.z.info("Preparing changes has been processing for {} seconds and {} total rows with {} matching rows", new Object[]{(System.currentTimeMillis() - startTime) / 1000L, this.o, dataCount});
                ts = System.currentTimeMillis();
            }
            if (allDataRead) {
                for (int i2 = orderedLogTriggers.size() - 1; i2 >= 0; --i2) {
                    List deleteList = (List)deleteMap.get(orderedLogTriggers.get(i2));
                    if (deleteList == null) continue;
                    allData.addAll(deleteList);
                }
                if (this.a.getParameterService().is("log.miner.mssql.sort.by.transaction.id", true)) {
                    this.z.debug("Sorting by transaction ID");
                    Collections.sort(allData, new Comparator<Data>(){

                        public int a(Data d1, Data d2) {
                            return Long.valueOf(Long.parseLong(d1.getTransactionId())).compareTo(Long.parseLong(d2.getTransactionId()));
                        }

                        @Override
                        public /* synthetic */ int compare(Object object, Object object2) {
                            return this.a((Data)object, (Data)object2);
                        }
                    });
                }
                this.z.debug("Read {} changes ({} were deletes), sorting resulted in {} changes", new Object[]{dataCount, deleteCount, allData.size()});
                this.j = allData.iterator();
                return;
            }
            this.z.warn("Max rows of {} was reached for sorting in memory, so processing each table in foreign key order", (Object)sortInMemoryMaxRows);
            this.p = false;
        }
        if (!this.p && this.f.size() == 0) {
            for (l lt : orderedLogTriggers) {
                int triggerHistId = lt.b().getTriggerHistoryId();
                j logMarker = new j(String.valueOf(triggerHistId), this.l);
                this.f.put(lt.b().getFullyQualifiedSourceTableName(), logMarker);
            }
        }
        this.g = orderedLogTriggers.iterator();
        this.b();
    }

    @Override
    public boolean hasData() throws z {
        if (this.p) {
            return this.j.hasNext();
        }
        return this.a();
    }

    protected boolean a() throws z {
        while (this.i != null) {
            Row row = (Row)this.i.next();
            if (row != null) {
                Data data;
                ++this.o;
                if (this.z.isDebugEnabled()) {
                    this.z.debug("Row: {}", (Object)row);
                }
                long changeId = row.getLong(u);
                DataEventType eventType = DataEventType.getEventType((String)row.getString(w));
                Object mssqlCheckPkVal = row.get((Object)A);
                if (mssqlCheckPkVal == null && (eventType.getDmlType() == DmlStatement.DmlType.INSERT || eventType.getDmlType() == DmlStatement.DmlType.UPDATE)) {
                    throw new z("Logging detected insert or update that did not have data in user table yet, this can happen on a busy system and mining will be attempted again on next run of the job.");
                }
                if (!this.h.a(eventType)) continue;
                byte[] changeContextBytes = row.getBytes(x);
                String sourceNodeId = null;
                if (changeContextBytes != null) {
                    try {
                        String changeContext = new String(changeContextBytes);
                        if (changeContext.startsWith("SymmetricDS")) {
                            sourceNodeId = changeContext.substring(changeContext.lastIndexOf(":") + 1);
                        }
                    }
                    catch (Exception e2) {
                        this.z.warn("Unable to read CHANGETABLE.SYS_CHANGE_CONTEXT as it was not a string", (Throwable)e2);
                    }
                }
                String pkData = this.a(row, this.h.b().getParsedPkColumnNames());
                String rowData = null;
                if (!eventType.equals((Object)DataEventType.DELETE)) {
                    rowData = this.a(row, this.h.b().getParsedColumnNames());
                }
                if (!this.h.a(data = new Data(this.h.b().getSourceTableName(), eventType, rowData, pkData, this.h.b(), this.h.a().getChannelId(), String.valueOf(changeId), sourceNodeId))) continue;
                this.k = data;
                return true;
            }
            this.b();
        }
        return false;
    }

    @Override
    public Data readData() {
        if (this.p) {
            this.k = this.j.next();
            this.n = Long.valueOf(this.k.getTransactionId()) - 1L;
        } else {
            j logMarker = this.f.get(this.h.b().getFullyQualifiedSourceTableName());
            if (logMarker != null) {
                logMarker.a(Long.valueOf(this.k.getTransactionId()));
            }
        }
        return this.k;
    }

    protected void b() {
        if (this.i != null) {
            this.i.close();
            this.f.remove(this.h.b().getFullyQualifiedSourceTableName());
        }
        if (this.g.hasNext()) {
            j logMarker;
            this.h = this.g.next();
            String sql = this.a(this.h.b(), this.h);
            long queryStartId = this.l;
            if (this.f.size() > 0 && (logMarker = this.f.get(this.h.b().getFullyQualifiedSourceTableName())) != null) {
                queryStartId = logMarker.b();
            }
            this.z.debug("Running SQL: {} [{}, {}]", new Object[]{sql, queryStartId, this.m});
            this.i = this.b.queryForCursor(sql, (ISqlRowMapper)new RowMapper(), new Object[]{queryStartId - 1L, this.m}, new int[]{-5, -5});
        } else {
            this.i = null;
            this.n = this.m;
        }
    }

    protected String a(TriggerHistory history, l logTrigger) {
        StringBuilder columnNames = new StringBuilder();
        int pkLen = history.getParsedPkColumnNames().length;
        int index = 0;
        for (String columnName : history.getParsedColumnNames()) {
            if (columnNames.length() != 0) {
                columnNames.append(", ");
            }
            columnNames.append(index++ < pkLen ? "c." : "t.");
            columnNames.append("\"").append(columnName).append("\"");
        }
        if (pkLen > 0) {
            columnNames.append(", ").append("t.\"").append(history.getParsedPkColumnNames()[0]).append("\" as ").append(A);
        }
        StringBuilder join = new StringBuilder();
        for (String pkName : history.getParsedPkColumnNames()) {
            if (join.length() != 0) {
                join.append(" and ");
            }
            join.append("t.").append("\"").append(pkName).append("\" = c.\"").append(pkName).append("\"");
        }
        Object tableName = history.getFullyQualifiedSourceTableName();
        tableName = "[" + ((String)tableName).replaceAll("\\.", "].[") + "]";
        String sql = "select c.SYS_CHANGE_VERSION, c.SYS_CHANGE_OPERATION, c.SYS_CHANGE_CONTEXT, " + String.valueOf(columnNames) + " from CHANGETABLE (CHANGES " + (String)tableName + ", ?) as c LEFT OUTER JOIN " + (String)tableName + " t on " + String.valueOf(join) + " where c.SYS_CHANGE_VERSION <= ?";
        if (!logTrigger.a().isSyncOnIncomingBatch()) {
            sql = sql + " and (c.SYS_CHANGE_CONTEXT is null or c.SYS_CHANGE_CONTEXT not like 'SymmetricDS%') ";
        }
        if (!this.p) {
            sql = sql + " order by c.SYS_CHANGE_VERSION";
        }
        return sql;
    }

    protected String a(Row row, String[] columnNames) {
        StringBuilder sb = new StringBuilder();
        if (columnNames != null) {
            for (String name : columnNames) {
                Object object;
                if (sb.length() != 0) {
                    sb.append(",");
                }
                if ((object = row.get((Object)name)) == null) continue;
                if (object instanceof String) {
                    object = object.toString().replace("\\", "\\\\").replace("\"", "\\\"");
                } else if (object instanceof Boolean) {
                    object = (Boolean)object != false ? "1" : "0";
                } else if (object instanceof byte[]) {
                    object = new String(Base64.encodeBase64((byte[])((byte[])object)));
                }
                sb.append("\"").append(object.toString()).append("\"");
            }
        }
        return sb.toString();
    }

    @Override
    public void close() {
        this.o = 0L;
        this.n = 0L;
        this.e = this.f.values();
        this.f.clear();
        if (this.i != null) {
            this.i.close();
            this.i = null;
        }
    }

    @Override
    public long getCurrentId() {
        if (this.n == 0L) {
            this.n = this.b.queryForLong("select CHANGE_TRACKING_CURRENT_VERSION()", new Object[0]);
            if (!this.c()) {
                --this.n;
            }
        }
        return this.n;
    }

    protected boolean c() {
        boolean useCurrentVersion = false;
        if (this.o == 0L && this.n > 1L && this.n != this.l && this.n == this.q) {
            this.z.debug("Checking if changes recorded for current version {}", (Object)this.n);
            long count = 0L;
            count = this.a.getParameterService().is("log.miner.mssql.use.tsql.detect.changes", true) ? this.e() : this.d();
            this.z.debug("Found {} changes recorded for current version {}", (Object)count, (Object)this.n);
            if (count != 0L && count == this.r) {
                useCurrentVersion = true;
                this.z.info("Using current version {} after watching {} rows", (Object)this.n, (Object)count);
            } else {
                this.r = count;
            }
        } else {
            this.r = 0L;
        }
        this.q = this.n;
        return useCurrentVersion;
    }

    protected long d() {
        long count = 0L;
        for (l logTrigger : this.f()) {
            String tableName = logTrigger.b().getSourceTableName();
            String sql = "select count(*) from CHANGETABLE (CHANGES " + tableName + ", ?) as c where c.SYS_CHANGE_VERSION <= ?";
            if (!logTrigger.a().isSyncOnIncomingBatch()) {
                sql = sql + " and (c.SYS_CHANGE_CONTEXT is null or c.SYS_CHANGE_CONTEXT not like 'SymmetricDS%') ";
            }
            count += this.b.queryForLong(sql, new Object[]{this.n - 1L, this.n});
        }
        return count;
    }

    protected long e() {
        long count = 0L;
        HashSet<String> catalogs = new HashSet<String>();
        for (l logTrigger : this.f()) {
            String catalog = logTrigger.b().getSourceCatalogName();
            if (!StringUtils.isNotBlank((CharSequence)catalog)) continue;
            catalogs.add(catalog);
        }
        if (catalogs.isEmpty()) {
            catalogs.add(this.a.getTargetDialect().getPlatform().getDefaultCatalog());
        }
        for (String catalog : catalogs) {
            count += this.b.queryForLong(this.b(catalog), new Object[0]);
        }
        return count;
    }

    @Override
    public long getTotalRowsScanned() {
        return this.o;
    }

    @Override
    public Collection<j> getOpenTransactions() {
        return this.f.values();
    }

    @Override
    public void setLogTriggerMap(Map<String, l> logTriggerMap) {
        this.c = logTriggerMap;
    }

    @Override
    public void setStartId(long id) {
        this.l = id;
        this.n = id;
    }

    @Override
    public void setEndId(long id) {
        this.m = id;
    }

    @Override
    public void setOpenTransactions(Collection<j> openTransactions) {
        this.e = openTransactions;
    }

    protected List<l> f() {
        if (this.d == null) {
            this.d = this.g();
        }
        return this.d;
    }

    protected List<l> g() {
        this.z.debug("Looking up foreign keys to sort {} configured tables", (Object)this.c.size());
        ArrayList<Table> tables = new ArrayList<Table>();
        for (l l2 : this.c.values()) {
            Table table = this.a.getTargetDialect().getPlatform().getTableFromCache(l2.b().getSourceCatalogName(), l2.b().getSourceSchemaName(), l2.b().getSourceTableName(), false);
            if (table != null) {
                tables.add(table);
                continue;
            }
            if (l2.a().getSourceTableName().contains("*")) continue;
            this.z.warn("Unable to find metadata for table {}.{}.{}", new Object[]{l2.a().getSourceCatalogName(), l2.a().getSourceSchemaName(), l2.a().getSourceTableName()});
        }
        TreeMap<String, Table> tablesMap = new TreeMap<String, Table>();
        for (Table table : tables) {
            tablesMap.put(table.getFullyQualifiedTableName(), table);
        }
        if (this.e.size() > 0) {
            this.z.debug("Parsing open transactions");
            this.p = false;
            tables = new ArrayList();
            Map map = this.a.getTriggerRouterService().getHistoryRecords();
            for (j logMarker : this.e) {
                String schema;
                TriggerHistory triggerHist = (TriggerHistory)map.get(Long.parseLong(logMarker.a()));
                if (triggerHist == null) continue;
                String catalog = triggerHist.getSourceCatalogName();
                if (catalog == null) {
                    catalog = this.a.getTargetDialect().getPlatform().getDefaultCatalog();
                }
                if ((schema = triggerHist.getSourceSchemaName()) == null) {
                    schema = this.a.getTargetDialect().getPlatform().getDefaultSchema();
                }
                if ((table = (Table)tablesMap.get(Table.getFullyQualifiedTableName((String)catalog, (String)schema, (String)triggerHist.getSourceTableName()))) == null) continue;
                tables.add(table);
                this.f.put(triggerHist.getFullyQualifiedSourceTableName(), logMarker);
            }
        } else if (this.a.getParameterService().is("log.miner.mssql.use.tsql.detect.changes", true)) {
            this.z.debug("Detecting changes using TSQL statement");
            HashSet<String> hashSet = new HashSet<String>();
            for (Table table : tables) {
                hashSet.add(table.getCatalog());
            }
            tables = new ArrayList();
            for (String catalog : hashSet) {
                String sql = this.a(catalog);
                for (String name : this.b.query(sql, (ISqlRowMapper)new StringMapper(), new Object[0])) {
                    name = name.replaceAll("\\[", "");
                    table = (Table)tablesMap.get(name = name.replaceAll("\\]", ""));
                    if (table == null) continue;
                    tables.add(table);
                }
            }
            this.z.debug("TSQL detected {} tables changed across {} catalogs", (Object)tables.size(), (Object)hashSet.size());
        }
        this.d = new ArrayList<l>();
        for (Table table : Database.sortByForeignKeys(tables)) {
            this.d.add(this.c.get(table.getFullyQualifiedTableName()));
        }
        return this.d;
    }

    protected String a(String catalog) {
        return this.a(catalog, this.l - 1L, this.m, "declare @changes as table (table_name nvarchar(386));\n", "   if @count > 0\n   begin\n      insert into @changes (table_name) select '[" + catalog + "].' + @table_name;\n   end\n", "select * from @changes;");
    }

    protected String b(String catalog) {
        return this.a(catalog, this.n - 1L, this.n, "declare @total bigint\nset @total = 0\n", "set @total = @total + @count\n", "select @total;");
    }

    protected String a(String catalog, long fromId, long toId, String declareStr, String inLoopStr, String returnStr) {
        String escapedCatalog = "[" + catalog + "]";
        return "declare @table_name nvarchar(257);\n" + declareStr + "declare tables cursor\n   local static forward_only read_only for\n   select '[' + s.name + '].[' + o.name + ']' from " + escapedCatalog + ".sys.change_tracking_tables c\n   join " + escapedCatalog + ".sys.objects o on o.object_id = c.object_id\n   join " + escapedCatalog + ".sys.schemas s on s.schema_id = o.schema_id\nopen tables;\nfetch next from tables into @table_name\nwhile @@FETCH_STATUS = 0\nbegin\n   declare @sql nvarchar(256)\n   declare @count int\n   set @sql = 'select @count = count(*) from CHANGETABLE (CHANGES " + escapedCatalog + ".' + @table_name + ', " + fromId + ") c where c.SYS_CHANGE_VERSION <= " + toId + "'\n   exec sp_executesql @sql, N'@count int output', @count output\n" + inLoopStr + "   fetch next from tables into @table_name;\nend\nclose tables;\ndeallocate tables;\n" + returnStr;
    }

    @Override
    public boolean isWaitsForCommit() {
        return false;
    }

    @Override
    public boolean needsIncomingTransactions() {
        return false;
    }

    @Override
    public void setIncomingTransactions(Map<String, i> incomingTransactions) {
    }

    @Override
    public Set<String> getIncomingMinedTransactionIds() {
        return null;
    }

    @Override
    public void setTransaction(ISqlTransaction transaction) {
    }
}

