/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.db.snowflake;

import java.util.List;
import org.jumpmind.db.alter.AddColumnChange;
import org.jumpmind.db.alter.AddTableChange;
import org.jumpmind.db.alter.ColumnChange;
import org.jumpmind.db.alter.ColumnSizeChange;
import org.jumpmind.db.alter.IModelChange;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.Database;
import org.jumpmind.db.platform.IAlterDatabaseInterceptor;
import org.jumpmind.extension.IBuiltInExtensionPoint;

public class SnowflakeAlterDatabaseInterceptor
implements IAlterDatabaseInterceptor,
IBuiltInExtensionPoint {
    public List<IModelChange> intercept(List<IModelChange> detectedChanges, Database currentModel, Database desiredModel) {
        for (IModelChange change : detectedChanges) {
            this.modifyModelChange(change);
        }
        return detectedChanges;
    }

    private void modifyModelChange(IModelChange change) {
        if (change instanceof AddColumnChange) {
            AddColumnChange addColumnChange = (AddColumnChange)change;
            Column column = addColumnChange.getNewColumn();
            this.modifyColumn(column);
        } else if (change instanceof AddTableChange) {
            AddTableChange addTableChange = (AddTableChange)change;
            for (Column column : addTableChange.getNewTable().getColumns()) {
                this.modifyColumn(column);
            }
        } else if (change instanceof ColumnChange) {
            ColumnChange columnChange = (ColumnChange)change;
            Column column = columnChange.getChangedColumn();
            this.modifyColumn(column);
        } else if (change instanceof ColumnSizeChange) {
            ColumnSizeChange columnSizeChange = (ColumnSizeChange)change;
            Column column = columnSizeChange.getChangedColumn();
            this.modifyColumn(column);
        }
    }

    private void modifyColumn(Column column) {
        if (column.getMappedTypeCode() == 3) {
            int precision = Math.min(column.getSizeAsInt(), 38);
            int scale = Math.min(column.getScale(), Math.min(precision, 37));
            column.setSizeAndScale(precision, scale);
        } else if (column.getMappedTypeCode() == 12 || column.getMappedTypeCode() == 1) {
            int size = Math.min(column.getSizeAsInt(), 0x1000000);
            column.setSizeAndScale(size, 0);
        } else if (column.getMappedTypeCode() == -2 || column.getMappedTypeCode() == -3) {
            int size = Math.min(column.getSizeAsInt(), 0x800000);
            column.setSizeAndScale(size, 0);
        }
    }
}

