/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.db.s3;

import com.jumpmind.symmetric.db.s3.a;
import java.util.List;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.security.ISecurityService;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.db.ISymmetricDialect;
import org.jumpmind.symmetric.io.data.IDataWriter;
import org.jumpmind.symmetric.io.data.writer.Conflict;
import org.jumpmind.symmetric.io.data.writer.IDatabaseWriterErrorHandler;
import org.jumpmind.symmetric.io.data.writer.IDatabaseWriterFilter;
import org.jumpmind.symmetric.io.data.writer.ResolvedData;
import org.jumpmind.symmetric.io.data.writer.TransformWriter;
import org.jumpmind.symmetric.io.stage.IStagingManager;
import org.jumpmind.symmetric.load.AbstractDataLoaderFactory;
import org.jumpmind.symmetric.load.IDataLoaderFactory;
import org.jumpmind.symmetric.model.Channel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3DataLoaderFactory
extends AbstractDataLoaderFactory
implements IDataLoaderFactory {
    protected final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private ISecurityService securityService;
    private IStagingManager stagingManager;

    public S3DataLoaderFactory(ISymmetricEngine engine) {
        this.parameterService = engine.getParameterService();
        this.securityService = engine.getSecurityService();
        this.stagingManager = engine.getStagingManager();
    }

    public String getTypeName() {
        return "S3";
    }

    public IDataWriter getDataWriter(String sourceNodeId, Channel channel, ISymmetricDialect symmetricDialect, TransformWriter transformWriter, List<IDatabaseWriterFilter> filters, List<IDatabaseWriterErrorHandler> errorHandlers, List<? extends Conflict> conflictSettings, List<ResolvedData> resolvedData) {
        try {
            return new a(symmetricDialect.getPlatform(), symmetricDialect.getTargetPlatform(), channel, symmetricDialect.getTablePrefix(), null, this.parameterService, this.securityService, this.stagingManager);
        }
        catch (Exception e2) {
            this.log.warn("Failed to create the Amazon S3 database writer.", (Throwable)e2);
            if (e2 instanceof RuntimeException) {
                throw (RuntimeException)e2;
            }
            throw new RuntimeException(e2);
        }
    }

    public boolean isPlatformSupported(IDatabasePlatform platform) {
        return "S3".equals(platform.getName());
    }
}

