/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.db.elasticsearch;

import com.jumpmind.symmetric.console.impl.fT;
import com.jumpmind.symmetric.console.model.TableGroupHier;
import com.jumpmind.symmetric.db.elasticsearch.e;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.support.replication.ReplicationResponse;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.RestHighLevelClientBuilder;
import org.elasticsearch.client.indices.CreateIndexRequest;
import org.elasticsearch.client.indices.GetIndexRequest;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.MatchQueryBuilder;
import org.elasticsearch.index.query.Operator;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptType;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.jumpmind.db.io.DatabaseXmlUtil;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.Database;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.platform.DatabaseInfo;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.security.ISecurityService;
import org.jumpmind.symmetric.io.data.Batch;
import org.jumpmind.symmetric.io.data.CsvData;
import org.jumpmind.symmetric.io.data.DataEventType;
import org.jumpmind.symmetric.io.data.transform.CsvDataHier;
import org.jumpmind.symmetric.io.data.writer.AbstractDatabaseWriter;
import org.jumpmind.symmetric.io.data.writer.DatabaseWriterSettings;
import org.jumpmind.symmetric.io.data.writer.DynamicDefaultDatabaseWriter;
import org.jumpmind.symmetric.io.data.writer.IDatabaseWriterConflictResolver;
import org.jumpmind.symmetric.service.IParameterService;
import org.jumpmind.symmetric.transport.http.SelfSignedX509TrustManager;
import org.jumpmind.util.FormatUtils;
import org.jumpmind.util.Statistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class b
extends DynamicDefaultDatabaseWriter {
    private static final Logger g = LoggerFactory.getLogger(b.class);
    protected RestHighLevelClient a;
    protected boolean b;
    private static final String h = "^(truncate)( table)?.*";
    private static final String i = "^(delete from).*";
    private static final String j = "https";
    protected IParameterService c;
    protected Map<String, List<TableGroupHier>> d;
    protected fT e;
    protected Map<String, Table> f;

    public b(IDatabasePlatform symmetricPlatform, IDatabasePlatform targetPlatform, String prefix, IDatabaseWriterConflictResolver conflictResolver, DatabaseWriterSettings settings, IParameterService parameterService, ISecurityService securityService, Map<String, List<TableGroupHier>> tableGroupHierMap) {
        super(symmetricPlatform, targetPlatform, prefix, conflictResolver, settings);
        this.c = parameterService;
        if (((e)this.targetPlatform).a() != null) {
            this.a = ((e)this.targetPlatform).a();
        } else {
            this.a = this.a(targetPlatform, securityService);
            ((e)this.targetPlatform).a(this.a);
        }
        this.d = tableGroupHierMap;
        this.e = new fT(tableGroupHierMap);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected RestHighLevelClient a(IDatabasePlatform targetPlatform, ISecurityService securityService) {
        String urlEndpoint = ((e)targetPlatform).b();
        URL newUrl = null;
        try {
            newUrl = new URL(urlEndpoint);
        }
        catch (MalformedURLException e2) {
            g.error("Error forming Elasticsearch Client URL: ", (Throwable)e2);
        }
        String loadOnlyPrefix = "target.";
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        String esUser = this.c.getString(loadOnlyPrefix + "db.user");
        if (StringUtils.isNotBlank((CharSequence)esUser)) {
            String esPass = this.c.getString(loadOnlyPrefix + "db.password");
            if (esPass != null && esPass.startsWith("enc:")) {
                esPass = securityService.decrypt(esPass.substring("enc:".length()));
            }
            if (!newUrl.getProtocol().contains(j)) {
                credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(esUser, esPass));
                RestClientBuilder builder = RestClient.builder((HttpHost[])new HttpHost[]{new HttpHost(newUrl.getHost(), newUrl.getPort(), "http")}).setHttpClientConfigCallback(arg_0 -> b.a((CredentialsProvider)credentialsProvider, arg_0));
                RestClient client = builder.build();
                return new RestHighLevelClientBuilder(client).setApiCompatibilityMode(Boolean.valueOf(true)).build();
            }
            try {
                SSLContext context = this.a(securityService);
                credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(esUser, esPass));
                RestClientBuilder builder = RestClient.builder((HttpHost[])new HttpHost[]{new HttpHost(newUrl.getHost(), newUrl.getPort(), j)}).setHttpClientConfigCallback(arg_0 -> b.a((CredentialsProvider)credentialsProvider, context, arg_0));
                RestClient client = builder.build();
                return new RestHighLevelClientBuilder(client).setApiCompatibilityMode(Boolean.valueOf(true)).build();
            }
            catch (Exception e3) {
                g.warn("No trust store found: " + e3.getMessage());
            }
        } else {
            if (newUrl.getProtocol().contains(j)) {
                SSLContext context = this.a(securityService);
                RestClientBuilder builder = RestClient.builder((HttpHost[])new HttpHost[]{new HttpHost(newUrl.getHost(), newUrl.getPort(), j)}).setHttpClientConfigCallback(httpClientBuilder -> httpClientBuilder.setSSLContext(context).setSSLHostnameVerifier((HostnameVerifier)NoopHostnameVerifier.INSTANCE));
                RestClient client = builder.build();
                return new RestHighLevelClientBuilder(client).setApiCompatibilityMode(Boolean.valueOf(true)).build();
            }
            RestClientBuilder builder = RestClient.builder((HttpHost[])new HttpHost[]{HttpHost.create((String)urlEndpoint)});
            RestClient client = builder.build();
            return new RestHighLevelClientBuilder(client).setApiCompatibilityMode(Boolean.valueOf(true)).build();
        }
        RestClientBuilder builder = RestClient.builder((HttpHost[])new HttpHost[]{HttpHost.create((String)urlEndpoint)});
        RestClient client = builder.build();
        return new RestHighLevelClientBuilder(client).setApiCompatibilityMode(Boolean.valueOf(true)).build();
    }

    public void start(Batch batch) {
        super.start(batch);
        this.f = new HashMap<String, Table>();
    }

    public boolean start(Table table) {
        this.e.a(table);
        return super.start(table);
    }

    protected void prepare() {
        if (this.isSymmetricTable(this.targetTable)) {
            super.prepare();
        }
    }

    protected void prepare(String sql, CsvData data) {
    }

    public int prepareAndExecute(String sql, CsvData data) {
        return 1;
    }

    protected SSLContext a(ISecurityService securityService) {
        try {
            SSLContext context = SSLContext.getInstance("TLS");
            KeyStore trustStore = null;
            trustStore = securityService.getTrustStore();
            SelfSignedX509TrustManager trustManager = new SelfSignedX509TrustManager(trustStore);
            KeyManager[] keyManagers = null;
            try {
                keyManagers = securityService.getKeyManagerFactory().getKeyManagers();
            }
            catch (Exception e2) {
                g.warn("No key managers found: " + e2.getMessage());
            }
            context.init(keyManagers, new TrustManager[]{trustManager}, new SecureRandom());
            return context;
        }
        catch (Exception e3) {
            g.warn("No trust store found: " + e3.getMessage());
            return null;
        }
    }

    protected int execute(CsvData data, String[] values) {
        if (this.isSymmetricTable(this.targetTable)) {
            return super.execute(data, values);
        }
        ((Statistics)this.statistics.get(this.batch)).startTimer("LOADMILLIS");
        Table table = this.sourceTable;
        GetIndexRequest validateIndex = new GetIndexRequest(new String[]{table.getNameLowerCase()});
        try {
            if (Boolean.FALSE.equals(this.b)) {
                this.b = this.a.indices().exists(validateIndex, RequestOptions.DEFAULT);
            }
            if (this.b) {
                ReplicationResponse.ShardInfo shardInfo;
                String[] rowData = data.getParsedData("rowData");
                if (data.getDataEventType() == DataEventType.DELETE) {
                    rowData = data.getParsedData("oldData");
                }
                List lookupKeys = this.targetTable.getPrimaryKeyColumnsAsList();
                StringBuilder primaryKeys = new StringBuilder();
                XContentBuilder builder = XContentFactory.jsonBuilder();
                builder.startObject();
                for (int i2 = 0; i2 < table.getColumnCount(); ++i2) {
                    Column column = table.getColumn(i2);
                    builder.field(column.getName().toLowerCase(), rowData[i2]);
                    if (!lookupKeys.contains(column)) continue;
                    primaryKeys.append(rowData[i2]);
                    if (primaryKeys.length() <= 0) continue;
                    primaryKeys.append(",");
                }
                builder.endObject();
                IndexRequest request = new IndexRequest(table.getNameLowerCase()).id(primaryKeys.substring(0, primaryKeys.length() - 1));
                request.source(builder);
                try {
                    IndexResponse response = this.a.index(request, RequestOptions.DEFAULT);
                    shardInfo = response.getShardInfo();
                }
                catch (IOException e2) {
                    throw new IOException("Failed to insert into Elasticsearch", e2);
                }
                if (shardInfo.getFailed() > 0) {
                    for (ReplicationResponse.ShardInfo.Failure failure : shardInfo.getFailures()) {
                        String reasonForFailure = failure.reason();
                        g.error("Failed to insert in ElasticSearch: {} ", (Object)reasonForFailure);
                    }
                    int n2 = 0;
                    return n2;
                }
                int n3 = 1;
                return n3;
            }
            try {
                throw new RuntimeException("Index " + table.getNameLowerCase() + " does not exist.");
            }
            catch (IOException e1) {
                throw new RuntimeException(e1);
            }
        }
        finally {
            ((Statistics)this.statistics.get(this.batch)).stopTimer("LOADMILLIS");
        }
    }

    protected boolean create(CsvData data) {
        String xml = null;
        try {
            Table indexTable = this.sourceTable;
            this.getTargetTransaction().commit();
            ((Statistics)this.statistics.get(this.batch)).startTimer("LOADMILLIS");
            xml = data.getParsedData("rowData")[0];
            g.info("About to create index using the following definition: {}", (Object)xml);
            StringReader reader = new StringReader(xml);
            Database db2 = DatabaseXmlUtil.read((Reader)reader, (boolean)false);
            if (this.writerSettings.isCreateTableAlterCaseToMatchDatabaseDefault()) {
                this.getTargetPlatform().alterCaseToMatchDatabaseDefaultCase(db2);
            }
            this.getTargetPlatform().makePlatformSpecific(db2);
            GetIndexRequest validateIndex = new GetIndexRequest(new String[]{indexTable.getNameLowerCase()});
            if (Boolean.FALSE.equals(this.b)) {
                this.b = this.a.indices().exists(validateIndex, RequestOptions.DEFAULT);
            }
            if (this.b) {
                boolean bl2 = false;
                return bl2;
            }
            CreateIndexRequest createrequest = new CreateIndexRequest(indexTable.getNameLowerCase());
            try {
                this.a.indices().create(createrequest, RequestOptions.DEFAULT);
            }
            catch (IOException e2) {
                g.error("Failed to create in ElasticSearch", (Throwable)e2);
                throw new RuntimeException(e2);
            }
            this.getTargetPlatform().resetCachedTableModel();
            ((Statistics)this.statistics.get(this.batch)).increment("CREATECOUNT");
            boolean bl3 = true;
            return bl3;
        }
        catch (RuntimeException ex2) {
            g.error("Failed to alter table using the following xml: " + xml, (Throwable)ex2);
            throw ex2;
        }
        catch (IOException e1) {
            g.error("Failed to alter in ElasticSearch", (Throwable)e1);
            throw new RuntimeException(e1);
        }
        finally {
            ((Statistics)this.statistics.get(this.batch)).stopTimer("LOADMILLIS");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean sql(CsvData data) {
        try {
            ((Statistics)this.statistics.get(this.batch)).startTimer("LOADMILLIS");
            String[] parsedData = data.getParsedData("rowData");
            String script = parsedData[0];
            List sqlStatements = this.getSqlStatements(script);
            long count = 0L;
            for (String sql : sqlStatements) {
                Object newTransaction = null;
                try {
                    Table table = this.targetTable != null ? this.targetTable : this.sourceTable;
                    sql = FormatUtils.replace((String)"nodeId", (String)this.batch.getTargetNodeId(), (String)sql);
                    if (table == null) continue;
                    sql = FormatUtils.replace((String)"catalogName", (String)this.quoteString(table.getCatalog()), (String)sql);
                    sql = FormatUtils.replace((String)"schemaName", (String)this.quoteString(table.getSchema()), (String)sql);
                    sql = FormatUtils.replace((String)"tableName", (String)this.quoteString(table.getName()), (String)sql);
                    DatabaseInfo info = this.getPlatform().getDatabaseInfo();
                    String quote = this.getPlatform().getDdlBuilder().isDelimitedIdentifierModeOn() ? info.getDelimiterToken() : "";
                    sql = FormatUtils.replace((String)"fullTableName", (String)table.getQualifiedTableName(quote, info.getCatalogSeparator(), info.getSchemaSeparator()), (String)sql);
                    String old38CompatibilityTable = "sym_node";
                    Table indexTable = this.sourceTable;
                    if ("reload".equals(this.batch.getChannelId()) && sql.matches(h) && !table.getNameLowerCase().equals("sym_node")) {
                        DeleteIndexRequest deleterequest = new DeleteIndexRequest(indexTable.getNameLowerCase());
                        CreateIndexRequest createrequest = new CreateIndexRequest(indexTable.getNameLowerCase());
                        try {
                            this.a.indices().delete(deleterequest, RequestOptions.DEFAULT);
                            this.a.indices().create(createrequest, RequestOptions.DEFAULT);
                            continue;
                        }
                        catch (IOException e2) {
                            g.error("Failed to truncate in ElasticSearch", (Throwable)e2);
                            throw new RuntimeException(e2);
                        }
                    }
                    if (!"reload".equals(this.batch.getChannelId()) || !sql.matches(i) || sql.toUpperCase().contains("WHERE") || table.getNameLowerCase().equals("sym_node")) continue;
                    GetIndexRequest validateIndex = new GetIndexRequest(new String[]{indexTable.getNameLowerCase()});
                    try {
                        if (Boolean.FALSE.equals(this.b)) {
                            this.b = this.a.indices().exists(validateIndex, RequestOptions.DEFAULT);
                        }
                        if (!this.b) continue;
                        DeleteByQueryRequest request = new DeleteByQueryRequest(new String[]{indexTable.getNameLowerCase()});
                        request.setQuery((QueryBuilder)QueryBuilders.matchAllQuery());
                        this.a.deleteByQuery(request, RequestOptions.DEFAULT);
                    }
                    catch (IOException e3) {
                        g.error("Failed to purge in ElasticSearch", (Throwable)e3);
                        throw new RuntimeException(e3);
                    }
                }
                finally {
                    if (newTransaction == null) continue;
                    newTransaction.close();
                }
            }
            ((Statistics)this.statistics.get(this.batch)).increment("SQLCOUNT");
            ((Statistics)this.statistics.get(this.batch)).increment("SQLROWSAFFECTEDCOUNT", count);
            boolean bl2 = true;
            return bl2;
        }
        finally {
            ((Statistics)this.statistics.get(this.batch)).stopTimer("LOADMILLIS");
        }
    }

    protected void logFailureDetails(Throwable e2, CsvData data, boolean logLastDmlDetails) {
    }

    protected void allowInsertIntoAutoIncrementColumns(boolean value, Table table) {
    }

    protected Table lookupTableAtTarget(Table sourceTable) {
        if (sourceTable != null && this.isSymmetricTable(sourceTable)) {
            return super.lookupTableAtTarget(sourceTable);
        }
        this.targetTables.put(sourceTable.getTableKey(), sourceTable);
        return sourceTable;
    }

    protected AbstractDatabaseWriter.LoadStatus insert(CsvData data) {
        if (this.e.a(data)) {
            if (this.e.b()) {
                this.f.put(this.targetTable.getFullyQualifiedTableNameLowerCase(), this.targetTable);
            }
            return AbstractDatabaseWriter.LoadStatus.SUCCESS;
        }
        return super.insert(data);
    }

    protected AbstractDatabaseWriter.LoadStatus delete(CsvData data, boolean useConflictDetection) {
        if (this.e.a(data)) {
            if (this.e.b()) {
                this.f.put(this.targetTable.getFullyQualifiedTableNameLowerCase(), this.targetTable);
            }
            return AbstractDatabaseWriter.LoadStatus.SUCCESS;
        }
        Table table = this.sourceTable;
        GetIndexRequest validateIndex = new GetIndexRequest(new String[]{table.getNameLowerCase()});
        ((Statistics)this.statistics.get(this.batch)).startTimer("LOADMILLIS");
        try {
            if (Boolean.FALSE.equals(this.b)) {
                this.b = this.a.indices().exists(validateIndex, RequestOptions.DEFAULT);
            }
            if (this.b) {
                AbstractDatabaseWriter.LoadStatus loadStatus;
                List lookupKeys = null;
                lookupKeys = this.targetTable.getPrimaryKeyColumnsAsList();
                DeleteByQueryRequest request = new DeleteByQueryRequest(new String[]{table.getNameLowerCase()});
                String[] pkData = data.getPkData(table);
                BoolQueryBuilder delQuery = new BoolQueryBuilder();
                for (int i2 = 0; i2 < table.getColumnCount(); ++i2) {
                    for (Column col : lookupKeys) {
                        if (!table.getColumnNames()[i2].equals(col.getName())) continue;
                        String checkId = table.getColumn(i2).getName().toLowerCase();
                        MatchQueryBuilder queryCheck = new MatchQueryBuilder(checkId, (Object)pkData[i2]).operator(Operator.AND);
                        delQuery.must((QueryBuilder)queryCheck);
                    }
                }
                request.setQuery((QueryBuilder)delQuery);
                BulkByScrollResponse response = this.a.deleteByQuery(request, RequestOptions.DEFAULT);
                List bulkFailures = response.getBulkFailures();
                if (bulkFailures.isEmpty()) {
                    loadStatus = AbstractDatabaseWriter.LoadStatus.SUCCESS;
                    return loadStatus;
                }
                loadStatus = AbstractDatabaseWriter.LoadStatus.CONFLICT;
                return loadStatus;
            }
        }
        catch (IOException e2) {
            g.error("Failed to delete in ElasticSearch", (Throwable)e2);
            throw new RuntimeException(e2);
        }
        finally {
            ((Statistics)this.statistics.get(this.batch)).stopTimer("LOADMILLIS");
        }
        return AbstractDatabaseWriter.LoadStatus.CONFLICT;
    }

    protected AbstractDatabaseWriter.LoadStatus update(CsvData data, boolean applyChangesOnly, boolean useConflictDetection) {
        if (this.e.a(data)) {
            if (this.e.b()) {
                this.f.put(this.targetTable.getFullyQualifiedTableNameLowerCase(), this.targetTable);
            }
            return AbstractDatabaseWriter.LoadStatus.SUCCESS;
        }
        Table table = this.sourceTable;
        GetIndexRequest validateIndex = new GetIndexRequest(new String[]{table.getNameLowerCase()});
        StringBuilder updateScript = new StringBuilder();
        ((Statistics)this.statistics.get(this.batch)).startTimer("LOADMILLIS");
        if (table.getName().contains(this.c.getString("sync.table.prefix")) || table.getName().contains("sym")) {
            return super.update(data, applyChangesOnly, useConflictDetection);
        }
        try {
            if (Boolean.FALSE.equals(this.b)) {
                this.b = this.a.indices().exists(validateIndex, RequestOptions.DEFAULT);
            }
            if (this.b) {
                boolean isPkChanged = false;
                ((Statistics)this.statistics.get(this.batch)).startTimer("LOADMILLIS");
                String[] pkData = data.getPkData(table);
                List lookupKeys = null;
                lookupKeys = this.targetTable.getPrimaryKeyColumnsAsList();
                String[] rowData = this.getRowData(data, "rowData");
                String[] oldData = this.getRowData(data, "oldData");
                ArrayList<String> changedColumnNameList = new ArrayList<String>();
                ArrayList<String> changedColumnValueList = new ArrayList<String>();
                ArrayList<Column> changedColumnsList = new ArrayList<Column>();
                for (int i2 = 0; i2 < this.targetTable.getColumnCount(); ++i2) {
                    Column column = this.targetTable.getColumn(i2);
                    if (column == null || !this.doesColumnNeedUpdated(i2, column, data, rowData, oldData, applyChangesOnly)) continue;
                    for (Column col : lookupKeys) {
                        if (!column.getName().equals(col.getName())) continue;
                        isPkChanged = true;
                    }
                    changedColumnNameList.add(column.getName());
                    changedColumnsList.add(column);
                    changedColumnValueList.add(rowData[i2]);
                }
                if (isPkChanged) {
                    this.delete(data, false);
                    this.execute(data, null);
                    AbstractDatabaseWriter.LoadStatus i2 = AbstractDatabaseWriter.LoadStatus.SUCCESS;
                    return i2;
                }
                StringBuilder pk = new StringBuilder();
                HashMap parameters = new HashMap();
                for (int i3 = 0; i3 < table.getColumnCount(); ++i3) {
                    for (Column col : lookupKeys) {
                        if (!table.getColumnNames()[i3].equals(col.getName())) continue;
                        pk.append(pkData[i3] + ",");
                    }
                }
                pk.setLength(pk.length() - 1);
                for (int x2 = 0; x2 < changedColumnValueList.size(); ++x2) {
                    updateScript.append("ctx._source." + ((String)changedColumnNameList.get(x2)).toLowerCase() + " = params." + ((String)changedColumnNameList.get(x2)).toLowerCase());
                    parameters.put(((String)changedColumnNameList.get(x2)).toLowerCase(), changedColumnValueList.get(x2));
                    if (changedColumnValueList.size() <= 1) continue;
                    updateScript.append(";");
                }
                XContentBuilder builder = XContentFactory.jsonBuilder();
                builder.startObject();
                for (int i4 = 0; i4 < table.getColumnCount(); ++i4) {
                    Column column = table.getColumn(i4);
                    builder.field(column.getName().toLowerCase(), rowData[i4]);
                }
                builder.endObject();
                UpdateRequest request = new UpdateRequest(table.getNameLowerCase(), pk.toString());
                request.script(new Script(ScriptType.INLINE, "painless", updateScript.toString(), parameters));
                request.upsert(builder);
                UpdateResponse response = this.a.update(request, RequestOptions.DEFAULT);
                ReplicationResponse.ShardInfo shardInfo = response.getShardInfo();
                if (shardInfo.getFailed() > 0) {
                    for (AbstractDatabaseWriter.LoadStatus failure : shardInfo.getFailures()) {
                        g.error("Elasticsearch update failure: {} ", (Object)failure.reason());
                    }
                    AbstractDatabaseWriter.LoadStatus loadStatus = AbstractDatabaseWriter.LoadStatus.CONFLICT;
                    return loadStatus;
                }
                AbstractDatabaseWriter.LoadStatus loadStatus = AbstractDatabaseWriter.LoadStatus.SUCCESS;
                return loadStatus;
            }
        }
        catch (IOException e2) {
            g.error("Failed to update in ElasticSearch", (Throwable)e2);
            throw new RuntimeException(e2);
        }
        finally {
            ((Statistics)this.statistics.get(this.batch)).stopTimer("LOADMILLIS");
        }
        return AbstractDatabaseWriter.LoadStatus.SUCCESS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void end(Batch batch, boolean inError) {
        for (CsvDataHier hier : this.e.a()) {
            DataEventType eventType = hier.getCsvData().getDataEventType();
            Table rootTable = this.f.get(Table.getFullyQualifiedTableName((String)hier.getCatalogLowerCase(), (String)hier.getSchemaLowerCase(), (String)hier.getTableLowerCase()));
            GetIndexRequest validateIndex = new GetIndexRequest(new String[]{rootTable.getNameLowerCase()});
            ((Statistics)this.statistics.get(batch)).startTimer("LOADMILLIS");
            try {
                ReplicationResponse.ShardInfo shardInfo;
                IndexResponse response;
                IndexRequest request;
                if (Boolean.FALSE.equals(this.b)) {
                    this.b = this.a.indices().exists(validateIndex, RequestOptions.DEFAULT);
                }
                if (!this.b) continue;
                StringBuilder pks = new StringBuilder();
                for (String value : hier.getCsvData().toKeyColumnValuePairs(rootTable).values()) {
                    if (pks.length() > 0) {
                        pks.append(",");
                    }
                    pks.append(value);
                }
                if (eventType.equals((Object)DataEventType.INSERT)) {
                    request = new IndexRequest(rootTable.getNameLowerCase()).id(pks.toString());
                    request.source(this.e.a(this.d, this.targetTables, hier, null));
                    try {
                        response = this.a.index(request, RequestOptions.DEFAULT);
                        shardInfo = response.getShardInfo();
                    }
                    catch (IOException e2) {
                        throw new IOException("Failed to insert into Elasticsearch", e2);
                    }
                    if (shardInfo.getFailed() <= 0) continue;
                    for (ReplicationResponse.ShardInfo.Failure failure : shardInfo.getFailures()) {
                        g.error("Failed to insert in ElasticSearch: {} ", (Object)failure.reason());
                    }
                    continue;
                }
                if (eventType.equals((Object)DataEventType.UPDATE)) {
                    request = new IndexRequest(rootTable.getNameLowerCase()).id(pks.toString());
                    request.source(this.e.a(this.d, this.targetTables, hier, null));
                    response = this.a.index(request, RequestOptions.DEFAULT);
                    shardInfo = response.getShardInfo();
                    if (shardInfo.getFailed() <= 0) continue;
                    for (ReplicationResponse.ShardInfo.Failure failure : shardInfo.getFailures()) {
                        g.error("Elasticsearch update failure: {} ", (Object)failure.reason());
                    }
                    continue;
                }
                if (!eventType.equals((Object)DataEventType.DELETE)) continue;
                request = new DeleteRequest(rootTable.getNameLowerCase(), pks.toString());
                this.a.delete((DeleteRequest)request, RequestOptions.DEFAULT);
            }
            catch (IOException e3) {
                if (eventType.equals((Object)DataEventType.INSERT)) {
                    if (!this.b) {
                        throw new RuntimeException("Index " + rootTable.getNameLowerCase() + " does not exist.");
                    }
                    throw new RuntimeException(e3);
                }
                if (eventType.equals((Object)DataEventType.UPDATE)) {
                    g.error("Failed to update in ElasticSearch", (Throwable)e3);
                    throw new RuntimeException(e3);
                }
                if (!eventType.equals((Object)DataEventType.DELETE)) continue;
                g.error("Failed to delete in ElasticSearch", (Throwable)e3);
                throw new RuntimeException(e3);
            }
            finally {
                ((Statistics)this.statistics.get(batch)).stopTimer("LOADMILLIS");
            }
        }
        super.end(batch, inError);
    }

    private static /* synthetic */ HttpAsyncClientBuilder a(CredentialsProvider credentialsProvider, HttpAsyncClientBuilder httpClientBuilder) {
        return httpClientBuilder.setDefaultCredentialsProvider(credentialsProvider);
    }

    private static /* synthetic */ HttpAsyncClientBuilder a(CredentialsProvider credentialsProvider, SSLContext context, HttpAsyncClientBuilder httpClientBuilder) {
        return httpClientBuilder.setDefaultCredentialsProvider(credentialsProvider).setSSLContext(context).setSSLHostnameVerifier((HostnameVerifier)NoopHostnameVerifier.INSTANCE);
    }
}

