/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.db.elasticsearch;

import com.jumpmind.symmetric.console.impl.fT;
import com.jumpmind.symmetric.console.model.TableGroupHier;
import com.jumpmind.symmetric.db.elasticsearch.e;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.indices.CreateIndexRequest;
import org.elasticsearch.client.indices.GetIndexRequest;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.jumpmind.db.io.DatabaseXmlUtil;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.Database;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.platform.DatabaseInfo;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.util.BinaryEncoding;
import org.jumpmind.security.ISecurityService;
import org.jumpmind.symmetric.io.AbstractBulkDatabaseWriter;
import org.jumpmind.symmetric.io.data.Batch;
import org.jumpmind.symmetric.io.data.CsvData;
import org.jumpmind.symmetric.io.data.DataEventType;
import org.jumpmind.symmetric.io.data.transform.CsvDataHier;
import org.jumpmind.symmetric.io.data.writer.DatabaseWriterSettings;
import org.jumpmind.symmetric.service.IParameterService;
import org.jumpmind.symmetric.transport.http.SelfSignedX509TrustManager;
import org.jumpmind.util.FormatUtils;
import org.jumpmind.util.Statistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class a
extends AbstractBulkDatabaseWriter {
    private static final Logger k = LoggerFactory.getLogger(a.class);
    protected boolean a;
    protected BulkRequest b = new BulkRequest().setRefreshPolicy(WriteRequest.RefreshPolicy.WAIT_UNTIL);
    private static final String l = "^(truncate)( table)?.*";
    private static final String m = "^(delete from).*";
    private static final String n = "https";
    protected IParameterService c;
    protected Map<String, List<TableGroupHier>> d;
    protected fT e;
    protected Map<String, Table> f;
    protected RestHighLevelClient g;
    protected boolean h;
    protected boolean i;
    protected boolean j;

    public a(IDatabasePlatform symmetricPlatform, IDatabasePlatform targetPlatform, String tablePrefix, DatabaseWriterSettings settings, IParameterService parameterService, ISecurityService securityService, Map<String, List<TableGroupHier>> tableGroupHierMap) {
        super(symmetricPlatform, targetPlatform, tablePrefix, settings);
        this.c = parameterService;
        if (((e)this.targetPlatform).a() != null) {
            this.g = ((e)this.targetPlatform).a();
        } else {
            this.g = this.a(targetPlatform, securityService);
            ((e)this.targetPlatform).a(this.g);
        }
        this.d = tableGroupHierMap;
        this.e = new fT(tableGroupHierMap);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected RestHighLevelClient a(IDatabasePlatform targetPlatform, ISecurityService securityService) {
        String urlEndpoint = ((e)targetPlatform).b();
        URL newUrl = null;
        try {
            newUrl = new URL(urlEndpoint);
        }
        catch (MalformedURLException e2) {
            k.error("Error forming Elasticsearch Client URL: ", (Throwable)e2);
        }
        String loadOnlyPrefix = "target.";
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        String esUser = this.c.getString(loadOnlyPrefix + "db.user");
        if (StringUtils.isNotBlank((CharSequence)esUser)) {
            String esPass = this.c.getString(loadOnlyPrefix + "db.password");
            if (esPass != null && esPass.startsWith("enc:")) {
                esPass = securityService.decrypt(esPass.substring("enc:".length()));
            }
            if (!newUrl.getProtocol().contains(n)) {
                credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(esUser, esPass));
                RestClientBuilder builder = RestClient.builder((HttpHost[])new HttpHost[]{new HttpHost(newUrl.getHost(), newUrl.getPort(), "http")}).setHttpClientConfigCallback(arg_0 -> a.a((CredentialsProvider)credentialsProvider, arg_0));
                return new RestHighLevelClient(builder);
            }
            try {
                SSLContext context = this.a(securityService);
                credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(esUser, esPass));
                RestClientBuilder builder = RestClient.builder((HttpHost[])new HttpHost[]{new HttpHost(newUrl.getHost(), newUrl.getPort(), n)}).setHttpClientConfigCallback(arg_0 -> a.a((CredentialsProvider)credentialsProvider, context, arg_0));
                return new RestHighLevelClient(builder);
            }
            catch (Exception e3) {
                k.warn("No trust store found: " + e3.getMessage());
            }
        } else {
            if (newUrl.getProtocol().contains(n)) {
                SSLContext context = this.a(securityService);
                RestClientBuilder builder = RestClient.builder((HttpHost[])new HttpHost[]{new HttpHost(newUrl.getHost(), newUrl.getPort(), n)}).setHttpClientConfigCallback(httpClientBuilder -> httpClientBuilder.setSSLContext(context).setSSLHostnameVerifier((HostnameVerifier)NoopHostnameVerifier.INSTANCE));
                return new RestHighLevelClient(builder);
            }
            RestClientBuilder builder = RestClient.builder((HttpHost[])new HttpHost[]{HttpHost.create((String)urlEndpoint)});
            return new RestHighLevelClient(builder);
        }
        RestClientBuilder builder = RestClient.builder((HttpHost[])new HttpHost[]{HttpHost.create((String)urlEndpoint)});
        return new RestHighLevelClient(builder);
    }

    protected SSLContext a(ISecurityService securityService) {
        try {
            SSLContext context = SSLContext.getInstance("TLS");
            KeyStore trustStore = null;
            trustStore = securityService.getTrustStore();
            SelfSignedX509TrustManager trustManager = new SelfSignedX509TrustManager(trustStore);
            KeyManager[] keyManagers = null;
            try {
                keyManagers = securityService.getKeyManagerFactory().getKeyManagers();
            }
            catch (Exception e2) {
                k.warn("No key managers found: " + e2.getMessage());
            }
            context.init(keyManagers, new TrustManager[]{trustManager}, new SecureRandom());
            return context;
        }
        catch (Exception e3) {
            k.warn("No trust store found: " + e3.getMessage());
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean sql(CsvData data) {
        try {
            ((Statistics)this.statistics.get(this.batch)).startTimer("LOADMILLIS");
            String[] parsedData = data.getParsedData("rowData");
            String script = parsedData[0];
            List sqlStatements = this.getSqlStatements(script);
            long count = 0L;
            for (String sql : sqlStatements) {
                Object newTransaction = null;
                try {
                    GetIndexRequest validateIndex;
                    Table table = this.targetTable != null ? this.targetTable : this.sourceTable;
                    sql = FormatUtils.replace((String)"nodeId", (String)this.batch.getTargetNodeId(), (String)sql);
                    if (table == null) continue;
                    sql = FormatUtils.replace((String)"catalogName", (String)this.quoteString(table.getCatalog()), (String)sql);
                    sql = FormatUtils.replace((String)"schemaName", (String)this.quoteString(table.getSchema()), (String)sql);
                    sql = FormatUtils.replace((String)"tableName", (String)this.quoteString(table.getName()), (String)sql);
                    DatabaseInfo info = this.getPlatform().getDatabaseInfo();
                    String quote = this.getPlatform().getDdlBuilder().isDelimitedIdentifierModeOn() ? info.getDelimiterToken() : "";
                    sql = FormatUtils.replace((String)"fullTableName", (String)table.getQualifiedTableName(quote, info.getCatalogSeparator(), info.getSchemaSeparator()), (String)sql);
                    String old38CompatibilityTable = "sym_node";
                    Table indexTable = this.sourceTable;
                    if ("reload".equals(this.batch.getChannelId()) && sql.matches(l) && !table.getNameLowerCase().equals("sym_node")) {
                        validateIndex = new GetIndexRequest(new String[]{indexTable.getNameLowerCase()});
                        try {
                            if (Boolean.FALSE.equals(this.h)) {
                                this.h = this.g.indices().exists(validateIndex, RequestOptions.DEFAULT);
                            }
                            if (!this.h) continue;
                            DeleteIndexRequest deleterequest = new DeleteIndexRequest(indexTable.getNameLowerCase());
                            CreateIndexRequest createrequest = new CreateIndexRequest(indexTable.getNameLowerCase());
                            try {
                                this.g.indices().delete(deleterequest, RequestOptions.DEFAULT);
                                this.g.indices().create(createrequest, RequestOptions.DEFAULT);
                                continue;
                            }
                            catch (IOException e2) {
                                throw new RuntimeException(e2);
                            }
                        }
                        catch (IOException e3) {
                            k.error("Failed to purge in ElasticSearch", (Throwable)e3);
                            throw new RuntimeException(e3);
                        }
                    }
                    if (!"reload".equals(this.batch.getChannelId()) || !sql.matches(m) || sql.toUpperCase().contains("WHERE") || table.getNameLowerCase().equals("sym_node")) continue;
                    validateIndex = new GetIndexRequest(new String[]{indexTable.getNameLowerCase()});
                    try {
                        if (Boolean.FALSE.equals(this.h)) {
                            this.h = this.g.indices().exists(validateIndex, RequestOptions.DEFAULT);
                        }
                        if (!this.h) continue;
                        DeleteByQueryRequest request = new DeleteByQueryRequest(new String[]{indexTable.getNameLowerCase()});
                        request.setQuery((QueryBuilder)QueryBuilders.matchAllQuery());
                        this.g.deleteByQuery(request, RequestOptions.DEFAULT);
                    }
                    catch (IOException e4) {
                        k.error("Failed to purge in ElasticSearch", (Throwable)e4);
                        throw new RuntimeException(e4);
                    }
                }
                finally {
                    if (newTransaction == null) continue;
                    newTransaction.close();
                }
            }
            ((Statistics)this.statistics.get(this.batch)).increment("SQLCOUNT");
            ((Statistics)this.statistics.get(this.batch)).increment("SQLROWSAFFECTEDCOUNT", count);
            boolean bl2 = true;
            return bl2;
        }
        finally {
            ((Statistics)this.statistics.get(this.batch)).stopTimer("LOADMILLIS");
        }
    }

    protected Table lookupTableAtTarget(Table sourceTable) {
        if (sourceTable != null && this.isSymmetricTable(sourceTable)) {
            return super.lookupTableAtTarget(sourceTable);
        }
        this.targetTables.put(sourceTable.getTableKey(), sourceTable);
        return sourceTable;
    }

    protected void bulkWrite(CsvData data) {
        if (this.e.a(data)) {
            if (this.e.b()) {
                this.f.put(this.targetTable.getFullyQualifiedTableNameLowerCase(), this.targetTable);
            }
            return;
        }
        ((Statistics)this.statistics.get(this.batch)).startTimer("LOADMILLIS");
        DataEventType dataEventType = data.getDataEventType();
        if (this.targetTable == null) {
            this.targetTable = this.sourceTable;
        }
        if (this.targetTable != null || dataEventType.equals((Object)DataEventType.CREATE)) {
            this.a = false;
            if (!this.batch.getBinaryEncoding().equals((Object)BinaryEncoding.NONE) && this.targetTable != null) {
                for (Column column : this.targetTable.getColumns()) {
                    if (!column.isOfBinaryType()) continue;
                    this.a = true;
                    break;
                }
            }
            Table table = this.sourceTable;
            GetIndexRequest validateIndex = new GetIndexRequest(new String[]{table.getNameLowerCase()});
            switch (dataEventType) {
                case INSERT: {
                    try {
                        if (Boolean.FALSE.equals(this.h)) {
                            this.h = this.g.indices().exists(validateIndex, RequestOptions.DEFAULT);
                        }
                        if (this.h) {
                            String[] rowData = data.getParsedData("rowData");
                            if (data.getDataEventType() == DataEventType.DELETE) {
                                rowData = data.getParsedData("oldData");
                            }
                            List lookupKeys = this.targetTable.getPrimaryKeyColumnsAsList();
                            StringBuilder primaryKeys = new StringBuilder();
                            XContentBuilder builder = XContentFactory.jsonBuilder();
                            builder.startObject();
                            for (int i2 = 0; i2 < table.getColumnCount(); ++i2) {
                                Column column = table.getColumn(i2);
                                builder.field(column.getName().toLowerCase(), rowData[i2]);
                                if (!lookupKeys.contains(column)) continue;
                                primaryKeys.append(rowData[i2]);
                                if (primaryKeys.length() <= 0) continue;
                                primaryKeys.append(",");
                            }
                            builder.endObject();
                            this.b.add(new IndexRequest(table.getNameLowerCase()).source(builder).id(primaryKeys.substring(0, primaryKeys.length() - 1)));
                            break;
                        }
                        k.error("Index {} does not exist.", (Object)table.getNameLowerCase());
                        break;
                    }
                    catch (IOException e1) {
                        throw new RuntimeException(e1);
                    }
                }
                default: {
                    this.context.put("bulkWriterToUse", (Object)"default");
                    super.write(data);
                }
            }
        }
        ((Statistics)this.statistics.get(this.batch)).stopTimer("LOADMILLIS");
        ((Statistics)this.statistics.get(this.batch)).increment("STATEMENTCOUNT");
        ((Statistics)this.statistics.get(this.batch)).increment("LINENUMBER");
    }

    protected boolean create(CsvData data) {
        String xml = null;
        try {
            Table indexTable = this.sourceTable;
            this.getTargetTransaction().commit();
            ((Statistics)this.statistics.get(this.batch)).startTimer("LOADMILLIS");
            xml = data.getParsedData("rowData")[0];
            k.info("About to create index using the following definition: {}", (Object)xml);
            StringReader reader = new StringReader(xml);
            Database db2 = DatabaseXmlUtil.read((Reader)reader, (boolean)false);
            if (this.writerSettings.isCreateTableAlterCaseToMatchDatabaseDefault()) {
                this.getTargetPlatform().alterCaseToMatchDatabaseDefaultCase(db2);
            }
            this.getTargetPlatform().makePlatformSpecific(db2);
            GetIndexRequest validateIndex = new GetIndexRequest(new String[]{indexTable.getNameLowerCase()});
            if (Boolean.FALSE.equals(this.h)) {
                this.h = this.g.indices().exists(validateIndex, RequestOptions.DEFAULT);
            }
            if (this.h) {
                boolean bl2 = false;
                return bl2;
            }
            CreateIndexRequest createrequest = new CreateIndexRequest(indexTable.getNameLowerCase());
            try {
                this.g.indices().create(createrequest, RequestOptions.DEFAULT);
            }
            catch (IOException e2) {
                k.error("Failed to create in ElasticSearch", (Throwable)e2);
                throw new RuntimeException(e2);
            }
            this.getTargetPlatform().resetCachedTableModel();
            ((Statistics)this.statistics.get(this.batch)).increment("CREATECOUNT");
            boolean bl3 = true;
            return bl3;
        }
        catch (RuntimeException ex2) {
            k.error("Failed to alter table using the following xml: " + xml, (Throwable)ex2);
            throw ex2;
        }
        catch (IOException e1) {
            k.error("Failed to alter in ElasticSearch", (Throwable)e1);
            throw new RuntimeException(e1);
        }
        finally {
            ((Statistics)this.statistics.get(this.batch)).stopTimer("LOADMILLIS");
        }
    }

    public void start(Batch batch) {
        super.start(batch);
        this.j = false;
        this.f = new HashMap<String, Table>();
    }

    public boolean start(Table table) {
        if (this.e.a(table)) {
            this.i = true;
            this.j = true;
        } else {
            this.i = false;
        }
        return super.start(table);
    }

    public void end(Table table) {
        try {
            if (!this.b.requests().isEmpty()) {
                this.a();
            }
        }
        finally {
            super.end(table);
        }
    }

    protected void a() {
        try {
            this.g.bulk(this.b, RequestOptions.DEFAULT);
        }
        catch (IOException e2) {
            k.error("Failed to use bulk database writer in ElasticSearch", (Throwable)e2);
            throw new RuntimeException(e2);
        }
    }

    public void end(Batch batch, boolean inError) {
        super.end(batch, inError);
        if (this.j) {
            for (CsvDataHier hier : this.e.a()) {
                Table rootTable = this.f.get(Table.getFullyQualifiedTableName((String)hier.getCatalogLowerCase(), (String)hier.getSchemaLowerCase(), (String)hier.getTableLowerCase()));
                GetIndexRequest validateIndex = new GetIndexRequest(new String[]{rootTable.getNameLowerCase()});
                ((Statistics)this.statistics.get(batch)).startTimer("LOADMILLIS");
                try {
                    if (Boolean.FALSE.equals(this.h)) {
                        this.h = this.g.indices().exists(validateIndex, RequestOptions.DEFAULT);
                    }
                    if (!this.h) continue;
                    StringBuilder pks = new StringBuilder();
                    for (String value : hier.getCsvData().toKeyColumnValuePairs(rootTable).values()) {
                        if (pks.length() > 0) {
                            pks.append(",");
                        }
                        pks.append(value);
                    }
                    IndexRequest request = new IndexRequest(rootTable.getNameLowerCase()).id(pks.toString());
                    request.source(this.e.a(this.d, this.targetTables, hier, null));
                    this.b.add(request);
                }
                catch (IOException e2) {
                    if (!this.h) {
                        throw new RuntimeException("Index " + rootTable.getNameLowerCase() + " does not exist.");
                    }
                    throw new RuntimeException(e2);
                }
            }
            if (!this.b.requests().isEmpty()) {
                this.a();
            }
        }
    }

    private static /* synthetic */ HttpAsyncClientBuilder a(CredentialsProvider credentialsProvider, HttpAsyncClientBuilder httpClientBuilder) {
        return httpClientBuilder.setDefaultCredentialsProvider(credentialsProvider);
    }

    private static /* synthetic */ HttpAsyncClientBuilder a(CredentialsProvider credentialsProvider, SSLContext context, HttpAsyncClientBuilder httpClientBuilder) {
        return httpClientBuilder.setDefaultCredentialsProvider(credentialsProvider).setSSLContext(context).setSSLHostnameVerifier((HostnameVerifier)NoopHostnameVerifier.INSTANCE);
    }
}

