/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.db.cosmos;

import com.azure.cosmos.CosmosClient;
import com.azure.cosmos.CosmosContainer;
import com.azure.cosmos.CosmosDatabase;
import com.azure.cosmos.models.CosmosItemRequestOptions;
import com.azure.cosmos.models.CosmosQueryRequestOptions;
import com.azure.cosmos.models.PartitionKey;
import com.azure.cosmos.util.CosmosPagedIterable;
import com.jumpmind.symmetric.console.impl.fT;
import com.jumpmind.symmetric.console.model.TableGroupHier;
import com.jumpmind.symmetric.db.cosmos.e;
import com.jumpmind.symmetric.db.cosmos.h;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Strings;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.symmetric.io.data.Batch;
import org.jumpmind.symmetric.io.data.CsvData;
import org.jumpmind.symmetric.io.data.DataEventType;
import org.jumpmind.symmetric.io.data.transform.CsvDataHier;
import org.jumpmind.symmetric.io.data.writer.AbstractDatabaseWriter;
import org.jumpmind.symmetric.io.data.writer.DatabaseWriterSettings;
import org.jumpmind.symmetric.io.data.writer.DynamicDefaultDatabaseWriter;
import org.jumpmind.symmetric.io.data.writer.IDatabaseWriterConflictResolver;

public class b
extends DynamicDefaultDatabaseWriter {
    protected CosmosClient a = null;
    protected CosmosContainer b = null;
    protected CosmosDatabase c = null;
    protected String d = null;
    protected Map<String, List<TableGroupHier>> e;
    protected fT f;

    public b(IDatabasePlatform symmetricPlatform, IDatabasePlatform targetPlatform, String prefix, IDatabaseWriterConflictResolver conflictResolver, DatabaseWriterSettings settings, Map<String, List<TableGroupHier>> tableGroupHierMap) {
        super(symmetricPlatform, targetPlatform, prefix, conflictResolver, settings);
        this.e = tableGroupHierMap;
        this.f = new fT(tableGroupHierMap);
    }

    public void start(Batch batch) {
        super.start(batch);
        this.a = ((e)this.targetPlatform).a(false);
    }

    public boolean start(Table table) {
        this.f.a(table);
        if (this.isSymmetricTable(table)) {
            return super.start(table);
        }
        this.c = this.a.getDatabase(table.getCatalog() == null ? ((e)this.targetPlatform).getDefaultCatalog() : table.getCatalog());
        this.b = this.c.getContainer(table.getName());
        this.d = h.a(this.b, null);
        return super.start(table);
    }

    protected AbstractDatabaseWriter.LoadStatus insert(CsvData data) {
        if (this.f.a(data)) {
            return AbstractDatabaseWriter.LoadStatus.SUCCESS;
        }
        if (this.isSymmetricTable(this.targetTable)) {
            return super.insert(data);
        }
        Map<String, Object> dataMap = this.c(data);
        if (this.d != null) {
            this.b.createItem(dataMap, new PartitionKey(dataMap.get(this.d)), new CosmosItemRequestOptions());
        } else {
            this.b.createItem(dataMap, new CosmosItemRequestOptions());
        }
        return AbstractDatabaseWriter.LoadStatus.SUCCESS;
    }

    protected AbstractDatabaseWriter.LoadStatus update(CsvData data, boolean applyChangesOnly, boolean useConflictDetection) {
        if (this.f.a(data)) {
            return AbstractDatabaseWriter.LoadStatus.SUCCESS;
        }
        if (this.isSymmetricTable(this.targetTable)) {
            return super.update(data, applyChangesOnly, useConflictDetection);
        }
        Map<String, Object> dataMap = this.c(data);
        if (dataMap != null && !dataMap.containsKey("id")) {
            this.a(dataMap);
        }
        if (this.d != null) {
            this.b.upsertItem(dataMap, new PartitionKey(dataMap.get(this.d)), new CosmosItemRequestOptions());
        } else {
            this.b.upsertItem(dataMap, new CosmosItemRequestOptions());
        }
        return AbstractDatabaseWriter.LoadStatus.SUCCESS;
    }

    protected AbstractDatabaseWriter.LoadStatus delete(CsvData data, boolean useConflictDetection) {
        if (this.f.a(data)) {
            return AbstractDatabaseWriter.LoadStatus.SUCCESS;
        }
        if (this.isSymmetricTable(this.targetTable)) {
            return super.delete(data, useConflictDetection);
        }
        Map<String, Object> deleteMap = this.b(data);
        if (deleteMap != null && !deleteMap.containsKey("id")) {
            this.a(deleteMap);
        }
        if (this.d != null) {
            String id = (String)deleteMap.get("id");
            this.b.deleteItem(id, new PartitionKey(deleteMap.get(this.d)), new CosmosItemRequestOptions());
        } else {
            this.b.deleteItem(this.b(data), new CosmosItemRequestOptions());
        }
        return AbstractDatabaseWriter.LoadStatus.SUCCESS;
    }

    protected void a(Map<String, Object> dataMap) {
        String sql = "select * from c where c." + this.d + " = '" + String.valueOf(dataMap.get(this.d)) + "'";
        CosmosPagedIterable items = this.b.queryItems(sql, new CosmosQueryRequestOptions(), Object.class);
        for (Object id : items) {
            dataMap.put("id", ((Map)id).get("id"));
        }
    }

    protected String a(CsvData data) {
        Map pkValues = data.toKeyColumnValuePairs(this.targetTable);
        if (pkValues != null && pkValues.size() > 0) {
            return (String)pkValues.values().iterator().next();
        }
        return null;
    }

    protected Map<String, Object> b(CsvData data) {
        Map<String, Object> newMap = data.toColumnNameValuePairs(this.targetTable.getColumnNames(), "oldData").entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e2 -> e2.getValue()));
        return newMap;
    }

    protected Map<String, Object> c(CsvData data) {
        Map<String, Object> newMap = data.toColumnNameValuePairs(this.targetTable.getColumnNames(), "rowData").entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e2 -> e2.getValue()));
        return newMap;
    }

    public void end(Batch batch, boolean inError) {
        for (CsvDataHier hier : this.f.a()) {
            Map<String, Object> dataMap = this.a(hier, null);
            DataEventType eventType = hier.getCsvData().getDataEventType();
            if (eventType.equals((Object)DataEventType.INSERT)) {
                if (this.d != null) {
                    this.b.createItem(dataMap, new PartitionKey(dataMap.get(this.d)), new CosmosItemRequestOptions());
                    continue;
                }
                this.b.createItem(dataMap, new CosmosItemRequestOptions());
                continue;
            }
            if (eventType.equals((Object)DataEventType.UPDATE)) {
                if (dataMap != null && !dataMap.containsKey("id")) {
                    this.a(dataMap);
                }
                if (this.d != null) {
                    this.b.upsertItem(dataMap, new PartitionKey(dataMap.get(this.d)), new CosmosItemRequestOptions());
                    continue;
                }
                this.b.upsertItem(dataMap, new CosmosItemRequestOptions());
                continue;
            }
            if (!eventType.equals((Object)DataEventType.DELETE)) continue;
        }
        super.end(batch, inError);
    }

    private Map<String, Object> a(CsvDataHier hier, Table parentTable) {
        List children;
        List<TableGroupHier> tableGroupHiers;
        boolean isDelete;
        boolean isUpdate;
        boolean isInsert;
        DataEventType eventType;
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        Table table = null;
        for (Table targetTable : this.targetTables.values()) {
            if (!Strings.CI.equals(targetTable.getCatalog(), hier.getCatalog()) || !Strings.CI.equals(targetTable.getSchema(), hier.getSchema()) || !Strings.CI.equals(targetTable.getName(), hier.getTable())) continue;
            table = targetTable;
            break;
        }
        if ((eventType = hier.getCsvData().getDataEventType()) != null) {
            isInsert = eventType.equals((Object)DataEventType.INSERT);
            isUpdate = eventType.equals((Object)DataEventType.UPDATE);
            isDelete = eventType.equals((Object)DataEventType.DELETE);
        } else {
            String oldData = hier.getCsvData().getCsvData("oldData");
            String newData = hier.getCsvData().getCsvData("rowData");
            isInsert = oldData == null && newData != null;
            isUpdate = oldData != null && newData != null;
            boolean bl2 = isDelete = oldData != null && newData == null;
        }
        if (isInsert || isUpdate) {
            dataMap.putAll(hier.getCsvData().toColumnNameValuePairs(table.getColumnNames(), "rowData").entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e2 -> e2.getValue())));
        } else if (isDelete) {
            // empty if block
        }
        if (parentTable != null && (tableGroupHiers = this.e.get(table.getFullyQualifiedTableNameLowerCase())) != null && !tableGroupHiers.isEmpty()) {
            for (String pk : tableGroupHiers.get(0).getParsedParentColumnNames()) {
                dataMap.remove(pk.toUpperCase());
            }
        }
        if ((children = hier.getChildren()) != null) {
            for (CsvDataHier child : children) {
                Map<String, Object> childDataMap = this.a(child, table);
                Object existingChildData = dataMap.get(child.getTable());
                String relationType = child.getRelationType();
                if (relationType != null && relationType.equals(TableGroupHier.RelationType.ARRAY.name())) {
                    if (existingChildData instanceof List) {
                        ((List)existingChildData).add(childDataMap);
                        dataMap.put(child.getTable(), existingChildData);
                        continue;
                    }
                    ArrayList<Object> childDataList = new ArrayList<Object>();
                    if (existingChildData != null) {
                        childDataList.add(existingChildData);
                    }
                    childDataList.add(childDataMap);
                    dataMap.put(child.getTable(), childDataList);
                    continue;
                }
                dataMap.put(child.getTable(), childDataMap);
            }
        }
        return dataMap;
    }
}

