/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.db.bulk;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.util.BinaryEncoding;
import org.jumpmind.symmetric.io.AbstractBulkDatabaseWriter;
import org.jumpmind.symmetric.io.data.CsvData;
import org.jumpmind.symmetric.io.data.DataEventType;
import org.jumpmind.symmetric.io.data.writer.DatabaseWriterSettings;
import org.jumpmind.symmetric.io.data.writer.IDatabaseWriterFilter;
import org.jumpmind.symmetric.io.stage.IStagedResource;
import org.jumpmind.symmetric.io.stage.IStagingManager;
import org.jumpmind.util.Statistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class p
extends AbstractBulkDatabaseWriter {
    private IDatabasePlatform s;
    protected Logger a;
    protected IStagingManager b;
    protected IStagedResource c;
    protected IStagedResource d;
    protected Table e = null;
    protected boolean f;
    protected String g;
    protected ArrayList<String> h;
    protected String i;
    protected String j;
    protected String k;
    protected String l;
    protected String m;
    protected String n;
    protected String o;
    protected int p = 0;
    protected Map<String, Integer> q = new HashMap<String, Integer>();
    protected boolean r = true;

    public p(IDatabasePlatform symmetricPlatform, IDatabasePlatform targetPlatform, IStagingManager stagingManager, String tablePrefix, String sqlLoaderCommand, String sqlLoaderOptions, String dbUser, String dbPassword, String dbUrl, String ezConnectString, String sqlLoaderInfileCharset, String fieldTerminator, String lineTerminator, DatabaseWriterSettings settings, boolean delimitTokens, List<IDatabaseWriterFilter> filters) {
        super(symmetricPlatform, targetPlatform, tablePrefix, settings);
        this.s = targetPlatform;
        this.a = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
        this.b = stagingManager;
        this.g = sqlLoaderCommand;
        this.i = dbUser;
        this.j = dbPassword;
        this.k = dbUrl;
        this.l = (String)StringUtils.defaultIfBlank((CharSequence)ezConnectString, (CharSequence)this.a(dbUrl));
        this.m = (String)StringUtils.defaultIfBlank((CharSequence)sqlLoaderInfileCharset, null);
        this.n = fieldTerminator;
        this.o = lineTerminator;
        this.r = delimitTokens;
        this.h = new ArrayList();
        if (StringUtils.isNotBlank((CharSequence)sqlLoaderOptions)) {
            for (String option : sqlLoaderOptions.split(" ")) {
                this.h.add(option);
            }
        }
        if (StringUtils.isBlank((CharSequence)this.g)) {
            String oracleHome = System.getenv("ORACLE_HOME");
            if (StringUtils.isNotBlank((CharSequence)oracleHome)) {
                this.g = oracleHome + File.separator + "bin" + File.separator + "sqlldr" + (SystemUtils.IS_OS_WINDOWS ? ".exe" : "");
            } else {
                File cmdFile = new File("tools/oracle/" + (SystemUtils.IS_OS_WINDOWS ? "instantclient/sqlldr.exe" : "sqlloader"));
                this.g = cmdFile.canExecute() ? cmdFile.getAbsolutePath() : "sqlldr";
            }
        }
        this.writerSettings.setDatabaseWriterFilters(filters);
    }

    public boolean start(Table table) {
        this.e = table;
        if (super.start(table) && this.targetTable != null) {
            this.f = false;
            if (this.batch.getBinaryEncoding() != BinaryEncoding.NONE) {
                for (Column column : this.targetTable.getColumns()) {
                    if (!column.isOfBinaryType()) continue;
                    this.f = true;
                    break;
                }
            }
            if (this.c == null && !this.isFallBackToDefault()) {
                this.c = this.b.create(new Object[]{"bulkloaddir", this.getBatch().getBatchId()});
            }
            this.q.clear();
        }
        return true;
    }

    protected void a() {
        long batchId = this.getBatch().getBatchId();
        this.d = this.b.create(new Object[]{"bulkloaddir", StringUtils.leftPad((String)(batchId + "-ctl"), (int)14, (String)"0")});
        try {
            String valueEscapedBy;
            OutputStream out = this.d.getOutputStream();
            out.write("LOAD DATA\n".getBytes(Charset.defaultCharset()));
            if (StringUtils.isNotEmpty((CharSequence)this.m)) {
                out.write(("CHARACTERSET " + this.m + "\n").getBytes(Charset.defaultCharset()));
            }
            out.write(this.d().getBytes(Charset.defaultCharset()));
            String quote = "";
            if (this.r) {
                quote = this.s.getDdlBuilder().getDatabaseInfo().getDelimiterToken();
            }
            out.write(("APPEND INTO TABLE " + this.a(this.targetTable, quote) + "\n").getBytes(Charset.defaultCharset()));
            out.write(("FIELDS TERMINATED BY '" + this.n + "'\n").getBytes(Charset.defaultCharset()));
            String valueEnclosedBy = this.c();
            if (StringUtils.isNotBlank((CharSequence)valueEnclosedBy)) {
                out.write((valueEnclosedBy + "\n").getBytes(Charset.defaultCharset()));
            }
            if (StringUtils.isNotBlank((CharSequence)(valueEscapedBy = this.b()))) {
                out.write((valueEscapedBy + "\n").getBytes(Charset.defaultCharset()));
            }
            out.write(this.e().getBytes(Charset.defaultCharset()));
            out.write("TRAILING NULLCOLS\n".getBytes(Charset.defaultCharset()));
            StringBuilder columns = new StringBuilder("(");
            int index = 0;
            for (Column column : this.targetTable.getColumns()) {
                if (index++ > 0) {
                    columns.append(", ");
                }
                columns.append(quote).append(column.getName()).append(quote);
                int type = column.getMappedTypeCode();
                if (this.s.isLob(column) || column.isOfBinaryType()) {
                    columns.append(" CHAR(" + String.valueOf(this.q.get(column.getName())) + ")");
                    continue;
                }
                if (column.isOfTextType() && column.getSizeAsInt() > 0) {
                    columns.append(" CHAR(" + column.getSize() + ")");
                    continue;
                }
                if (type == 93 || type == 91) {
                    columns.append(" TIMESTAMP 'YYYY-MM-DD HH24:MI:SS.FF9'");
                    continue;
                }
                if (!column.isTimestampWithTimezone()) continue;
                String scale = column.getScale() > 0 ? "(" + column.getScale() + ")" : "";
                String local = column.getMappedTypeCode() == -102 ? "LOCAL " : "";
                columns.append(" TIMESTAMP" + scale + " WITH " + local + "TIME ZONE 'YYYY-MM-DD HH24:MI:SS.FF9 TZH:TZM'");
            }
            columns.append(")\n");
            out.write(columns.toString().getBytes(Charset.defaultCharset()));
            this.d.close();
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
    }

    protected String b() {
        return "";
    }

    protected String c() {
        return "";
    }

    protected String a(Table targetTable, String delimiterToken) {
        return targetTable.getQualifiedTableName(delimiterToken, ".", ".") + "\n";
    }

    protected String d() {
        return "INFILE '" + this.c.getFile().getName() + "' \"str '" + this.o + "'\"\n";
    }

    protected String e() {
        return "";
    }

    public void end(Table table) {
        try {
            this.f();
        }
        finally {
            super.end(table);
        }
    }

    protected void bulkWrite(CsvData data) {
        if (this.filterBefore(data)) {
            DataEventType dataEventType = data.getDataEventType();
            switch (dataEventType) {
                case INSERT: {
                    ((Statistics)this.statistics.get(this.batch)).startTimer("LOADMILLIS");
                    try {
                        OutputStream out = this.c.getOutputStream();
                        String[] parsedData = data.getParsedData("rowData");
                        Column[] columns = this.targetTable.getColumns();
                        for (int i2 = 0; i2 < parsedData.length; ++i2) {
                            if (parsedData[i2] != null) {
                                byte[] bytesToWrite = null;
                                if (this.f && columns[i2].isOfBinaryType()) {
                                    if (this.batch.getBinaryEncoding() == BinaryEncoding.BASE64) {
                                        bytesToWrite = Base64.decodeBase64((byte[])parsedData[i2].getBytes(Charset.defaultCharset()));
                                    } else if (this.batch.getBinaryEncoding() == BinaryEncoding.HEX) {
                                        bytesToWrite = Hex.decodeHex((char[])parsedData[i2].toCharArray());
                                    }
                                } else {
                                    bytesToWrite = parsedData[i2].getBytes(Charset.defaultCharset());
                                }
                                if (bytesToWrite != null) {
                                    int oldLength;
                                    out.write(bytesToWrite);
                                    int newLength = bytesToWrite.length;
                                    Integer o2 = this.q.get(columns[i2].getName());
                                    int n2 = oldLength = o2 == null ? 0 : o2;
                                    if (newLength > oldLength) {
                                        this.q.put(columns[i2].getName(), newLength);
                                    }
                                }
                            }
                            if (i2 + 1 >= parsedData.length) continue;
                            out.write(this.n.getBytes(Charset.defaultCharset()));
                        }
                        out.write(this.o.getBytes(Charset.defaultCharset()));
                        ++this.p;
                        break;
                    }
                    catch (Exception ex2) {
                        throw this.getPlatform().getSqlTemplate().translate((Throwable)ex2);
                    }
                    finally {
                        ((Statistics)this.statistics.get(this.batch)).stopTimer("LOADMILLIS");
                        ((Statistics)this.statistics.get(this.batch)).increment("STATEMENTCOUNT");
                        ((Statistics)this.statistics.get(this.batch)).increment("LINENUMBER");
                        ((Statistics)this.statistics.get(this.batch)).stopTimer("LOADMILLIS");
                    }
                }
                default: {
                    this.f();
                    this.writeDefault(data);
                }
            }
            this.filterAfter(data);
        }
    }

    protected void f() {
        block13: {
            boolean inError = false;
            if (this.p > 0 && this.c != null) {
                this.c.close();
                this.a();
                ((Statistics)this.statistics.get(this.batch)).startTimer("LOADMILLIS");
                try {
                    File parentDir = this.d.getFile().getParentFile();
                    ArrayList<String> cmd = new ArrayList<String>();
                    cmd.add(this.g);
                    cmd.add("userid=" + this.i + "/" + this.j + this.l);
                    cmd.add("control=" + this.d.getFile().getName());
                    cmd.addAll(this.h);
                    if (this.a.isDebugEnabled()) {
                        this.a.debug("Working dir: {} ", (Object)parentDir.getAbsolutePath());
                        this.a.debug("Running: {} ", cmd);
                    }
                    ProcessBuilder pb = new ProcessBuilder(cmd);
                    if (SystemUtils.IS_OS_WINDOWS && this.g.toLowerCase().contains("instantclient")) {
                        File dllDirectory;
                        String path = (String)StringUtils.defaultIfEmpty((CharSequence)pb.environment().get("PATH"), (CharSequence)"");
                        File sqlLoaderDirectory = new File(this.g).getParentFile();
                        if (sqlLoaderDirectory != null && (dllDirectory = sqlLoaderDirectory.getParentFile()) != null) {
                            pb.environment().put("PATH", dllDirectory.getAbsolutePath() + File.pathSeparator + path);
                            this.a.debug("Set PATH={}", (Object)pb.environment().get("PATH"));
                        }
                    }
                    pb.directory(parentDir);
                    pb.redirectErrorStream(true);
                    Process process = pb.start();
                    BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                    String line = null;
                    while ((line = reader.readLine()) != null) {
                        if (line.equals("")) continue;
                        this.a.info("{}: {}", (Object)this.g(), (Object)line);
                    }
                    int rc = process.waitFor();
                    if (rc == 2) {
                        throw new RuntimeException("All or some rows were rejected.");
                    }
                    if (rc != 0) {
                        throw new RuntimeException("Process builder returned " + rc);
                    }
                    break block13;
                }
                catch (Exception e2) {
                    inError = true;
                    if (e2 instanceof RuntimeException) {
                        throw (RuntimeException)e2;
                    }
                    throw new RuntimeException(e2);
                }
                finally {
                    ((Statistics)this.statistics.get(this.batch)).stopTimer("LOADMILLIS");
                    this.a(inError);
                    this.p = 0;
                }
            }
            this.a(inError);
        }
    }

    protected void a(boolean inError) {
        if (this.c != null) {
            this.c.delete();
            this.c = null;
        }
        if (this.d != null) {
            if (!inError) {
                File absFile = this.d.getFile().getAbsoluteFile();
                try {
                    new File(absFile.getPath().replace(".create", ".bad")).delete();
                    new File(absFile.getPath().replace(".create", ".log")).delete();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.d.delete();
            }
            this.d = null;
        }
    }

    protected final String a(String dbUrl) {
        Object ezConnect = null;
        int index = dbUrl.indexOf("@//");
        if (index != -1) {
            ezConnect = dbUrl.substring(index);
        } else {
            index = dbUrl.toUpperCase().replace(" ", "").indexOf("HOST=");
            if (index != -1) {
                dbUrl = dbUrl.replace(" ", "");
                String database = (String)StringUtils.defaultIfBlank((CharSequence)this.a(dbUrl, "SERVICE_NAME"), (CharSequence)this.a(dbUrl, "SID"));
                ezConnect = "@//" + this.a(dbUrl, "HOST") + ":" + this.a(dbUrl, "PORT") + "/" + database;
            } else {
                ezConnect = com.jumpmind.symmetric.db.bulk.p.b(dbUrl);
            }
        }
        return ezConnect;
    }

    protected static String b(String dbUrl) {
        String ret = null;
        int index = dbUrl.indexOf("@");
        if (index != -1) {
            ret = dbUrl.substring(index).replace("@", "@//");
            String[] array = ret.split(":", 2);
            StringBuilder sb = new StringBuilder(array[0]).append(":");
            int indexOfColon = array[1].indexOf(":");
            int indexOfSlash = array[1].indexOf("/");
            if (indexOfSlash > -1 && indexOfColon > -1 && indexOfSlash < indexOfColon) {
                sb.append(array[1]);
            } else if (indexOfSlash > -1) {
                sb.append(array[1]);
            } else if (indexOfColon > -1) {
                sb.append(array[1].substring(0, indexOfColon)).append("/").append(array[1].substring(indexOfColon + 1));
            }
            index = ret.lastIndexOf(":");
            ret = sb.toString();
        }
        return ret;
    }

    protected String a(String dbUrl, String name) {
        String value = "";
        int startIndex = dbUrl.toUpperCase().indexOf(name + "=");
        if (startIndex != -1) {
            int endIndex = dbUrl.indexOf(")", startIndex);
            value = dbUrl.substring(startIndex + name.length() + 1, endIndex);
        }
        return value;
    }

    protected String g() {
        return "SQL*Loader";
    }
}

