/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.db.bulk;

import java.io.OutputStream;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.platform.DatabaseInfo;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.sql.JdbcSqlTransaction;
import org.jumpmind.db.util.BinaryEncoding;
import org.jumpmind.symmetric.io.AbstractBulkDatabaseWriter;
import org.jumpmind.symmetric.io.data.CsvData;
import org.jumpmind.symmetric.io.data.DataEventType;
import org.jumpmind.symmetric.io.data.writer.DatabaseWriterSettings;
import org.jumpmind.symmetric.io.stage.IStagedResource;
import org.jumpmind.symmetric.io.stage.IStagingManager;
import org.jumpmind.util.Statistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class n
extends AbstractBulkDatabaseWriter {
    private static final Logger m = LoggerFactory.getLogger(n.class);
    protected int a;
    protected IStagingManager b;
    protected IStagedResource c;
    protected String d = "\r\n";
    protected String e = "||";
    protected int f = 0;
    protected boolean g;
    protected String h;
    protected boolean i;
    protected boolean j;
    protected Table k = null;
    protected Table l = null;

    public n(IDatabasePlatform symmetricPlatform, IDatabasePlatform tar, String tablePrefix, IStagingManager stagingManager, int maxRowsBeforeFlush, boolean fireTriggers, String uncPath, String fieldTerminator, String rowTerminator, DatabaseWriterSettings writerSettings) {
        super(symmetricPlatform, tar, tablePrefix, writerSettings);
        this.a = maxRowsBeforeFlush;
        this.b = stagingManager;
        this.g = fireTriggers;
        if (fieldTerminator != null && fieldTerminator.length() > 0) {
            this.e = fieldTerminator;
        }
        if (rowTerminator != null && rowTerminator.length() > 0) {
            this.d = rowTerminator;
        }
        this.h = uncPath;
        m.debug("Initialized with maxRowsBeforeFlush={}, fireTriggers={}, fieldTerminator={}, rowTerminator={}, uncPath={}", new Object[]{maxRowsBeforeFlush, fireTriggers, fieldTerminator, rowTerminator, uncPath});
    }

    public boolean start(Table table) {
        this.k = table;
        if (super.start(table)) {
            if (this.isFallBackToDefault()) {
                return true;
            }
            this.i = false;
            if (this.batch.getBinaryEncoding() != BinaryEncoding.HEX && this.targetTable != null) {
                for (Column column : this.targetTable.getColumns()) {
                    if (!column.isOfBinaryType()) continue;
                    this.i = true;
                    break;
                }
            }
            if (this.sourceTable != null && this.targetTable != null) {
                this.l = this.getPlatform(table).getTableFromCache(this.sourceTable.getCatalog(), this.sourceTable.getSchema(), this.sourceTable.getName(), false);
                String[] csvNames = this.targetTable.getColumnNames();
                String[] columnNames = this.l.getColumnNames();
                this.j = false;
                for (int i2 = 0; i2 < csvNames.length; ++i2) {
                    if (csvNames[i2].equals(columnNames[i2])) continue;
                    this.j = true;
                    break;
                }
            }
            if (this.c == null) {
                this.b();
            }
        }
        return true;
    }

    public void end(Table table) {
        try {
            if (this.isFallBackToDefault()) {
                return;
            }
            this.a();
            if (this.c != null) {
                this.c.close();
                this.c.delete();
            }
        }
        finally {
            super.end(table);
        }
    }

    protected void bulkWrite(CsvData data) {
        DataEventType dataEventType = data.getDataEventType();
        switch (dataEventType) {
            case INSERT: {
                ((Statistics)this.statistics.get(this.batch)).startTimer("LOADMILLIS");
                try {
                    int i2;
                    String[] parsedData = data.getParsedData("rowData");
                    if (this.i) {
                        Column[] columns = this.targetTable.getColumns();
                        for (i2 = 0; i2 < columns.length; ++i2) {
                            if (!columns[i2].isOfBinaryType() || this.batch.getBinaryEncoding() != BinaryEncoding.BASE64 || parsedData[i2] == null) continue;
                            parsedData[i2] = new String(Hex.encodeHex((byte[])Base64.decodeBase64((byte[])parsedData[i2].getBytes(Charset.defaultCharset()))));
                        }
                    }
                    OutputStream out = this.c.getOutputStream();
                    if (this.j) {
                        Map mapData = data.toColumnNameValuePairs(this.targetTable.getColumnNames(), "rowData");
                        String[] columnNames = this.l.getColumnNames();
                        for (int i3 = 0; i3 < columnNames.length; ++i3) {
                            String columnData = (String)mapData.get(columnNames[i3]);
                            if (columnData != null) {
                                out.write(columnData.getBytes(Charset.defaultCharset()));
                            }
                            if (i3 + 1 >= columnNames.length) continue;
                            out.write(this.e.getBytes(Charset.defaultCharset()));
                        }
                    } else {
                        for (i2 = 0; i2 < parsedData.length; ++i2) {
                            if (parsedData[i2] != null) {
                                out.write(parsedData[i2].getBytes(Charset.defaultCharset()));
                            }
                            if (i2 + 1 >= parsedData.length) continue;
                            out.write(this.e.getBytes(Charset.defaultCharset()));
                        }
                    }
                    out.write(this.d.getBytes(Charset.defaultCharset()));
                    ++this.f;
                    break;
                }
                catch (Exception ex2) {
                    throw this.getPlatform(this.k).getSqlTemplate().translate((Throwable)ex2);
                }
                finally {
                    ((Statistics)this.statistics.get(this.batch)).stopTimer("LOADMILLIS");
                    ((Statistics)this.statistics.get(this.batch)).increment("STATEMENTCOUNT");
                    ((Statistics)this.statistics.get(this.batch)).increment("LINENUMBER");
                }
            }
            default: {
                this.a();
                this.writeDefault(data);
            }
        }
        if (this.f >= this.a) {
            this.a();
        }
    }

    protected void a() {
        if (this.f > 0 && this.c != null) {
            this.c.close();
            ((Statistics)this.statistics.get(this.batch)).startTimer("LOADMILLIS");
            Object filename = StringUtils.isEmpty((CharSequence)this.h) ? this.c.getFile().getAbsolutePath() : this.h + "\\" + this.c.getFile().getName();
            try {
                DatabaseInfo dbInfo = this.getPlatform().getDatabaseInfo();
                String quote = dbInfo.getDelimiterToken();
                String catalogSeparator = dbInfo.getCatalogSeparator();
                String schemaSeparator = dbInfo.getSchemaSeparator();
                JdbcSqlTransaction jdbcTransaction = (JdbcSqlTransaction)this.getTargetTransaction();
                Connection c2 = jdbcTransaction.getConnection();
                Object rowTerminatorString = "";
                if (!this.d.equals("\n") && !this.d.equals("\r\n")) {
                    rowTerminatorString = ", ROWTERMINATOR='" + StringEscapeUtils.escapeJava((String)this.d) + "'";
                }
                String sql = String.format("BULK INSERT " + this.getTargetTable().getQualifiedTableName(quote, catalogSeparator, schemaSeparator) + " FROM '" + (String)filename, new Object[0]) + "' WITH (DATAFILETYPE='widechar', FIELDTERMINATOR='" + StringEscapeUtils.escapeJava((String)this.e) + "', KEEPIDENTITY" + (this.g ? ", FIRE_TRIGGERS" : "") + (String)rowTerminatorString + ");";
                Statement stmt = c2.createStatement();
                m.debug("Running {}", (Object)sql);
                stmt.execute(sql);
                stmt.close();
                this.f = 0;
            }
            catch (SQLException ex2) {
                throw this.getPlatform().getSqlTemplate().translate((Throwable)ex2);
            }
            finally {
                ((Statistics)this.statistics.get(this.batch)).stopTimer("LOADMILLIS");
                this.c.delete();
            }
        }
    }

    protected void b() {
        this.c = this.b.create(new Object[]{"bulkloaddir", this.k.getName() + this.getBatch().getBatchId() + ".csv"});
        m.debug("Using staging file {}", (Object)this.c.getFile().getPath());
    }
}

