/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.db.bulk;

import com.jumpmind.symmetric.db.bulk.h;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.apache.commons.codec.digest.DigestUtils;
import org.jumpmind.db.platform.DatabaseInfo;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.sql.JdbcSqlTransaction;
import org.jumpmind.security.ISecurityService;
import org.jumpmind.symmetric.io.data.DataContext;
import org.jumpmind.symmetric.io.data.writer.DatabaseWriterSettings;
import org.jumpmind.symmetric.io.data.writer.IDatabaseWriterErrorHandler;
import org.jumpmind.symmetric.io.data.writer.IDatabaseWriterFilter;
import org.jumpmind.symmetric.io.stage.IStagingManager;
import org.jumpmind.symmetric.model.Channel;
import org.jumpmind.symmetric.service.IContextService;
import org.jumpmind.symmetric.service.IParameterService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class j
extends h {
    private static final Logger a = LoggerFactory.getLogger(j.class);
    private static final String F = "SymmetricDSDatabaseScopedCredential";
    private static final String G = "SymmetricDSExternalDataSource";
    private static final String H = "AzureBulkLoadTokenHash";
    private IContextService I;

    public j(IDatabasePlatform symmetricPlatform, IDatabasePlatform targetPlatform, Channel channel, String tablePrefix, IStagingManager stagingManager, List<IDatabaseWriterFilter> filters, List<IDatabaseWriterErrorHandler> errorHandlers, IParameterService parameterService, ISecurityService securityService, DatabaseWriterSettings settings, IContextService contextService) {
        super(symmetricPlatform, targetPlatform, channel, tablePrefix, stagingManager, filters, errorHandlers, parameterService, securityService, settings);
        this.E = false;
        this.I = contextService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open(DataContext context) {
        Statement stmt;
        boolean externalDataSourceExists;
        boolean credentialExists;
        Connection c2;
        block69: {
            Statement stmt2;
            super.open(context);
            String contextHashedAzureTokens = this.I.getString(H);
            String hashedAzureTokens = DigestUtils.sha256Hex((String)(this.C + this.B));
            if (contextHashedAzureTokens != null && !contextHashedAzureTokens.equals(hashedAzureTokens)) {
                a.info("Stored hashed Azure tokens do not match current [stored, current]: " + contextHashedAzureTokens + ", " + hashedAzureTokens);
                contextHashedAzureTokens = null;
            }
            JdbcSqlTransaction jdbcTransaction = (JdbcSqlTransaction)this.getTargetTransaction();
            c2 = jdbcTransaction.getConnection();
            int masterKeyCount = 0;
            String masterKeyCheckSql = "SELECT count(name) FROM sys.symmetric_keys where name = '##MS_DatabaseMasterKey##'";
            try (Statement stmt3 = c2.createStatement();){
                ResultSet rs = stmt3.executeQuery(masterKeyCheckSql);
                while (rs.next()) {
                    masterKeyCount = rs.getInt(1);
                }
            }
            catch (Exception e2) {
                a.info("Unable to check if database master key exist for bulk loading. ", (Throwable)e2);
                throw new RuntimeException(e2);
            }
            if (masterKeyCount == 0) {
                String createMasterKeySql = "CREATE MASTER KEY ENCRYPTION BY PASSWORD='jqkmac3EZQuHKPMrUE57OSOzy2IWOS3'";
                try (Statement stmt4 = c2.createStatement();){
                    stmt4.execute(createMasterKeySql);
                    c2.commit();
                }
                catch (Exception e3) {
                    a.info("Unable to create Azure database master key for bulk loading. ", (Throwable)e3);
                    throw new RuntimeException(e3);
                }
            }
            credentialExists = this.a(c2);
            externalDataSourceExists = this.b(c2);
            if (contextHashedAzureTokens != null) break block69;
            a.debug("New bulk load azure tokens detected, dropping Azure external data source and scoped credential and recreating.");
            String dropDataSourceSql = "drop external data source SymmetricDSExternalDataSource";
            String dropCredentialSql = "drop database scoped credential SymmetricDSDatabaseScopedCredential";
            try {
                stmt2 = c2.createStatement();
                try {
                    if (externalDataSourceExists) {
                        stmt2.execute(dropDataSourceSql);
                        c2.commit();
                        a.debug("Dropping external data source SymmetricDSExternalDataSource");
                        externalDataSourceExists = false;
                    }
                }
                finally {
                    if (stmt2 != null) {
                        stmt2.close();
                    }
                }
                contextHashedAzureTokens = hashedAzureTokens;
                this.I.save(H, contextHashedAzureTokens == null ? "-1" : String.valueOf(contextHashedAzureTokens));
            }
            catch (Exception e4) {
                try {
                    if (e4.getMessage() == null || !e4.getMessage().contains("because it is being used")) {
                        a.debug("Unable to drop data source for bulk loading. ", (Throwable)e4);
                        throw new RuntimeException(e4);
                    }
                    a.debug("Unable to drop data source for bulk loading because it is being used currently. ", (Throwable)e4);
                    externalDataSourceExists = true;
                    contextHashedAzureTokens = hashedAzureTokens;
                    this.I.save(H, contextHashedAzureTokens == null ? "-1" : String.valueOf(contextHashedAzureTokens));
                }
                catch (Throwable throwable) {
                    contextHashedAzureTokens = hashedAzureTokens;
                    this.I.save(H, contextHashedAzureTokens == null ? "-1" : String.valueOf(contextHashedAzureTokens));
                    throw throwable;
                }
            }
            try {
                stmt2 = c2.createStatement();
                try {
                    if (credentialExists) {
                        stmt2.execute(dropCredentialSql);
                        c2.commit();
                        a.debug("Dropping scoped credential SymmetricDSDatabaseScopedCredential");
                        credentialExists = false;
                    }
                }
                finally {
                    if (stmt2 != null) {
                        stmt2.close();
                    }
                }
                contextHashedAzureTokens = hashedAzureTokens;
                this.I.save(H, contextHashedAzureTokens == null ? "-1" : String.valueOf(contextHashedAzureTokens));
            }
            catch (Exception e5) {
                try {
                    if (e5.getMessage() == null || !e5.getMessage().contains("because it is being used")) {
                        a.info("Unable to drop credentials for bulk loading. ", (Throwable)e5);
                        throw new RuntimeException(e5);
                    }
                    a.debug("Unable to drop credentials for bulk loading because it is being used currently. ", (Throwable)e5);
                    credentialExists = true;
                    contextHashedAzureTokens = hashedAzureTokens;
                    this.I.save(H, contextHashedAzureTokens == null ? "-1" : String.valueOf(contextHashedAzureTokens));
                }
                catch (Throwable throwable) {
                    contextHashedAzureTokens = hashedAzureTokens;
                    this.I.save(H, contextHashedAzureTokens == null ? "-1" : String.valueOf(contextHashedAzureTokens));
                    throw throwable;
                }
            }
        }
        if (!credentialExists) {
            String credentialSql = "CREATE DATABASE SCOPED CREDENTIAL SymmetricDSDatabaseScopedCredential WITH  IDENTITY = 'SHARED ACCESS SIGNATURE',  SECRET = '" + this.C + "'";
            try {
                stmt = c2.createStatement();
                try {
                    a.debug("Azure create database scoped credential sql: " + credentialSql);
                    stmt.execute(credentialSql);
                    c2.commit();
                }
                finally {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
            }
            catch (Exception e6) {
                if (e6.getMessage() != null && e6.getMessage().contains("already exists")) {
                    a.debug("Unable to create Azure database scoped credential for bulk loading because it already exists. ", (Throwable)e6);
                }
                throw new RuntimeException(e6);
            }
        }
        if (!externalDataSourceExists) {
            String createDataSourceSql = "CREATE EXTERNAL DATA SOURCE SymmetricDSExternalDataSource    WITH (        TYPE = BLOB_STORAGE,        LOCATION = 'https://" + this.z + ".blob.core.windows.net/" + this.B + "',        CREDENTIAL = SymmetricDSDatabaseScopedCredential    );";
            try {
                stmt = c2.createStatement();
                try {
                    a.debug("Azure create external data source sql: " + createDataSourceSql);
                    stmt.execute(createDataSourceSql);
                    c2.commit();
                }
                finally {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
            }
            catch (Exception e7) {
                if (e7.getMessage() != null && e7.getMessage().contains("already exists")) {
                    a.debug("Unable to create Azure external data source for bulk loading because it already exists. ", (Throwable)e7);
                }
                throw new RuntimeException(e7);
            }
        }
    }

    @Override
    public void b() throws SQLException {
        this.e();
    }

    @Override
    public void a() throws SQLException {
        DatabaseInfo dbInfo = this.getPlatform().getDatabaseInfo();
        String quote = dbInfo.getDelimiterToken();
        String catalogSeparator = dbInfo.getCatalogSeparator();
        String schemaSeparator = dbInfo.getSchemaSeparator();
        String copyCommand = String.format("BULK INSERT " + this.getTargetTable().getQualifiedTableName(quote, catalogSeparator, schemaSeparator) + " FROM '" + this.k, new Object[0]) + "' WITH (DATA_SOURCE = 'SymmetricDSExternalDataSource', FORMAT = 'CSV', FIELDQUOTE = '" + this.n + "', FIELDTERMINATOR='" + this.m + "', ROWTERMINATOR='" + this.l + "'" + (String)(this.o != null && this.o.length() > 0 ? ", CODEPAGE='" + this.o + "'" : "") + ");";
        if (copyCommand != null) {
            a.debug("Azure bulk insert sql: " + copyCommand);
            JdbcSqlTransaction jdbcTransaction = (JdbcSqlTransaction)this.getTargetTransaction();
            Connection c2 = jdbcTransaction.getConnection();
            try (Statement stmt = c2.createStatement();){
                stmt.execute(copyCommand);
            }
            catch (Exception e2) {
                a.info("Unable to run the bulk insert command against Azure.  SQL executed: " + copyCommand, (Throwable)e2);
                throw e2;
            }
        }
    }

    @Override
    public void c() throws SQLException {
        this.g();
    }

    public boolean a(Connection c2) {
        int dbScopedCredentialCount = 0;
        String dataSourceCheckSql = "select count(*) from sys.database_scoped_credentials where name = 'SymmetricDSDatabaseScopedCredential'";
        try {
            Statement stmt = c2.createStatement();
            ResultSet rs = stmt.executeQuery(dataSourceCheckSql);
            while (rs.next()) {
                dbScopedCredentialCount = rs.getInt(1);
            }
            stmt.close();
        }
        catch (Exception e2) {
            a.info("Unable to check if db scoped credential exists for bulk loading. ", (Throwable)e2);
            throw new RuntimeException(e2);
        }
        return dbScopedCredentialCount > 0;
    }

    public boolean b(Connection c2) {
        int externalDataSourceCount = 0;
        String dataSourceCheckSql = "select count(*) from sys.external_data_sources where name = 'SymmetricDSExternalDataSource'";
        try {
            Statement stmt = c2.createStatement();
            ResultSet rs = stmt.executeQuery(dataSourceCheckSql);
            while (rs.next()) {
                externalDataSourceCount = rs.getInt(1);
            }
            stmt.close();
        }
        catch (Exception e2) {
            a.info("Unable to check if external data source exists for bulk loading. ", (Throwable)e2);
            throw new RuntimeException(e2);
        }
        return externalDataSourceCount > 0;
    }
}

