/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.db.bulk;

import java.io.ByteArrayOutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.platform.DatabaseInfo;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.sql.JdbcSqlTransaction;
import org.jumpmind.db.util.BinaryEncoding;
import org.jumpmind.symmetric.csv.CsvWriter;
import org.jumpmind.symmetric.io.AbstractBulkDatabaseWriter;
import org.jumpmind.symmetric.io.data.CsvData;
import org.jumpmind.symmetric.io.data.CsvUtils;
import org.jumpmind.symmetric.io.data.DataEventType;
import org.jumpmind.symmetric.io.data.writer.DatabaseWriterSettings;
import org.jumpmind.symmetric.io.data.writer.IDatabaseWriterFilter;
import org.jumpmind.symmetric.io.stage.IStagedResource;
import org.jumpmind.symmetric.io.stage.IStagingManager;
import org.jumpmind.util.Statistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class i
extends AbstractBulkDatabaseWriter {
    private static final Logger k = LoggerFactory.getLogger(i.class);
    protected int a;
    protected long b;
    protected boolean c;
    protected boolean d;
    protected IStagingManager e;
    protected IStagedResource f;
    protected int g = 0;
    protected long h = 0L;
    protected boolean i;
    protected Table j = null;

    public i(IDatabasePlatform symmetricPlatform, IDatabasePlatform targetPlatform, String tablePrefix, IStagingManager stagingManager, int maxRowsBeforeFlush, long maxBytesBeforeFlush, DatabaseWriterSettings settings, List<IDatabaseWriterFilter> filters) {
        super(symmetricPlatform, targetPlatform, tablePrefix, settings);
        this.a = maxRowsBeforeFlush;
        this.b = maxBytesBeforeFlush;
        this.e = stagingManager;
        this.writerSettings.setDatabaseWriterFilters(filters);
    }

    public boolean start(Table table) {
        this.j = table;
        if (super.start(table) && this.targetTable != null) {
            this.i = false;
            if (this.batch.getBinaryEncoding() != BinaryEncoding.NONE) {
                for (Column column : this.targetTable.getColumns()) {
                    if (!column.isOfBinaryType()) continue;
                    this.i = true;
                    break;
                }
            }
            if (this.f == null) {
                this.b();
            }
        }
        return true;
    }

    public void end(Table table) {
        try {
            this.a();
            if (this.f != null) {
                this.f.close();
                this.f.delete();
            }
        }
        finally {
            super.end(table);
        }
    }

    protected void bulkWrite(CsvData data) {
        if (this.filterBefore(data)) {
            DataEventType dataEventType = data.getDataEventType();
            switch (dataEventType) {
                case INSERT: {
                    ((Statistics)this.statistics.get(this.batch)).startTimer("LOADMILLIS");
                    try {
                        byte[] byteData = null;
                        if (this.i) {
                            String[] parsedData = data.getParsedData("rowData");
                            ByteArrayOutputStream out = new ByteArrayOutputStream();
                            CsvWriter writer = new CsvWriter((Writer)new OutputStreamWriter(out), ',');
                            writer.setEscapeMode(2);
                            writer.setRecordDelimiter('\n');
                            writer.setTextQualifier('\"');
                            writer.setUseTextQualifier(true);
                            writer.setForceQualifier(true);
                            writer.setNullString("\\N");
                            Column[] columns = this.targetTable.getColumns();
                            for (int i2 = 0; i2 < columns.length; ++i2) {
                                if (columns[i2].isOfBinaryType() && parsedData[i2] != null) {
                                    if (i2 > 0) {
                                        out.write(44);
                                    }
                                    out.write(34);
                                    if (this.batch.getBinaryEncoding() == BinaryEncoding.HEX) {
                                        out.write(parsedData[i2].getBytes(Charset.defaultCharset()));
                                    } else if (this.batch.getBinaryEncoding() == BinaryEncoding.BASE64) {
                                        out.write(new String(Hex.encodeHex((byte[])Base64.decodeBase64((byte[])parsedData[i2].getBytes(Charset.defaultCharset())))).getBytes(Charset.defaultCharset()));
                                    }
                                    out.write(34);
                                    continue;
                                }
                                writer.write(parsedData[i2], true);
                                writer.flush();
                            }
                            writer.endRecord();
                            writer.close();
                            byteData = out.toByteArray();
                        } else {
                            String[] rowData = this.getRowData(data, "rowData");
                            String formattedData = CsvUtils.escapeCsvData((String[])rowData, (char)'\n', (char)'\"', (int)1, (String)"\\N");
                            byteData = formattedData.getBytes(Charset.defaultCharset());
                        }
                        this.f.getOutputStream().write(byteData);
                        ++this.g;
                        this.h += (long)byteData.length;
                        break;
                    }
                    catch (Exception ex2) {
                        throw this.getPlatform().getSqlTemplate().translate((Throwable)ex2);
                    }
                    finally {
                        ((Statistics)this.statistics.get(this.batch)).stopTimer("LOADMILLIS");
                        ((Statistics)this.statistics.get(this.batch)).increment("STATEMENTCOUNT");
                        ((Statistics)this.statistics.get(this.batch)).increment("LINENUMBER");
                        ((Statistics)this.statistics.get(this.batch)).stopTimer("LOADMILLIS");
                    }
                }
                default: {
                    this.a();
                    this.writeDefault(data);
                }
            }
            if (this.g >= this.a || this.h >= this.b) {
                this.a();
            }
            this.filterAfter(data);
        }
    }

    protected void a() {
        if (this.g > 0 && this.f != null) {
            this.f.close();
            ((Statistics)this.statistics.get(this.batch)).startTimer("LOADMILLIS");
            JdbcSqlTransaction jdbcTransaction = (JdbcSqlTransaction)this.getTargetTransaction();
            try (Connection c2 = jdbcTransaction.getConnection();
                 Statement stmt = c2.createStatement();){
                DatabaseInfo dbInfo = this.getPlatform().getDatabaseInfo();
                String quote = dbInfo.getDelimiterToken();
                String catalogSeparator = dbInfo.getCatalogSeparator();
                String schemaSeparator = dbInfo.getSchemaSeparator();
                String sql = String.format("IMPORT INTO " + this.getTargetTable().getQualifiedTableName(quote, catalogSeparator, schemaSeparator) + " FROM LOCAL CSV FILE '" + this.f.getFile().getAbsolutePath(), new Object[0]).replace('\\', '/') + "'  COLUMN SEPARATOR = ','  ROW SEPARATOR = 'LF';";
                k.debug(sql);
                stmt.execute(sql);
                this.getTargetTransaction().commit();
            }
            catch (SQLException ex2) {
                throw this.getPlatform().getSqlTemplate().translate((Throwable)ex2);
            }
            finally {
                ((Statistics)this.statistics.get(this.batch)).stopTimer("LOADMILLIS");
                this.f.delete();
                this.b();
                this.g = 0;
                this.h = 0L;
            }
        }
    }

    protected void b() {
        this.f = this.e.create(new Object[]{"bulkloaddir", this.targetTable.getName() + this.getBatch().getBatchId() + ".csv"});
    }
}

