/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.db.bulk;

import com.jumpmind.symmetric.db.bulk.z;
import java.util.List;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.db.ISymmetricDialect;
import org.jumpmind.symmetric.io.data.IDataWriter;
import org.jumpmind.symmetric.io.data.writer.Conflict;
import org.jumpmind.symmetric.io.data.writer.IDatabaseWriterErrorHandler;
import org.jumpmind.symmetric.io.data.writer.IDatabaseWriterFilter;
import org.jumpmind.symmetric.io.data.writer.ResolvedData;
import org.jumpmind.symmetric.io.data.writer.TransformWriter;
import org.jumpmind.symmetric.load.DefaultDataLoaderFactory;
import org.jumpmind.symmetric.service.IParameterService;

public class TiberoBulkDataLoaderFactory
extends DefaultDataLoaderFactory {
    public TiberoBulkDataLoaderFactory(ISymmetricEngine engine) {
        super(engine);
    }

    public String getTypeName() {
        return "tibero_bulk";
    }

    public IDataWriter getDataWriter(String sourceNodeId, ISymmetricDialect symmetricDialect, TransformWriter transformWriter, List<IDatabaseWriterFilter> filters, List<IDatabaseWriterErrorHandler> errorHandlers, List<? extends Conflict> conflictSettings, List<ResolvedData> resolvedData) {
        String dbPassword;
        IParameterService parmService = this.engine.getParameterService();
        String dbUrl = parmService.getString("db.url");
        String dbUser = parmService.getString("db.user");
        if (dbUser != null && dbUser.startsWith("enc:")) {
            dbUser = this.engine.getSecurityService().decrypt(dbUser.substring("enc:".length()));
        }
        if ((dbPassword = parmService.getString("db.password")) != null && dbPassword.startsWith("enc:")) {
            dbPassword = this.engine.getSecurityService().decrypt(dbPassword.substring("enc:".length()));
        }
        String tbLoaderCommand = parmService.getString("tibero.bulk.load.tbloader.cmd");
        String tbLoaderOptions = parmService.getString("tibero.bulk.load.tbloader.options");
        String dbName = parmService.getString("tibero.bulk.load.dbname");
        String lineTerminator = parmService.getString("tibero.bulk.load.line.terminator");
        String fieldTerminator = parmService.getString("tibero.bulk.load.field.terminator");
        boolean delimitTokens = parmService.is("db.delimited.identifier.mode", true);
        return new z(symmetricDialect.getPlatform(), symmetricDialect.getTargetPlatform(), this.engine.getStagingManager(), this.engine.getTablePrefix(), tbLoaderCommand, tbLoaderOptions, dbUser, dbPassword, dbUrl, dbName, null, fieldTerminator, lineTerminator, this.buildDatabaseWriterSettings(filters, errorHandlers, conflictSettings, resolvedData), delimitTokens);
    }

    public boolean isPlatformSupported(IDatabasePlatform platform) {
        return "tibero".equals(platform.getName());
    }
}

