/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.db.bulk;

import com.jumpmind.symmetric.db.bulk.p;
import java.util.List;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.db.ISymmetricDialect;
import org.jumpmind.symmetric.io.data.IDataWriter;
import org.jumpmind.symmetric.io.data.writer.Conflict;
import org.jumpmind.symmetric.io.data.writer.IDatabaseWriterErrorHandler;
import org.jumpmind.symmetric.io.data.writer.IDatabaseWriterFilter;
import org.jumpmind.symmetric.io.data.writer.ResolvedData;
import org.jumpmind.symmetric.io.data.writer.TransformWriter;
import org.jumpmind.symmetric.load.DefaultDataLoaderFactory;
import org.jumpmind.symmetric.service.IParameterService;

public class OracleBulkDataLoaderFactory
extends DefaultDataLoaderFactory {
    public OracleBulkDataLoaderFactory(ISymmetricEngine engine) {
        super(engine);
    }

    public String getTypeName() {
        return "oracle_bulk";
    }

    public IDataWriter getDataWriter(String sourceNodeId, ISymmetricDialect symmetricDialect, TransformWriter transformWriter, List<IDatabaseWriterFilter> filters, List<IDatabaseWriterErrorHandler> errorHandlers, List<? extends Conflict> conflictSettings, List<ResolvedData> resolvedData) {
        String dbPassword;
        IParameterService parmService = this.engine.getParameterService();
        String prefix = "";
        if (parmService.is("load.only")) {
            prefix = "target.";
        }
        String dbUrl = parmService.getString(prefix + "db.url");
        String dbUser = parmService.getString(prefix + "db.user");
        if (dbUser != null && dbUser.startsWith("enc:")) {
            dbUser = this.engine.getSecurityService().decrypt(dbUser.substring("enc:".length()));
        }
        if ((dbPassword = parmService.getString(prefix + "db.password")) != null && dbPassword.startsWith("enc:")) {
            dbPassword = this.engine.getSecurityService().decrypt(dbPassword.substring("enc:".length()));
        }
        String sqlLoaderCommand = parmService.getString("oracle.bulk.load.sqlldr.cmd");
        String sqlLoaderOptions = parmService.getString("oracle.bulk.load.sqlldr.options");
        String sqlLoaderInfileCharset = parmService.getString("oracle.bulk.load.sqlldr.infile.charset");
        String ezConnectString = parmService.getString("oracle.bulk.load.ezconnect");
        String lineTerminator = parmService.getString("oracle.bulk.load.line.terminator");
        String fieldTerminator = parmService.getString("oracle.bulk.load.field.terminator");
        boolean delimitTokens = parmService.is("db.delimited.identifier.mode", true);
        return new p(symmetricDialect.getPlatform(), symmetricDialect.getTargetPlatform(), this.engine.getStagingManager(), this.engine.getTablePrefix(), sqlLoaderCommand, sqlLoaderOptions, dbUser, dbPassword, dbUrl, ezConnectString, sqlLoaderInfileCharset, fieldTerminator, lineTerminator, this.buildDatabaseWriterSettings(filters, errorHandlers, conflictSettings, resolvedData), delimitTokens, filters);
    }

    public boolean isPlatformSupported(IDatabasePlatform platform) {
        return "oracle".equals(platform.getName()) || "oracle122".equals(platform.getName()) || "oracle23".equals(platform.getName());
    }
}

