/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.db.bulk;

import com.jumpmind.symmetric.db.bulk.l;
import com.jumpmind.symmetric.db.bulk.n;
import java.util.List;
import org.apache.commons.text.StringEscapeUtils;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.security.ISecurityService;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.db.ISymmetricDialect;
import org.jumpmind.symmetric.io.data.IDataWriter;
import org.jumpmind.symmetric.io.data.writer.Conflict;
import org.jumpmind.symmetric.io.data.writer.IDatabaseWriterErrorHandler;
import org.jumpmind.symmetric.io.data.writer.IDatabaseWriterFilter;
import org.jumpmind.symmetric.io.data.writer.ResolvedData;
import org.jumpmind.symmetric.io.data.writer.TransformWriter;
import org.jumpmind.symmetric.io.stage.IStagingManager;
import org.jumpmind.symmetric.load.AbstractDataLoaderFactory;
import org.jumpmind.symmetric.load.IDataLoaderFactory;
import org.jumpmind.symmetric.model.Channel;

public class MsSqlBulkDataLoaderFactory
extends AbstractDataLoaderFactory
implements IDataLoaderFactory {
    private IStagingManager stagingManager;
    private ISecurityService securityService;

    public MsSqlBulkDataLoaderFactory(ISymmetricEngine engine) {
        this.stagingManager = engine.getStagingManager();
        this.parameterService = engine.getParameterService();
        this.securityService = engine.getSecurityService();
    }

    public String getTypeName() {
        return "mssql_bulk";
    }

    public IDataWriter getDataWriter(String sourceNodeId, Channel channel, ISymmetricDialect symmetricDialect, TransformWriter transformWriter, List<IDatabaseWriterFilter> filters, List<IDatabaseWriterErrorHandler> errorHandlers, List<? extends Conflict> conflictSettings, List<ResolvedData> resolvedData) {
        int maxRowsBeforeFlush = channel.getMaxBatchSize();
        boolean fireTriggers = this.parameterService.is("mssql.bulk.load.fire.triggers", false);
        String uncPath = this.parameterService.getString("mssql.bulk.load.unc.path");
        String rowTerminator = StringEscapeUtils.unescapeJava((String)this.parameterService.getString("mssql.bulk.load.row.terminator", "\\r\\n"));
        String fieldTerminator = StringEscapeUtils.unescapeJava((String)this.parameterService.getString("mssql.bulk.load.field.terminator", "||"));
        if (this.parameterService.is("mssql.bulk.load.use.bcp")) {
            String dbPassword;
            String prefix = "";
            if (this.parameterService.is("load.only")) {
                prefix = "target.";
            }
            String dbUrl = this.parameterService.getString(prefix + "db.url");
            String dbUser = this.parameterService.getString(prefix + "db.user");
            if (dbUser != null && dbUser.startsWith("enc:")) {
                dbUser = this.securityService.decrypt(dbUser.substring("enc:".length()));
            }
            if ((dbPassword = this.parameterService.getString(prefix + "db.password")) != null && dbPassword.startsWith("enc:")) {
                dbPassword = this.securityService.decrypt(dbPassword.substring("enc:".length()));
            }
            String bcpPath = this.parameterService.getString("mssql.bulk.load.bcp.cmd");
            Boolean useInstance = this.parameterService.is("mssql.bulk.load.bcp.use.instance", true);
            boolean keepNullValues = this.parameterService.is("mssql.bulk.load.bcp.keep.null.values", false);
            boolean trustServerCert = this.parameterService.is("mssql.bulk.load.bcp.trust.server.cert", false);
            boolean useSourceStaging = this.parameterService.is("bcp.bulk.load.use.source.staging");
            boolean useQuotedIdentifiers = this.parameterService.is("mssql.bulk.load.bcp.quoted.identifiers");
            return new l(symmetricDialect.getPlatform(), symmetricDialect.getTargetPlatform(), symmetricDialect.getTablePrefix(), this.stagingManager, filters, maxRowsBeforeFlush, fireTriggers, bcpPath, dbUser, dbPassword, dbUrl, fieldTerminator, rowTerminator, this.buildParameterDatabaseWriterSettings(conflictSettings), useInstance, keepNullValues, trustServerCert, useSourceStaging, useQuotedIdentifiers);
        }
        return new n(symmetricDialect.getPlatform(), symmetricDialect.getTargetPlatform(), symmetricDialect.getTablePrefix(), this.stagingManager, maxRowsBeforeFlush, fireTriggers, uncPath, fieldTerminator, rowTerminator, this.buildParameterDatabaseWriterSettings(conflictSettings));
    }

    public boolean isPlatformSupported(IDatabasePlatform platform) {
        return "mssql2000".equals(platform.getName()) || "mssql2005".equals(platform.getName()) || "mssql2008".equals(platform.getName()) || "mssql2016".equals(platform.getName());
    }
}

