/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.db.bulk;

import com.jumpmind.symmetric.db.bulk.j;
import java.util.List;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.security.ISecurityService;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.db.ISymmetricDialect;
import org.jumpmind.symmetric.io.data.IDataWriter;
import org.jumpmind.symmetric.io.data.writer.Conflict;
import org.jumpmind.symmetric.io.data.writer.IDatabaseWriterErrorHandler;
import org.jumpmind.symmetric.io.data.writer.IDatabaseWriterFilter;
import org.jumpmind.symmetric.io.data.writer.ResolvedData;
import org.jumpmind.symmetric.io.data.writer.TransformWriter;
import org.jumpmind.symmetric.io.stage.IStagingManager;
import org.jumpmind.symmetric.load.AbstractDataLoaderFactory;
import org.jumpmind.symmetric.load.IDataLoaderFactory;
import org.jumpmind.symmetric.model.Channel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MsSqlAzureBulkDataLoaderFactory
extends AbstractDataLoaderFactory
implements IDataLoaderFactory {
    protected final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected ISymmetricEngine engine;
    private IStagingManager stagingManager;
    private ISecurityService securityService;

    public MsSqlAzureBulkDataLoaderFactory(ISymmetricEngine engine) {
        this.engine = engine;
        this.stagingManager = engine.getStagingManager();
        this.securityService = engine.getSecurityService();
        this.parameterService = engine.getParameterService();
    }

    public String getTypeName() {
        return "azure_sql_bulk";
    }

    public IDataWriter getDataWriter(String sourceNodeId, Channel channel, ISymmetricDialect symmetricDialect, TransformWriter transformWriter, List<IDatabaseWriterFilter> filters, List<IDatabaseWriterErrorHandler> errorHandlers, List<? extends Conflict> conflictSettings, List<ResolvedData> resolvedData) {
        return new j(symmetricDialect.getPlatform(), symmetricDialect.getTargetPlatform(), channel, symmetricDialect.getTablePrefix(), this.stagingManager, filters, errorHandlers, this.parameterService, this.securityService, this.buildParameterDatabaseWriterSettings(conflictSettings), this.engine.getContextService());
    }

    public boolean isPlatformSupported(IDatabasePlatform platform) {
        return "mssql".equals(platform.getName());
    }
}

