/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.db.bigquery;

import com.google.cloud.bigquery.BigQuery;
import com.jumpmind.symmetric.db.bigquery.a;
import com.jumpmind.symmetric.db.bigquery.e;
import java.util.List;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.security.ISecurityService;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.db.ISymmetricDialect;
import org.jumpmind.symmetric.io.data.IDataWriter;
import org.jumpmind.symmetric.io.data.writer.Conflict;
import org.jumpmind.symmetric.io.data.writer.IDatabaseWriterErrorHandler;
import org.jumpmind.symmetric.io.data.writer.IDatabaseWriterFilter;
import org.jumpmind.symmetric.io.data.writer.ResolvedData;
import org.jumpmind.symmetric.io.data.writer.TransformWriter;
import org.jumpmind.symmetric.io.stage.IStagingManager;
import org.jumpmind.symmetric.load.AbstractDataLoaderFactory;
import org.jumpmind.symmetric.load.IDataLoaderFactory;
import org.jumpmind.symmetric.model.Channel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BigQueryDataLoaderFactory
extends AbstractDataLoaderFactory
implements IDataLoaderFactory {
    protected final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private IStagingManager stagingManager;
    private ISecurityService securityService;
    private BigQuery bigquery;

    public BigQueryDataLoaderFactory(ISymmetricEngine engine) {
        this.stagingManager = engine.getStagingManager();
        this.parameterService = engine.getParameterService();
        this.securityService = engine.getSecurityService();
        this.bigquery = ((e)engine.getSymmetricDialect().getTargetPlatform()).a();
    }

    public String getTypeName() {
        return "bigquery_bulk";
    }

    public IDataWriter getDataWriter(String sourceNodeId, Channel channel, ISymmetricDialect symmetricDialect, TransformWriter transformWriter, List<IDatabaseWriterFilter> filters, List<IDatabaseWriterErrorHandler> errorHandlers, List<? extends Conflict> conflictSettings, List<ResolvedData> resolvedData) {
        try {
            return new a(symmetricDialect.getPlatform(), symmetricDialect.getTargetPlatform(), channel, symmetricDialect.getTablePrefix(), this.stagingManager, filters, errorHandlers, this.parameterService, this.securityService, this.buildParameterDatabaseWriterSettings(conflictSettings), this.bigquery);
        }
        catch (Exception e2) {
            this.log.warn("Failed to create the big query database writer.", (Throwable)e2);
            if (e2 instanceof RuntimeException) {
                throw (RuntimeException)e2;
            }
            throw new RuntimeException(e2);
        }
    }

    public boolean isPlatformSupported(IDatabasePlatform platform) {
        return "bigquery".equals(platform.getName());
    }
}

