/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.db;

import com.jumpmind.symmetric.console.model.ConsoleRole;
import com.jumpmind.symmetric.console.model.ConsoleUser;
import com.jumpmind.symmetric.console.model.Monitor;
import com.jumpmind.symmetric.console.service.IConsoleUserService;
import com.jumpmind.symmetric.console.service.IMonitorService;
import com.jumpmind.symmetric.console.service.IProConsoleService;
import java.io.IOException;
import java.util.ArrayList;
import org.jumpmind.db.model.Database;
import org.jumpmind.db.model.Table;
import org.jumpmind.extension.IBuiltInExtensionPoint;
import org.jumpmind.properties.TypedProperties;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.common.TableConstants;
import org.jumpmind.symmetric.db.ISymmetricDialect;
import org.jumpmind.symmetric.ext.IDatabaseUpgradeListener;
import org.jumpmind.symmetric.ext.ISymmetricEngineAware;
import org.jumpmind.symmetric.service.IParameterService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class a
implements IBuiltInExtensionPoint,
IDatabaseUpgradeListener,
ISymmetricEngineAware {
    protected final Logger a = LoggerFactory.getLogger(this.getClass());
    protected ISymmetricEngine b;
    protected boolean c;
    protected boolean d;

    public void setSymmetricEngine(ISymmetricEngine engine) {
        this.b = engine;
    }

    public String beforeUpgrade(ISymmetricDialect symmetricDialect, String tablePrefix, Database currentModel, Database desiredModel) throws IOException {
        this.c = this.a(tablePrefix, currentModel, desiredModel);
        this.d = this.a(tablePrefix, currentModel);
        StringBuilder sb = new StringBuilder();
        return sb.toString();
    }

    public String afterUpgrade(ISymmetricDialect symmetricDialect, String tablePrefix, Database model) throws IOException {
        StringBuilder sb = new StringBuilder();
        Table monitorTable = model.findTable(TableConstants.getTableName((String)tablePrefix, (String)"monitor"));
        Table roleTable = model.findTable(TableConstants.getTableName((String)tablePrefix, (String)"console_role"));
        IParameterService parameterService = this.b.getParameterService();
        IMonitorService monitorService = (IMonitorService)this.b.getExtensionService().getExtensionPoint(IMonitorService.class);
        if (monitorTable != null && parameterService.isRegistrationServer()) {
            String externalId = this.b.getParameterService().getExternalId();
            monitorService.saveMonitor(Monitor.createSystemMonitor("CPU", "ALL", "cpu", 90L, 1, 5, 100, 4, false, true), true);
            monitorService.saveMonitor(Monitor.createSystemMonitor("Data Error", "ALL", "batchError", 1L, 1, 1, 300, 0, false, true), true);
            monitorService.saveMonitor(Monitor.createSystemMonitor("Offline", "ALL", "offlineNodes", 1L, 1, 1, 300, 3, false, true), true);
            monitorService.saveMonitor(Monitor.createSystemMonitor("Unrouted", "ALL", "dataUnrouted", 1000L, 1, 1, 200, 2, false, true), true);
            monitorService.saveMonitor(Monitor.createSystemMonitor("Unsent", "ALL", "batchUnsent", 100L, 1, 5, 200, 1, false, true), true);
            monitorService.saveMonitor(Monitor.createSystemMonitor("Disk", "ALL", "disk", 90L, 1, 5, 100, 6, false, true), true);
            monitorService.saveMonitor(Monitor.createSystemMonitor("Memory", "ALL", "memory", 90L, 1, 5, 100, 5, false, true), true);
            monitorService.saveMonitor(Monitor.createSystemMonitor("64-bit JVM", "ALL", "jvm64Bit", 1L, 86400, 1, 100, 7, true, false), true);
            monitorService.saveMonitor(Monitor.createSystemMonitor("JVM Crash", "ALL", "jvmCrash", 1L, 86400, 1, 300, 7, true, false), true);
            monitorService.saveMonitor(Monitor.createSystemMonitor("JVM Out of Memory", "ALL", "jvmOutOfMemory", 1L, 86400, 1, 300, 7, true, false), true);
            monitorService.saveMonitor(Monitor.createSystemMonitor("JVM Threads", "ALL", "jvmThreads", 6L, 1, 1, 200, 7, true, false), true);
            monitorService.saveMonitor(Monitor.createSystemMonitor("Blocked Transactions", "ALL", "block", 300L, 1, 1, 200, 7, true, false), true);
            monitorService.saveMonitor(Monitor.createSystemMonitor("MySQL Mode", "ALL", "mySqlMode", 1L, 86400, 1, 200, 7, true, false), true);
            monitorService.saveMonitor(Monitor.createSystemMonitor("Next Data in Gap", "ALL", "nextDataInGap", 1L, 3600, 1, 300, 7, true, false), true);
            monitorService.saveMonitor(Monitor.createSystemMonitor("Disabled Channels", externalId, "channelsDisabled", 1L, 1, 1, 100, 7, true, false), true);
            monitorService.saveMonitor(Monitor.createSystemMonitor("Max Batch Size", externalId, "maxBatchSize", 10001L, 86400, 1, 100, 7, true, false), true);
            monitorService.saveMonitor(Monitor.createSystemMonitor("Max Data to Route", externalId, "maxDataToRoute", 99999L, 86400, 1, 100, 7, true, false), true);
            monitorService.saveMonitor(Monitor.createSystemMonitor("Max Batch to Send", externalId, "maxBatchToSend", 21L, 86400, 1, 100, 7, true, false), true);
            monitorService.saveMonitor(Monitor.createSystemMonitor("Max Channels", externalId, "maxChannels", 13L, 86400, 1, 100, 7, true, false), true);
            monitorService.saveMonitor(Monitor.createSystemMonitor("Suspended or Ignored Channels", "ALL", "channelSuspend", 1L, 1, 1, 100, 7, true, false), true);
            monitorService.saveMonitor(Monitor.createSystemMonitor("Tables Missing a Primary Key", "ALL", "missingPrimaryKey", 1L, 86400, 1, 200, 7, true, false), true);
            monitorService.saveMonitor(Monitor.createSystemMonitor("Foreign Keys Across Channels", externalId, "channelsForeignKey", 1L, 86400, 1, 300, 7, true, false), true);
            monitorService.saveMonitor(Monitor.createSystemMonitor("Job Trending", "ALL", "jobTrending", 19L, 1, 1, 100, 7, true, false), true);
            monitorService.saveMonitor(Monitor.createSystemMonitor("Jobs", "ALL", "jobError", 1L, 1, 1, 300, 7, false, false), true);
            monitorService.saveMonitor(Monitor.createSystemMonitor("Connection Pool", "ALL", "connectionPool", 1L, 1, 1, 200, 7, true, false), true);
            monitorService.saveMonitor(Monitor.createSystemMonitor("Connection Reset", "ALL", "connectionReset", 1L, 1, 1, 300, 7, true, false), true);
            monitorService.saveMonitor(Monitor.createSystemMonitor("Large Object", "ALL", "lob", 1L, 86400, 1, 200, 7, true, false), true);
            monitorService.saveMonitor(Monitor.createSystemMonitor("Stranded or Expired Data", "ALL", "strandedOrExpiredData", 1L, 14400, 1, 200, 7, true, false), true);
            monitorService.saveMonitor(Monitor.createSystemMonitor("Unknown Certificate Authority", "ALL", "unknownCa", 1L, 1, 1, 300, 7, true, false), true);
            monitorService.saveMonitor(Monitor.createSystemMonitor("Incompatible datetime", "ALL", "incompatibleDatetime", 1L, 86400, 1, 200, 7, true, false), true);
            monitorService.saveMonitor(Monitor.createSystemMonitor("Too Many Form Keys", "ALL", "formKeys", 1L, 1, 1, 200, 7, true, false), true);
            monitorService.saveMonitor(Monitor.createSystemMonitor("Postgres WAL Backlog", "ALL", "postgresWal", 10L, 1, 1, 200, 7, false, false), true);
            monitorService.saveMonitor(Monitor.createSystemMonitor("JVM Out of Memory Monitor", "ALL", "jvmOutOfMemoryMonitor", 1L, 86400, 1, 300, 7, false, false), true);
            monitorService.deleteMonitor("SystemLogMonitor");
            monitorService.deleteMonitor("SystemBatchErrorMonitor");
            monitorService.deleteMonitor("SystemOfflineNodeMonitor");
        }
        IConsoleUserService consoleUserService = (IConsoleUserService)this.b.getExtensionService().getExtensionPoint(IConsoleUserService.class);
        if (roleTable != null && parameterService.isRegistrationServer() && this.c) {
            ArrayList<String> roleDescription = new ArrayList<String>();
            ArrayList<String> roleId = new ArrayList<String>();
            ArrayList parentRoleId = new ArrayList();
            roleDescription.add("Built-in Administration Role");
            roleDescription.add("Built-in Write Role");
            roleDescription.add("Built-in Read Role");
            roleId.add("ADMIN");
            roleId.add("WRITE");
            roleId.add("READ");
            parentRoleId.add(null);
            parentRoleId.add(null);
            parentRoleId.add(null);
            for (int i2 = 0; i2 < roleId.size(); ++i2) {
                ConsoleRole role = new ConsoleRole((String)roleId.get(i2), (String)roleDescription.get(i2));
                role.setParentRoleId((String)parentRoleId.get(i2));
                consoleUserService.save(role);
            }
        }
        if (this.d) {
            IProConsoleService proConsoleService = (IProConsoleService)this.b.getExtensionService().getExtensionPoint(IProConsoleService.class);
            for (ConsoleUser user : consoleUserService.findConsoleUsers()) {
                String userId = user.getUserId();
                TypedProperties settings = proConsoleService.getSettings(userId);
                settings.setProperty("user.default.configure.screen", "Details");
                proConsoleService.saveSettings(settings, userId);
            }
        }
        return sb.toString();
    }

    protected boolean a(String tablePrefix, Database currentModel, Database desiredModel) {
        Table roleTable = currentModel.findTable(TableConstants.getTableName((String)tablePrefix, (String)"console_role"));
        return roleTable == null;
    }

    protected boolean a(String tablePrefix, Database currentModel) {
        Table extractRequestTable = currentModel.findTable(TableConstants.getTableName((String)tablePrefix, (String)"extract_request"));
        return extractRequestTable != null && extractRequestTable.findColumn("extract_thread_id") == null;
    }
}

