/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.db;

import com.jumpmind.symmetric.db.bulk.b;
import com.jumpmind.symmetric.db.bulk.m;
import com.jumpmind.symmetric.db.mongo.f;
import com.jumpmind.symmetric.db.mongo.g;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.platform.ase.AseDatabasePlatform;
import org.jumpmind.db.platform.mssql.MsSql2000DatabasePlatform;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.extract.SelectFromSymDataSource;
import org.jumpmind.symmetric.extract.SelectFromTableEvent;
import org.jumpmind.symmetric.extract.SelectFromTableSource;
import org.jumpmind.symmetric.io.data.DataContext;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.model.OutgoingBatch;
import org.jumpmind.symmetric.model.ProcessInfo;
import org.jumpmind.symmetric.model.TriggerHistory;
import org.jumpmind.symmetric.model.TriggerRouter;

public class ProSelectFromSymDataSource
extends SelectFromSymDataSource {
    protected DataContext dataContext;

    public ProSelectFromSymDataSource(ISymmetricEngine engine, OutgoingBatch outgoingBatch, Node sourceNode, Node targetNode, ProcessInfo processInfo, boolean containsBigLob) {
        super(engine, outgoingBatch, sourceNode, targetNode, processInfo, containsBigLob);
    }

    protected SelectFromTableSource createSelectFromTableSource(SelectFromTableEvent event) {
        IDatabasePlatform platform = this.engine.getTargetDialect().getTargetPlatform();
        if (platform instanceof f) {
            f mongoPlatform = (f)this.engine.getTargetDialect().getTargetPlatform();
            return new g(this.engine, this.outgoingBatch, this.batch, event, mongoPlatform);
        }
        if (platform instanceof MsSql2000DatabasePlatform && this.parameterService.is("mssql.bulk.extract.use.bcp")) {
            return new m(this.engine, this.outgoingBatch, this.batch, event, this.isSingleLocalTarget());
        }
        if (platform instanceof AseDatabasePlatform && this.parameterService.is("ase.bulk.extract.use.bcp")) {
            return new b(this.engine, this.outgoingBatch, this.batch, event, this.isSingleLocalTarget());
        }
        return super.createSelectFromTableSource(event);
    }

    protected boolean isSingleLocalTarget() {
        Boolean isSingleLocalTarget = null;
        if (this.dataContext != null) {
            isSingleLocalTarget = (Boolean)this.dataContext.get("isSingleLocalTarget");
        }
        return isSingleLocalTarget != null ? isSingleLocalTarget : false;
    }

    public void setTargetTableFromTriggerHist(TriggerHistory triggerHistory) {
        TriggerRouter triggerRouter = (TriggerRouter)this.triggerRoutersByTriggerHist.get(triggerHistory.getTriggerHistoryId());
        if (triggerRouter != null) {
            this.targetTable = this.columnsAccordingToTriggerHistory.lookup(triggerRouter.getRouterId(), triggerHistory, true, false, false, true);
        }
    }

    public void setTargetTable(Table targetTable) {
        this.targetTable = targetTable;
    }

    public void setDataContext(DataContext dataContext) {
        this.dataContext = dataContext;
    }
}

