/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.db;

import com.jumpmind.symmetric.console.impl.eV;
import com.jumpmind.symmetric.console.impl.eY;
import com.jumpmind.symmetric.console.impl.fg;
import com.jumpmind.symmetric.console.impl.fh;
import com.jumpmind.symmetric.console.impl.fq;
import com.jumpmind.symmetric.console.impl.fs;
import com.jumpmind.symmetric.console.impl.fy;
import com.jumpmind.symmetric.db.bigquery.BigQueryPlatformFactory;
import com.jumpmind.symmetric.db.bigquery.e;
import com.jumpmind.symmetric.db.databricks.a;
import com.jumpmind.symmetric.db.elasticsearch.ElasticSearchPlatformFactory;
import com.jumpmind.symmetric.db.mongo.f;
import com.jumpmind.symmetric.db.opensearch.OpenSearchPlatformFactory;
import com.jumpmind.symmetric.db.s3.S3PlatformFactory;
import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.jumpmind.db.platform.DatabaseVersion;
import org.jumpmind.db.platform.DdlException;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.platform.IDatabasePlatformFactory;
import org.jumpmind.db.platform.JdbcDatabasePlatformFactory;
import org.jumpmind.db.sql.SqlTemplateSettings;
import org.jumpmind.properties.TypedProperties;

public class ProDatabasePlatformFactory
extends JdbcDatabasePlatformFactory
implements IDatabasePlatformFactory {
    public ProDatabasePlatformFactory() {
        this.addPlatform(this.platforms, "bigquery", e.class);
        this.addPlatform(this.platforms, "db2zos", eY.class);
        this.addPlatform(this.platforms, "db2as400", eV.class);
        this.addPlatform(this.platforms, "snowflake", com.jumpmind.symmetric.db.snowflake.a.class);
        this.addPlatform(this.platforms, "singlestore", fs.class);
        this.addPlatform(this.platforms, "openedge", fh.class);
        this.addPlatform(this.platforms, "tibero", fy.class);
        this.addPlatform(this.platforms, "exasol", fg.class);
        this.addPlatform(this.platforms, "sparksql", com.jumpmind.symmetric.db.sparksql.a.class);
        this.addPlatform(this.platforms, "databricks", a.class);
        this.jdbcSubProtocolToPlatform.put("as400", eV.class);
        this.jdbcSubProtocolToPlatform.put("snowflake", com.jumpmind.symmetric.db.snowflake.a.class);
        this.jdbcSubProtocolToPlatform.put("tibero:thin", fy.class);
    }

    public IDatabasePlatform create(DataSource dataSource, SqlTemplateSettings settings, boolean delimitedIdentifierMode, boolean caseSensitive, boolean isLoadOnly, boolean isLogBased) throws DdlException {
        TypedProperties properties = settings.getProperties();
        String dbUrl = properties.get("db.url");
        String dbDriver = properties.get("db.driver");
        if (dbUrl != null) {
            dbUrl = dbUrl.trim();
        }
        if (dbUrl != null && dbUrl.startsWith("bigquery://")) {
            return new BigQueryPlatformFactory().createDatabasePlatform(settings, properties.get("google.bigquery.project.id"), properties.get("google.bigquery.location", "US"), properties.get("google.bigquery.security.credentials.path"));
        }
        if (dbUrl != null && dbUrl.startsWith("mongodb")) {
            ConnectionString connectionString = new ConnectionString(dbUrl);
            MongoClientSettings mongoSettings = MongoClientSettings.builder().applyConnectionString(connectionString).build();
            return new f(settings, mongoSettings, properties.get("mongodb.default.database"));
        }
        if (dbDriver != null && dbDriver.contains("Cosmos")) {
            String dbPassword = properties.get("db.password");
            return new com.jumpmind.symmetric.db.cosmos.e(settings, dbUrl, dbPassword, properties.get("cosmosdb.default.database"));
        }
        if (dbUrl != null && dbDriver.contains("elasticsearch")) {
            return new ElasticSearchPlatformFactory().createDatabasePlatform(settings, dbUrl);
        }
        if (dbUrl != null && dbDriver.contains("opensearch")) {
            return new OpenSearchPlatformFactory().createDatabasePlatform(settings, dbUrl);
        }
        if (dbDriver != null && dbDriver.contains("s3")) {
            return new S3PlatformFactory().createDatabasePlatform(settings, dbUrl);
        }
        if (dbDriver != null && dbDriver.contains("openedge")) {
            return new fh(dataSource, settings);
        }
        if (dbDriver != null && dbDriver.contains("rabbit")) {
            String dbPassword = properties.get("db.password");
            String dbUser = properties.get("db.user");
            return new fq(settings, dbUrl, dbPassword, dbUser);
        }
        if (dbDriver != null && dbDriver.contains("hive")) {
            return new com.jumpmind.symmetric.db.sparksql.a(dataSource, settings);
        }
        if (dbDriver != null && dbDriver.contains("databricks")) {
            return new a(dataSource, settings);
        }
        return super.create(dataSource, settings, delimitedIdentifierMode, caseSensitive, isLoadOnly, isLogBased);
    }

    protected void determineDatabaseNameVersionSubprotocol(DataSource dataSource, Connection connection, DatabaseMetaData metaData, DatabaseVersion nameVersion) throws SQLException {
        if (nameVersion.getProtocol().equalsIgnoreCase("as400") || nameVersion.getProtocol().equalsIgnoreCase("db2") && nameVersion.getName().equalsIgnoreCase("AS")) {
            nameVersion.setName("db2as400");
        }
        if (nameVersion.getProtocol().equalsIgnoreCase("db2")) {
            String productVersion = metaData.getDatabaseProductVersion();
            if (nameVersion.getName().toUpperCase().indexOf("Z") != -1 || productVersion != null && productVersion.startsWith("DSN")) {
                nameVersion.setName("db2zos");
            }
        }
        if (nameVersion.getProtocol().equalsIgnoreCase("exa")) {
            nameVersion.setName("exasol");
        }
        super.determineDatabaseNameVersionSubprotocol(dataSource, connection, metaData, nameVersion);
    }
}

