/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.db;

import com.jumpmind.symmetric.console.impl.fn;
import com.jumpmind.symmetric.console.impl.fq;
import com.jumpmind.symmetric.console.model.TableGroup;
import com.jumpmind.symmetric.console.service.ITableGroupService;
import com.jumpmind.symmetric.db.bigquery.b;
import com.jumpmind.symmetric.db.databricks.DatabricksDataLoaderFactory;
import com.jumpmind.symmetric.db.databricks.a;
import com.jumpmind.symmetric.db.mongo.c;
import com.jumpmind.symmetric.db.mongo.f;
import com.jumpmind.symmetric.db.opensearch.e;
import com.jumpmind.symmetric.db.s3.d;
import com.jumpmind.symmetric.db.sparksql.SparkSqlDataLoaderFactory;
import java.util.List;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.security.ISecurityService;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.db.ISymmetricDialect;
import org.jumpmind.symmetric.io.data.IDataWriter;
import org.jumpmind.symmetric.io.data.writer.Conflict;
import org.jumpmind.symmetric.io.data.writer.DefaultTransformWriterConflictResolver;
import org.jumpmind.symmetric.io.data.writer.IDatabaseWriterConflictResolver;
import org.jumpmind.symmetric.io.data.writer.IDatabaseWriterErrorHandler;
import org.jumpmind.symmetric.io.data.writer.IDatabaseWriterFilter;
import org.jumpmind.symmetric.io.data.writer.ResolvedData;
import org.jumpmind.symmetric.io.data.writer.TransformWriter;
import org.jumpmind.symmetric.io.stage.IStagingManager;
import org.jumpmind.symmetric.load.DefaultDataLoaderFactory;
import org.jumpmind.symmetric.model.Channel;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.service.INodeService;

public class ProDataLoaderFactory
extends DefaultDataLoaderFactory {
    public ProDataLoaderFactory(ISymmetricEngine engine) {
        super(engine);
    }

    public IDataWriter getDataWriter(String sourceNodeId, Channel channel, ISymmetricDialect symmetricDialect, TransformWriter transformWriter, List<IDatabaseWriterFilter> filters, List<IDatabaseWriterErrorHandler> errorHandlers, List<? extends Conflict> conflictSettings, List<ResolvedData> resolvedData) {
        IDatabasePlatform targetPlatform = symmetricDialect.getTargetPlatform();
        INodeService nodeService = this.engine.getNodeService();
        ITableGroupService tableGroupService = (ITableGroupService)this.engine.getExtensionService().getExtensionPoint(ITableGroupService.class);
        try {
            if (targetPlatform instanceof com.jumpmind.symmetric.db.bigquery.e) {
                return new b(symmetricDialect.getPlatform(), symmetricDialect.getTargetPlatform(), symmetricDialect.getTablePrefix(), (IDatabaseWriterConflictResolver)new DefaultTransformWriterConflictResolver(transformWriter), this.buildDatabaseWriterSettings(filters, errorHandlers, conflictSettings, resolvedData), this.parameterService.getInt("google.bigquery.max.rows.per.rpc", 100));
            }
            if (targetPlatform instanceof f) {
                Node sourceNode = nodeService.findNode(sourceNodeId);
                String sourceNodeGroupId = "";
                if (sourceNode != null) {
                    sourceNodeGroupId = sourceNode.getNodeGroupId();
                }
                Node targetNode = nodeService.findIdentity();
                String targetNodeGroupId = "";
                if (targetNode != null) {
                    targetNodeGroupId = targetNode.getNodeGroupId();
                }
                return new c(symmetricDialect.getPlatform(), symmetricDialect.getTargetPlatform(), symmetricDialect.getTablePrefix(), (IDatabaseWriterConflictResolver)new DefaultTransformWriterConflictResolver(transformWriter), this.buildDatabaseWriterSettings(filters, errorHandlers, conflictSettings, resolvedData), tableGroupService.getTableGroupHierByTableName(sourceNodeGroupId, targetNodeGroupId, TableGroup.WriterType.JSON, true), this.engine.getParameterService());
            }
            if (targetPlatform instanceof com.jumpmind.symmetric.db.cosmos.e) {
                Node sourceNode = nodeService.findNode(sourceNodeId);
                String sourceNodeGroupId = "";
                if (sourceNode != null) {
                    sourceNodeGroupId = sourceNode.getNodeGroupId();
                }
                Node targetNode = nodeService.findIdentity();
                String targetNodeGroupId = "";
                if (targetNode != null) {
                    targetNodeGroupId = targetNode.getNodeGroupId();
                }
                return new com.jumpmind.symmetric.db.cosmos.b(symmetricDialect.getPlatform(), symmetricDialect.getTargetPlatform(), symmetricDialect.getTablePrefix(), (IDatabaseWriterConflictResolver)new DefaultTransformWriterConflictResolver(transformWriter), this.buildDatabaseWriterSettings(filters, errorHandlers, conflictSettings, resolvedData), tableGroupService.getTableGroupHierByTableName(sourceNodeGroupId, targetNodeGroupId, TableGroup.WriterType.JSON, true));
            }
            if (targetPlatform instanceof com.jumpmind.symmetric.db.elasticsearch.e) {
                Node sourceNode = nodeService.findNode(sourceNodeId);
                String sourceNodeGroupId = "";
                if (sourceNode != null) {
                    sourceNodeGroupId = sourceNode.getNodeGroupId();
                }
                Node targetNode = nodeService.findIdentity();
                String targetNodeGroupId = "";
                if (targetNode != null) {
                    targetNodeGroupId = targetNode.getNodeGroupId();
                }
                ISecurityService securityService = this.engine.getSecurityService();
                this.parameterService = this.engine.getParameterService();
                return new com.jumpmind.symmetric.db.elasticsearch.b(symmetricDialect.getPlatform(), symmetricDialect.getTargetPlatform(), symmetricDialect.getTablePrefix(), (IDatabaseWriterConflictResolver)new DefaultTransformWriterConflictResolver(transformWriter), this.buildDatabaseWriterSettings(filters, errorHandlers, conflictSettings, resolvedData), this.parameterService, securityService, tableGroupService.getTableGroupHierByTableName(sourceNodeGroupId, targetNodeGroupId, TableGroup.WriterType.JSON, true));
            }
            if (targetPlatform instanceof d) {
                this.parameterService = this.engine.getParameterService();
                ISecurityService securityService = this.engine.getSecurityService();
                IStagingManager stagingManager = this.engine.getStagingManager();
                return new com.jumpmind.symmetric.db.s3.a(symmetricDialect.getPlatform(), symmetricDialect.getTargetPlatform(), channel, symmetricDialect.getTablePrefix(), this.buildDatabaseWriterSettings(filters, errorHandlers, conflictSettings, resolvedData), this.parameterService, securityService, stagingManager);
            }
            if (targetPlatform instanceof e) {
                ISecurityService securityService = this.engine.getSecurityService();
                this.parameterService = this.engine.getParameterService();
                return new com.jumpmind.symmetric.db.opensearch.b(symmetricDialect.getPlatform(), symmetricDialect.getTargetPlatform(), symmetricDialect.getTablePrefix(), (IDatabaseWriterConflictResolver)new DefaultTransformWriterConflictResolver(transformWriter), this.buildDatabaseWriterSettings(filters, errorHandlers, conflictSettings, resolvedData), this.parameterService, securityService);
            }
            if (targetPlatform instanceof fq) {
                ISecurityService securityService = this.engine.getSecurityService();
                String outputFormat = this.parameterService.getString("rabbitmq.format", "JSON");
                String queueName = this.parameterService.getString("rabbitmq.queue.name");
                String url = this.parameterService.getString("target.db.url");
                String messageBy = this.parameterService.getString("rabbitmq.message.by", "BATCH");
                String queueBy = this.parameterService.getString("rabbitmq.queue.by", "CHANNEL");
                String username = this.parameterService.getString("target.db.user");
                String password = this.parameterService.getString("target.db.password");
                String connectionLabel = "SymmetricDS_" + this.engine.getEngineName();
                boolean useSSL = Boolean.parseBoolean(this.parameterService.getString("rabbitmq.use.ssl"));
                password = securityService.decrypt(password.substring(4));
                return new fn(symmetricDialect.getPlatform(), symmetricDialect.getTargetPlatform(), symmetricDialect.getTablePrefix(), (IDatabaseWriterConflictResolver)new DefaultTransformWriterConflictResolver(transformWriter), this.buildDatabaseWriterSettings(filters, errorHandlers, conflictSettings, resolvedData), outputFormat, queueName, url, messageBy, queueBy, username, password, useSSL, connectionLabel);
            }
            if (targetPlatform instanceof com.jumpmind.symmetric.db.sparksql.a) {
                return new SparkSqlDataLoaderFactory().getDataWriter(sourceNodeId, channel, symmetricDialect, transformWriter, filters, errorHandlers, conflictSettings, resolvedData);
            }
            if (targetPlatform instanceof a) {
                return new DatabricksDataLoaderFactory().getDataWriter(sourceNodeId, channel, symmetricDialect, transformWriter, filters, errorHandlers, conflictSettings, resolvedData);
            }
        }
        catch (Exception e2) {
            this.log.warn("Failed to create writer for platform " + targetPlatform.getClass().getSimpleName(), (Throwable)e2);
            if (e2 instanceof RuntimeException) {
                throw (RuntimeException)e2;
            }
            throw new RuntimeException(e2);
        }
        return super.getDataWriter(sourceNodeId, channel, symmetricDialect, transformWriter, filters, errorHandlers, conflictSettings, resolvedData);
    }
}

