/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.db;

import com.jumpmind.symmetric.console.impl.N;
import com.jumpmind.symmetric.console.impl.fg;
import com.jumpmind.symmetric.console.impl.fq;
import com.jumpmind.symmetric.console.impl.fs;
import com.jumpmind.symmetric.console.impl.fy;
import com.jumpmind.symmetric.db.bigquery.BigQueryDataLoaderFactory;
import com.jumpmind.symmetric.db.bulk.AseBulkDataLoaderFactory;
import com.jumpmind.symmetric.db.bulk.ExasolBulkDataLoaderFactory;
import com.jumpmind.symmetric.db.bulk.MsSqlAzureBulkDataLoaderFactory;
import com.jumpmind.symmetric.db.bulk.MsSqlBulkDataLoaderFactory;
import com.jumpmind.symmetric.db.bulk.MySqlBulkDataLoaderFactory;
import com.jumpmind.symmetric.db.bulk.OracleBulkDataLoaderFactory;
import com.jumpmind.symmetric.db.bulk.PostgresBulkDataLoaderFactory;
import com.jumpmind.symmetric.db.bulk.RedshiftBulkDataLoaderFactory;
import com.jumpmind.symmetric.db.bulk.SnowflakeBulkDataLoaderFactory;
import com.jumpmind.symmetric.db.bulk.TeradataBulkDataLoaderFactory;
import com.jumpmind.symmetric.db.bulk.TiberoBulkDataLoaderFactory;
import com.jumpmind.symmetric.db.cosmos.CosmosDataLoaderFactory;
import com.jumpmind.symmetric.db.databricks.DatabricksDataLoaderFactory;
import com.jumpmind.symmetric.db.databricks.a;
import com.jumpmind.symmetric.db.elasticsearch.ElasticSearchDataLoaderFactory;
import com.jumpmind.symmetric.db.mongo.MongoDataLoaderFactory;
import com.jumpmind.symmetric.db.mongo.f;
import com.jumpmind.symmetric.db.opensearch.OpenSearchDataLoaderFactory;
import com.jumpmind.symmetric.db.opensearch.e;
import com.jumpmind.symmetric.db.sparksql.SparkSqlDataLoaderFactory;
import java.util.List;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.platform.ase.AseDatabasePlatform;
import org.jumpmind.db.platform.mssql.MsSql2000DatabasePlatform;
import org.jumpmind.db.platform.mysql.MySqlDatabasePlatform;
import org.jumpmind.db.platform.oracle.OracleDatabasePlatform;
import org.jumpmind.db.platform.postgresql.PostgreSqlDatabasePlatform;
import org.jumpmind.db.platform.redshift.RedshiftDatabasePlatform;
import org.jumpmind.symmetric.db.ISymmetricDialect;
import org.jumpmind.symmetric.ext.BulkDataLoaderFactory;
import org.jumpmind.symmetric.io.JdbcBatchBulkDatabaseWriter;
import org.jumpmind.symmetric.io.data.IDataWriter;
import org.jumpmind.symmetric.io.data.writer.Conflict;
import org.jumpmind.symmetric.io.data.writer.IDatabaseWriterErrorHandler;
import org.jumpmind.symmetric.io.data.writer.IDatabaseWriterFilter;
import org.jumpmind.symmetric.io.data.writer.ResolvedData;
import org.jumpmind.symmetric.io.data.writer.TransformWriter;
import org.jumpmind.symmetric.model.Channel;

public class ProBulkDataLoaderFactory
extends BulkDataLoaderFactory {
    public IDataWriter getDataWriter(String sourceNodeId, Channel channel, ISymmetricDialect symmetricDialect, TransformWriter transformWriter, List<IDatabaseWriterFilter> filters, List<IDatabaseWriterErrorHandler> errorHandlers, List<? extends Conflict> conflictSettings, List<ResolvedData> resolvedData) {
        IDatabasePlatform platform = this.engine.getTargetDialect().getPlatform();
        String platformName = platform.getName();
        if (this.engine.getParameterService().is("db.jdbc.bulk.execute.batch.override", false)) {
            return new JdbcBatchBulkDatabaseWriter(symmetricDialect.getPlatform(), platform, symmetricDialect.getTablePrefix(), this.buildParameterDatabaseWriterSettings(conflictSettings));
        }
        if (platform instanceof PostgreSqlDatabasePlatform) {
            return new PostgresBulkDataLoaderFactory(this.engine).getDataWriter(sourceNodeId, channel, symmetricDialect, transformWriter, filters, errorHandlers, conflictSettings, resolvedData);
        }
        if (!N.a(this.parameterService)) {
            return super.getDataWriter(sourceNodeId, channel, symmetricDialect, transformWriter, filters, errorHandlers, conflictSettings, resolvedData);
        }
        if (platform instanceof MySqlDatabasePlatform || platform instanceof fs) {
            return new MySqlBulkDataLoaderFactory(this.engine).getDataWriter(sourceNodeId, channel, symmetricDialect, transformWriter, filters, errorHandlers, conflictSettings, resolvedData);
        }
        if (platform instanceof MsSql2000DatabasePlatform) {
            if (((MsSql2000DatabasePlatform)platform).getEngineEdition() == 8) {
                return new MsSqlAzureBulkDataLoaderFactory(this.engine).getDataWriter(sourceNodeId, channel, symmetricDialect, transformWriter, filters, errorHandlers, conflictSettings, resolvedData);
            }
            return new MsSqlBulkDataLoaderFactory(this.engine).getDataWriter(sourceNodeId, channel, symmetricDialect, transformWriter, filters, errorHandlers, conflictSettings, resolvedData);
        }
        if (platform instanceof AseDatabasePlatform) {
            return new AseBulkDataLoaderFactory(this.engine).getDataWriter(sourceNodeId, channel, symmetricDialect, transformWriter, filters, errorHandlers, conflictSettings, resolvedData);
        }
        if (platform instanceof OracleDatabasePlatform) {
            return new OracleBulkDataLoaderFactory(this.engine).getDataWriter(sourceNodeId, symmetricDialect, transformWriter, filters, errorHandlers, conflictSettings, resolvedData);
        }
        if (platform instanceof fy) {
            return new TiberoBulkDataLoaderFactory(this.engine).getDataWriter(sourceNodeId, symmetricDialect, transformWriter, filters, errorHandlers, conflictSettings, resolvedData);
        }
        if (platform instanceof RedshiftDatabasePlatform) {
            return new RedshiftBulkDataLoaderFactory(this.engine).getDataWriter(sourceNodeId, channel, symmetricDialect, transformWriter, filters, errorHandlers, conflictSettings, resolvedData);
        }
        if (platformName != null && platformName.startsWith("teradata")) {
            return new TeradataBulkDataLoaderFactory(this.engine).getDataWriter(sourceNodeId, channel, symmetricDialect, transformWriter, filters, errorHandlers, conflictSettings, resolvedData);
        }
        if (platformName != null && platformName.startsWith("snowflake")) {
            return new SnowflakeBulkDataLoaderFactory(this.engine).getDataWriter(sourceNodeId, channel, symmetricDialect, transformWriter, filters, errorHandlers, conflictSettings, resolvedData);
        }
        if (platform instanceof com.jumpmind.symmetric.db.bigquery.e) {
            return new BigQueryDataLoaderFactory(this.engine).getDataWriter(sourceNodeId, channel, symmetricDialect, transformWriter, filters, errorHandlers, conflictSettings, resolvedData);
        }
        if (platform instanceof f) {
            return new MongoDataLoaderFactory(this.engine).getDataWriter(sourceNodeId, channel, symmetricDialect, transformWriter, filters, errorHandlers, conflictSettings, resolvedData);
        }
        if (platform instanceof com.jumpmind.symmetric.db.elasticsearch.e) {
            return new ElasticSearchDataLoaderFactory(this.engine).getDataWriter(sourceNodeId, channel, symmetricDialect, transformWriter, filters, errorHandlers, conflictSettings, resolvedData);
        }
        if (platform instanceof e) {
            return new OpenSearchDataLoaderFactory(this.engine).getDataWriter(sourceNodeId, channel, symmetricDialect, transformWriter, filters, errorHandlers, conflictSettings, resolvedData);
        }
        if (platform instanceof com.jumpmind.symmetric.db.cosmos.e) {
            return new CosmosDataLoaderFactory().getDataWriter(sourceNodeId, channel, symmetricDialect, transformWriter, filters, errorHandlers, conflictSettings, resolvedData);
        }
        if (platform instanceof fg) {
            return new ExasolBulkDataLoaderFactory(this.engine).getDataWriter(sourceNodeId, channel, symmetricDialect, transformWriter, filters, errorHandlers, conflictSettings, resolvedData);
        }
        if (platform instanceof com.jumpmind.symmetric.db.sparksql.a) {
            return new SparkSqlDataLoaderFactory().getDataWriter(sourceNodeId, channel, symmetricDialect, transformWriter, filters, errorHandlers, conflictSettings, resolvedData);
        }
        if (platform instanceof a) {
            return new DatabricksDataLoaderFactory().getDataWriter(sourceNodeId, channel, symmetricDialect, transformWriter, filters, errorHandlers, conflictSettings, resolvedData);
        }
        return super.getDataWriter(sourceNodeId, channel, symmetricDialect, transformWriter, filters, errorHandlers, conflictSettings, resolvedData);
    }

    public boolean isPlatformSupported(IDatabasePlatform platform) {
        if (platform instanceof fq) {
            return false;
        }
        return super.isPlatformSupported(platform);
    }
}

