/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.ui.graph;

import com.jumpmind.symmetric.console.ui.common.I;
import com.jumpmind.symmetric.console.ui.common.as;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.time.DateUtils;
import org.jumpmind.symmetric.statistic.JobStats;
import org.jumpmind.symmetric.statistic.JobStatsByPeriodMap;
import org.vaadin.addons.chartjs.ChartJs;
import org.vaadin.addons.chartjs.config.ChartConfig;
import org.vaadin.addons.chartjs.config.LineChartConfig;
import org.vaadin.addons.chartjs.data.Dataset;
import org.vaadin.addons.chartjs.data.LineDataset;
import org.vaadin.addons.chartjs.options.InteractionMode;
import org.vaadin.addons.chartjs.options.Position;
import org.vaadin.addons.chartjs.options.Tooltips;
import org.vaadin.addons.chartjs.options.scale.Axis;
import org.vaadin.addons.chartjs.options.scale.CategoryScale;
import org.vaadin.addons.chartjs.options.scale.LinearScale;
import org.vaadin.addons.chartjs.options.types.LineChartOptions;

public class JobStatsGraph
extends HorizontalLayout {
    private static final long g = 1L;
    protected I a;
    protected String b;
    protected ChartJs c;
    protected LineChartConfig d;
    protected List<String> e = new ArrayList<String>();
    protected int f = 60;

    public JobStatsGraph(I controller, String jobName) {
        this.a = controller;
        this.b = jobName;
        this.setSizeFull();
        this.d = new LineChartConfig();
        this.d.data().labelsAsList(this.e);
        ((LineChartOptions)((LineChartOptions)((LineChartOptions)((LineChartOptions)((LineChartOptions)((Tooltips)((LineChartOptions)this.d.options().animation().duration(0).and()).tooltips().mode(InteractionMode.NEAREST).callbacks().label("tooltipItem.yLabel").and()).and()).hover().mode(InteractionMode.DATASET).and()).legend().display(false).and()).scales().add(Axis.X, ((CategoryScale)((CategoryScale)new CategoryScale().display(true).ticks().fontSize(9).and()).scaleLabel().display(false).and()).position(Position.BOTTOM)).add(Axis.Y, ((LinearScale)((LinearScale)new LinearScale().display(true).scaleLabel().display(false).and()).ticks().beginAtZero(true).fontSize(9).and()).position(Position.LEFT)).and()).maintainAspectRatio(false)).done();
        this.c = new ChartJs((ChartConfig)this.d);
        this.c.setSizeFull();
        this.c.getElement().getStyle().set("margin-left", "15px");
        this.addAndExpand(new Component[]{this.c});
    }

    public void refresh(JobStatsByPeriodMap orderedMap) {
        LineDataset dataset = new LineDataset();
        dataset.lineTension(0.0);
        dataset.pointRadius(new Integer[]{0});
        dataset.borderColor("#1676F3");
        dataset.backgroundColor("#1676F3");
        dataset.fill(true);
        dataset.borderWidth(1);
        if (orderedMap != null) {
            for (Object time : orderedMap.keySet()) {
                JobStats stats = (JobStats)orderedMap.get(time);
                dataset.addData(Double.valueOf(stats.getProcessedCount()));
                if (this.e.size() >= orderedMap.size()) continue;
                this.e.add(as.formatDate(this.a, (Date)time, true));
            }
            List statsList = this.a.getSymmetricEngine().getStatisticManager().getWorkingJobStats();
            for (JobStats stats : statsList) {
                if (!stats.getJobName().equals(this.b)) continue;
                dataset.addData(Double.valueOf(stats.getProcessedCount()));
                if (this.e.size() > orderedMap.size()) break;
                this.e.add(as.formatDate(this.a, new Date(), true));
                break;
            }
        } else {
            Date end = new Date();
            Calendar startCal = Calendar.getInstance();
            startCal.add(12, -this.f);
            startCal.set(13, 0);
            startCal.set(14, 0);
            startCal.set(12, this.a(startCal.get(12)));
            int interval = this.f / 120 * 5;
            interval = interval < 5 ? 5 : interval;
            Date periodStart = startCal.getTime();
            while (periodStart.before(end)) {
                dataset.addData(Integer.valueOf(0));
                this.e.add(as.formatDate(this.a, periodStart, true));
                periodStart = DateUtils.addMinutes((Date)periodStart, (int)interval);
            }
        }
        this.d.data().clear();
        this.d.data().addDataset((Dataset)dataset);
        this.c.update();
    }

    protected int a(int value) {
        return 5 * new BigDecimal((double)value / 5.0).setScale(2, RoundingMode.HALF_DOWN).intValue();
    }

    public void setPeriodsInMinutes(int periodsInMinutes) {
        this.f = periodsInMinutes;
    }
}

